/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.cs.redolog.CommitId;
import com.zimbra.cs.redolog.RedoCommitCallback;
import com.zimbra.cs.session.AllAccountsWaitSet;

public class AllAccountsRedoCommitCallback
implements RedoCommitCallback {
    private final String mAccountId;
    private final int mChangeMask;

    private AllAccountsRedoCommitCallback(String accountId, int changeMask) {
        this.mAccountId = accountId;
        this.mChangeMask = changeMask;
    }

    public void callback(CommitId cid) {
        AllAccountsWaitSet.mailboxChangeCommitted(cid.encodeToString(), this.mAccountId, this.mChangeMask);
    }

    public static final AllAccountsRedoCommitCallback getRedoCallbackIfNecessary(String accountId, int changeMask) {
        if (AllAccountsWaitSet.isCallbackNecessary(changeMask)) {
            return new AllAccountsRedoCommitCallback(accountId, changeMask);
        }
        return null;
    }
}

