/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.ldap.LdapEntrySearchFilter;
import com.zimbra.cs.session.AccountSearchParams;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.Session;
import java.util.HashMap;
import java.util.List;

public class AdminSession
extends Session {
    private static final long ADMIN_SESSION_TIMEOUT_MSEC = 600000L;
    private AccountSearchParams mSearchParams;
    private HashMap<String, Object> mData = new HashMap();

    public AdminSession(String accountId) {
        super(accountId, Session.Type.ADMIN);
    }

    protected boolean isMailboxListener() {
        return false;
    }

    protected boolean isRegisteredInCache() {
        return true;
    }

    protected long getSessionIdleLifetime() {
        return 600000L;
    }

    public Object getData(String key) {
        return this.mData.get(key);
    }

    public void setData(String key, Object data) {
        this.mData.put(key, data);
    }

    public void clearData(String key) {
        this.mData.remove(key);
    }

    public void notifyPendingChanges(PendingModifications pns, int changeId, Session source) {
    }

    protected void cleanup() {
    }

    public List searchAccounts(Domain d, String query, String[] attrs, String sortBy, boolean sortAscending, int flags, int offset, int maxResults, NamedEntry.CheckRight rightChecker) throws ServiceException {
        boolean needToSearch;
        AccountSearchParams params = new AccountSearchParams(d, query, attrs, sortBy, sortAscending, flags, maxResults, rightChecker);
        boolean bl = needToSearch = offset == 0 || this.mSearchParams == null || !this.mSearchParams.equals(params);
        if (needToSearch) {
            params.doSearch();
            this.mSearchParams = params;
        }
        return this.mSearchParams.mResult;
    }

    public List searchCalendarResources(Domain d, EntrySearchFilter filter, String[] attrs, String sortBy, boolean sortAscending, int offset, NamedEntry.CheckRight rightChecker) throws ServiceException {
        String query = LdapEntrySearchFilter.toLdapCalendarResourcesFilter(filter);
        return this.searchAccounts(d, query, attrs, sortBy, sortAscending, 8, offset, 0, rightChecker);
    }
}

