/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.session;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

class AccountSearchParams {
    String mDomainId;
    String mQuery;
    String[] mAttrs;
    HashSet mAttrsSet;
    String mSortBy;
    boolean mSortAscending;
    int mFlags;
    int mMaxResult;
    Provisioning.SearchOptions mOptions;
    List mResult;
    NamedEntry.CheckRight mRightChecker;

    AccountSearchParams(Domain d, String query, String[] attrs, String sortBy, boolean sortAscending, int flags, int maxResults, NamedEntry.CheckRight rightChecker) {
        this.mDomainId = d == null ? "" : d.getId();
        this.mQuery = query == null ? "" : query;
        this.mAttrs = new String[attrs == null ? 0 : attrs.length];
        for (int i = 0; i < this.mAttrs.length; ++i) {
            this.mAttrs[i] = attrs[i];
        }
        this.mAttrsSet = new HashSet<String>(Arrays.asList(this.mAttrs));
        this.mSortBy = sortBy == null ? "" : sortBy;
        this.mSortAscending = sortAscending;
        this.mFlags = flags;
        this.mMaxResult = maxResults;
        this.mRightChecker = rightChecker;
        this.mOptions = new Provisioning.SearchOptions();
        this.mOptions.setDomain(d);
        this.mOptions.setFlags(this.mFlags);
        this.mOptions.setMaxResults(maxResults);
        this.mOptions.setQuery(this.mQuery);
        this.mOptions.setReturnAttrs(this.mAttrs);
        this.mOptions.setSortAscending(this.mSortAscending);
        this.mOptions.setSortAttr(this.mSortBy);
        this.mOptions.setConvertIDNToAscii(true);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AccountSearchParams)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AccountSearchParams other = (AccountSearchParams)o;
        return this.mDomainId.equals(other.mDomainId) && this.mQuery.equals(other.mQuery) && this.mAttrsSet.equals(other.mAttrsSet) && this.mSortBy.equals(other.mSortBy) && this.mSortAscending == other.mSortAscending && this.mFlags == other.mFlags;
    }

    public int hashCode() {
        return this.mQuery == null ? "".hashCode() : this.mQuery.hashCode();
    }

    void doSearch() throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        this.mResult = prov.searchDirectory(this.mOptions, false);
        if (this.mRightChecker != null) {
            ArrayList<NamedEntry> allowed = new ArrayList<NamedEntry>();
            for (int i = 0; i < this.mResult.size(); ++i) {
                NamedEntry entry = (NamedEntry)this.mResult.get(i);
                if (!this.mRightChecker.allow(entry)) continue;
                allowed.add(entry);
            }
            this.mResult = allowed;
        }
    }
}

