/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.servlet;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.RemoteIP;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;

public class ZimbraServlet
extends HttpServlet {
    private static final long serialVersionUID = 5025244890767551679L;
    private static Log mLog = LogFactory.getLog(ZimbraServlet.class);
    public static final String COOKIE_ZM_AUTH_TOKEN = "ZM_AUTH_TOKEN";
    public static final String COOKIE_ZM_ADMIN_AUTH_TOKEN = "ZM_ADMIN_AUTH_TOKEN";
    private static final String PARAM_ALLOWED_PORTS = "allowed.ports";
    protected static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    protected static final String ZIMBRA_FAULT_CODE_HEADER = "X-Zimbra-Fault-Code";
    protected static final String ZIMBRA_FAULT_MESSAGE_HEADER = "X-Zimbra-Fault-Message";
    private static final int MAX_PROXY_HOPCOUNT = 3;
    private static Map<String, ZimbraServlet> sServlets = new HashMap<String, ZimbraServlet>();
    private int[] mAllowedPorts;

    protected String getRealmHeader() {
        return "BASIC realm=\"Zimbra\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        try {
            String portsCSV = this.getInitParameter(PARAM_ALLOWED_PORTS);
            if (portsCSV != null) {
                int i;
                String[] vals = portsCSV.split("\\s*,\\s*");
                if (vals == null || vals.length == 0) {
                    throw new ServletException("Must specify comma-separated list of port numbers for allowed.ports parameter");
                }
                ArrayList<Integer> allowedPorts = new ArrayList<Integer>();
                for (i = 0; i < vals.length; ++i) {
                    int port;
                    try {
                        port = Integer.parseInt(vals[i]);
                    }
                    catch (NumberFormatException e) {
                        throw new ServletException("Invalid port number \"" + vals[i] + "\" in " + PARAM_ALLOWED_PORTS + " parameter");
                    }
                    if (port < 0) {
                        throw new ServletException("Invalid port number " + vals[i] + " in " + PARAM_ALLOWED_PORTS + " parameter; port number must be greater than zero");
                    }
                    if (port == 0) continue;
                    allowedPorts.add(port);
                }
                this.mAllowedPorts = new int[allowedPorts.size()];
                for (i = 0; i < allowedPorts.size(); ++i) {
                    this.mAllowedPorts[i] = (Integer)allowedPorts.get(i);
                }
            }
            Map<String, ZimbraServlet> map = sServlets;
            synchronized (map) {
                String name = this.getServletName();
                if (sServlets.containsKey(name)) {
                    Zimbra.halt("Attempted to instantiate a second instance of " + name);
                }
                sServlets.put(this.getServletName(), this);
                mLog.debug("Added " + this.getServletName() + " to the servlet list");
            }
        }
        catch (Throwable t) {
            Zimbra.halt("Unable to initialize servlet " + this.getServletName() + "; halting", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZimbraServlet getServlet(String name) {
        Map<String, ZimbraServlet> map = sServlets;
        synchronized (map) {
            return sServlets.get(name);
        }
    }

    protected boolean isRequestOnAllowedPort(HttpServletRequest request) {
        if (this.mAllowedPorts != null && this.mAllowedPorts.length > 0) {
            int incoming = request.getLocalPort();
            for (int i = 0; i < this.mAllowedPorts.length; ++i) {
                if (this.mAllowedPorts[i] != incoming) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean allowed = this.isRequestOnAllowedPort(request);
        if (!allowed) {
            SoapProtocol soapProto = SoapProtocol.Soap12;
            ServiceException e = ServiceException.FAILURE("Request not allowed on port " + request.getLocalPort(), null);
            ZimbraLog.soap.warn((Object)null, e);
            Element fault = SoapProtocol.Soap12.soapFault(e);
            Element envelope = SoapProtocol.Soap12.soapEnvelope(fault);
            byte[] soapBytes = envelope.toUTF8();
            response.setContentType(soapProto.getContentType());
            response.setBufferSize(soapBytes.length + 2048);
            response.setContentLength(soapBytes.length);
            response.setStatus(500);
            response.getOutputStream().write(soapBytes);
            return;
        }
        super.service(request, response);
    }

    public static AuthToken getAuthTokenFromCookie(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return ZimbraServlet.getAuthTokenFromCookieImpl(req, resp, false, false);
    }

    public static AuthToken getAuthTokenFromCookie(HttpServletRequest req, HttpServletResponse resp, boolean doNotSendHttpError) throws IOException {
        return ZimbraServlet.getAuthTokenFromCookieImpl(req, resp, false, doNotSendHttpError);
    }

    public static AuthToken getAdminAuthTokenFromCookie(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return ZimbraServlet.getAuthTokenFromCookieImpl(req, resp, true, false);
    }

    public static AuthToken getAdminAuthTokenFromCookie(HttpServletRequest req, HttpServletResponse resp, boolean doNotSendHttpError) throws IOException {
        return ZimbraServlet.getAuthTokenFromCookieImpl(req, resp, true, doNotSendHttpError);
    }

    private static AuthToken getAuthTokenFromCookieImpl(HttpServletRequest req, HttpServletResponse resp, boolean isAdminReq, boolean doNotSendHttpError) throws IOException {
        return ZimbraServlet.getAuthTokenFromHttpReq(req, resp, isAdminReq, doNotSendHttpError);
    }

    public static AuthToken getAuthTokenFromHttpReq(HttpServletRequest req, HttpServletResponse resp, boolean isAdminReq, boolean doNotSendHttpError) throws IOException {
        AuthToken authToken = null;
        try {
            authToken = AuthProvider.getAuthToken(req, isAdminReq);
            if (authToken == null) {
                if (!doNotSendHttpError) {
                    resp.sendError(401, "no authtoken cookie");
                }
                return null;
            }
            if (authToken.isExpired()) {
                if (!doNotSendHttpError) {
                    resp.sendError(401, "authtoken expired");
                }
                return null;
            }
            return authToken;
        }
        catch (AuthTokenException e) {
            if (!doNotSendHttpError) {
                resp.sendError(401, "unable to parse authtoken");
            }
            return null;
        }
    }

    protected void proxyServletRequest(HttpServletRequest req, HttpServletResponse resp, String accountId) throws IOException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.id, accountId);
        if (acct == null) {
            resp.sendError(400, "no such user");
            return;
        }
        this.proxyServletRequest(req, resp, prov.getServer(acct), null);
    }

    protected void proxyServletRequest(HttpServletRequest req, HttpServletResponse resp, Server server, AuthToken authToken) throws IOException, ServiceException {
        this.proxyServletRequest(req, resp, server, HttpUtil.getFullRequestURL(req), authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proxyServletRequest(HttpServletRequest req, HttpServletResponse resp, Server server, String uri, AuthToken authToken) throws IOException, ServiceException {
        HttpMethodBase method;
        if (server == null) {
            resp.sendError(400, "cannot find remote server");
            return;
        }
        String url = ZimbraServlet.getProxyUrl(req, server, uri);
        if (req.getMethod().equalsIgnoreCase("GET")) {
            method = new GetMethod(url.toString());
        } else if (req.getMethod().equalsIgnoreCase("POST") || req.getMethod().equalsIgnoreCase("PUT")) {
            PostMethod post = new PostMethod(url.toString());
            post.setRequestEntity(new InputStreamRequestEntity((InputStream)req.getInputStream()));
            method = post;
        } else {
            resp.sendError(500, "cannot proxy method: " + req.getMethod());
            return;
        }
        HttpState state = new HttpState();
        String hostname = method.getURI().getHost();
        if (authToken != null) {
            authToken.encode(state, false, hostname);
        }
        try {
            this.proxyServletRequest(req, resp, method, state);
            Object var11_10 = null;
            method.releaseConnection();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            method.releaseConnection();
            throw throwable;
        }
    }

    private boolean hasZimbraAuthCookie(HttpState state) {
        Cookie[] cookies = state.getCookies();
        if (cookies == null) {
            return false;
        }
        for (Cookie c : cookies) {
            if (!c.getName().equals(COOKIE_ZM_AUTH_TOKEN)) continue;
            return true;
        }
        return false;
    }

    protected void proxyServletRequest(HttpServletRequest req, HttpServletResponse resp, HttpMethod method, HttpState state) throws IOException, ServiceException {
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        String hostname = method.getURI().getHost();
        boolean hasZMAuth = this.hasZimbraAuthCookie(state);
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (cookies[i].getName().equals(COOKIE_ZM_AUTH_TOKEN) && hasZMAuth) continue;
                state.addCookie(new Cookie(hostname, cookies[i].getName(), cookies[i].getValue(), "/", null, false));
            }
        }
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        if (state != null) {
            client.setState(state);
        }
        int hopcount = 0;
        Enumeration enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String hname = (String)enm.nextElement();
            String hlc = hname.toLowerCase();
            if (hlc.equals("x-zimbra-hopcount")) {
                try {
                    hopcount = Math.max(Integer.parseInt(req.getHeader(hname)), 0);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!hlc.startsWith("x-") && !hlc.startsWith("content-") && !hlc.equals("authorization")) continue;
            method.addRequestHeader(hname, req.getHeader(hname));
        }
        if (hopcount >= 3) {
            throw ServiceException.TOO_MANY_HOPS(HttpUtil.getFullRequestURL(req));
        }
        method.addRequestHeader("X-Zimbra-Hopcount", Integer.toString(hopcount + 1));
        int statusCode = -1;
        for (int retryCount = 3; statusCode == -1 && retryCount > 0; --retryCount) {
            statusCode = client.executeMethod(method);
        }
        if (statusCode == -1) {
            resp.sendError(503, "retry limit reached");
            return;
        }
        if (statusCode >= 300) {
            resp.sendError(statusCode, method.getStatusText());
            return;
        }
        Header[] headers = method.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String hname = headers[i].getName();
            String hlc = hname.toLowerCase();
            if (!hlc.startsWith("x-") && (!hlc.startsWith("content-") || hlc.equals("content-length")) && !hlc.startsWith("www-")) continue;
            resp.addHeader(hname, headers[i].getValue());
        }
        InputStream responseStream = method.getResponseBodyAsStream();
        if (responseStream == null || resp.getOutputStream() == null) {
            return;
        }
        ByteUtil.copy(method.getResponseBodyAsStream(), false, (OutputStream)resp.getOutputStream(), false);
    }

    protected boolean isAdminRequest(HttpServletRequest req) throws ServiceException, IOException {
        int adminPort = Provisioning.getInstance().getLocalServer().getIntAttr("zimbraAdminPort", -1);
        if (req.getLocalPort() == adminPort) {
            int mailPort = Provisioning.getInstance().getLocalServer().getIntAttr("zimbraMailPort", -1);
            if (mailPort == adminPort) {
                return ZimbraServlet.getAdminAuthTokenFromCookie(req, null, true) != null;
            }
            return true;
        }
        return false;
    }

    public AuthToken cookieAuthRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        AuthToken at = this.isAdminRequest(req) ? ZimbraServlet.getAdminAuthTokenFromCookie(req, resp, true) : ZimbraServlet.getAuthTokenFromCookie(req, resp, true);
        return at;
    }

    public Account basicAuthRequest(HttpServletRequest req, HttpServletResponse resp, boolean sendChallenge) throws IOException, ServiceException {
        Account acct;
        Domain d;
        String host;
        String userPassedIn;
        if (!AuthProvider.allowBasicAuth(req, this)) {
            return null;
        }
        String auth = req.getHeader("Authorization");
        if (auth == null || !auth.startsWith("Basic ")) {
            if (sendChallenge) {
                resp.addHeader(WWW_AUTHENTICATE_HEADER, this.getRealmHeader());
                resp.sendError(401, "must authenticate");
            }
            return null;
        }
        String userPass = new String(Base64.decodeBase64((byte[])auth.substring(6).getBytes()), "UTF-8");
        int loc = userPass.indexOf(":");
        if (loc == -1) {
            resp.sendError(400, "invalid basic auth credentials");
            return null;
        }
        String user = userPassedIn = userPass.substring(0, loc);
        String pass = userPass.substring(loc + 1);
        Provisioning prov = Provisioning.getInstance();
        if (user.indexOf(64) == -1 && (host = HttpUtil.getVirtualHost(req)) != null && (d = prov.get(Provisioning.DomainBy.virtualHostname, host.toLowerCase())) != null) {
            user = user + "@" + d.getName();
        }
        if ((acct = prov.get(Provisioning.AccountBy.name, user)) == null) {
            if (sendChallenge) {
                resp.addHeader(WWW_AUTHENTICATE_HEADER, this.getRealmHeader());
                resp.sendError(401, "invalid username/password");
            }
            return new ACL.GuestAccount(user, pass);
        }
        try {
            HashMap<String, Object> authCtxt = new HashMap<String, Object>();
            authCtxt.put("ocip", ZimbraServlet.getOrigIp(req));
            authCtxt.put("anp", userPassedIn);
            authCtxt.put("ua", req.getHeader("User-Agent"));
            prov.authAccount(acct, pass, AuthContext.Protocol.http_basic, authCtxt);
        }
        catch (ServiceException se) {
            if (sendChallenge) {
                resp.addHeader(WWW_AUTHENTICATE_HEADER, this.getRealmHeader());
                resp.sendError(401, "invalid username/password");
            }
            return null;
        }
        return acct;
    }

    public static String getAccountPath(Account acct) {
        return "/" + acct.getName();
    }

    public static String getServiceUrl(Account acct, String path) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.getServer(acct);
        if (server == null) {
            throw ServiceException.FAILURE("unable to retrieve server for account" + acct.getName(), null);
        }
        return ZimbraServlet.getServiceUrl(server, prov.getDomain(acct), path + ZimbraServlet.getAccountPath(acct));
    }

    public static String getServiceUrl(Server server, Domain domain, String path) throws ServiceException {
        return URLUtil.getPublicURLForDomain(server, domain, path, true);
    }

    protected static String getProxyUrl(HttpServletRequest req, Server server, String path) throws ServiceException {
        int servicePort = req == null ? -1 : req.getLocalPort();
        Provisioning prov = Provisioning.getInstance();
        Server localServer = prov.getLocalServer();
        if (!prov.isOfflineProxyServer(server) && servicePort == localServer.getIntAttr("zimbraAdminPort", 0)) {
            return URLUtil.getAdminURL(server, path);
        }
        return URLUtil.getServiceURL(server, path, servicePort == localServer.getIntAttr("zimbraMailSSLPort", 0));
    }

    protected void returnError(HttpServletResponse resp, ServiceException e) {
        resp.setHeader(ZIMBRA_FAULT_CODE_HEADER, e.getCode());
        resp.setHeader(ZIMBRA_FAULT_MESSAGE_HEADER, e.getMessage());
        resp.setStatus(500);
    }

    public static String getOrigIp(HttpServletRequest req) {
        RemoteIP remoteIp = new RemoteIP(req, ZimbraServlet.getTrustedIPs());
        return remoteIp.getOrigIP();
    }

    protected void addRemoteIpToLoggingContext(HttpServletRequest req) {
        RemoteIP remoteIp = new RemoteIP(req, ZimbraServlet.getTrustedIPs());
        remoteIp.addToLoggingContext();
    }

    public static RemoteIP.TrustedIPs getTrustedIPs() {
        try {
            Server server = Provisioning.getInstance().getLocalServer();
            return new RemoteIP.TrustedIPs(server.getMultiAttr("zimbraMailTrustedIP"));
        }
        catch (ServiceException e) {
            ZimbraLog.misc.warn((Object)"failed to get trusted IPs, only localhost will be trusted", e);
            return new RemoteIP.TrustedIPs(null);
        }
    }
}

