/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.servlet;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.SSLSocketFactoryManager;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.znative.IO;
import com.zimbra.znative.Process;
import com.zimbra.znative.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServlet;

public class FirstServlet
extends HttpServlet {
    private static final long serialVersionUID = -1660545976482412029L;
    private static Timer sOutputRotationTimer;
    private static boolean mInitialized;
    private static Object mInitializedCondition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            System.err.println("Zimbra server process is running as uid=" + Process.getuid() + " euid=" + Process.geteuid() + " gid=" + Process.getgid() + " egid=" + Process.getegid());
            if (Process.getuid() == 0) {
                Util.halt((String)"can not start server with uid of 0");
            }
            if (Process.geteuid() == 0) {
                Util.halt((String)"can not start server with effective uid of 0");
            }
            if (Process.getgid() == 0) {
                Util.halt((String)"can not start server with gid of 0");
            }
            if (Process.getegid() == 0) {
                Util.halt((String)"can not start server with effective gid of 0");
            }
            System.setProperty("javax.net.ssl.keyStore", LC.mailboxd_keystore.value());
            System.setProperty("javax.net.ssl.keyStorePassword", LC.mailboxd_keystore_password.value());
            System.setProperty("javax.net.ssl.trustStorePassword", LC.mailboxd_truststore_password.value());
            SSLSocketFactoryManager.init();
            Object object = mInitializedCondition;
            synchronized (object) {
                mInitialized = true;
                mInitializedCondition.notifyAll();
            }
            FirstServlet.setupOutputRotation();
        }
        catch (Throwable t) {
            System.err.println("PrivilegedServlet init failed");
            t.printStackTrace(System.err);
            Runtime.getRuntime().halt(1);
        }
    }

    private static void doOutputRotation() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String suffix = sdf.format(now);
        String current = LC.mailboxd_output_file.value();
        String rotateTo = current + "." + suffix;
        try {
            new File(current).renameTo(new File(rotateTo));
            IO.setStdoutStderrTo((String)current);
        }
        catch (IOException ioe) {
            System.err.println("WARN: rotate stdout stderr failed: " + ioe);
            ioe.printStackTrace();
        }
    }

    private static void setupOutputRotation() throws FileNotFoundException, SecurityException, IOException {
        long configMillis = LC.mailboxd_output_rotate_interval.intValue() * 1000;
        if (configMillis <= 0L) {
            return;
        }
        sOutputRotationTimer = new Timer("Timer-OutputRotation");
        GregorianCalendar now = new GregorianCalendar();
        long millisSinceEpoch = now.getTimeInMillis();
        long dstOffset = now.get(16);
        long zoneOffset = now.get(15);
        long millisSinceEpochLocal = millisSinceEpoch + dstOffset + zoneOffset;
        long firstRotateInMillis = configMillis - millisSinceEpochLocal % configMillis;
        TimerTask tt = new TimerTask(){

            public void run() {
                try {
                    FirstServlet.doOutputRotation();
                }
                catch (Throwable e) {
                    if (e instanceof OutOfMemoryError) {
                        Zimbra.halt("Caught out of memory error", e);
                    }
                    System.err.println("WARN: Caught exception in FirstServlet timer " + e);
                    e.printStackTrace();
                }
            }
        };
        sOutputRotationTimer.scheduleAtFixedRate(tt, firstRotateInMillis, configMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForInitialization() {
        Object object = mInitializedCondition;
        synchronized (object) {
            while (!mInitialized) {
                try {
                    mInitializedCondition.wait();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    static {
        mInitialized = false;
        mInitializedCondition = new Object();
    }
}

