/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.servlet;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.LRUMap;

public abstract class DiskCacheServlet
extends ZimbraServlet {
    protected static final String P_CACHE_SIZE = "resource-cache-size";
    protected static final String P_CACHE_DIR = "resource-cache-dir";
    protected static final int DEFAULT_CACHE_SIZE = 1000;
    protected static final String EXT_COMPRESSED = ".gz";
    private int cacheSize;
    private String cacheDirName;
    private File cacheDir;
    private Map<String, File> cache;

    protected DiskCacheServlet(String cacheDirName) {
        this.cacheDirName = cacheDirName;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.createCache();
        this.createCacheDir();
    }

    public void service(ServletRequest req, ServletResponse resp) throws IOException, ServletException {
        if (this.flushCache(req)) {
            return;
        }
        super.service(req, resp);
    }

    protected boolean flushCache(ServletRequest req) {
        Boolean flushCache = (Boolean)req.getAttribute("flushCache");
        if (flushCache != null && flushCache.booleanValue()) {
            if (ZimbraLog.misc.isDebugEnabled()) {
                ZimbraLog.misc.debug("flushing " + ((Object)((Object)this)).getClass().getName() + " cache");
            }
            boolean deleteFiles = true;
            this.clearCache(deleteFiles);
            return true;
        }
        return false;
    }

    protected int getCacheSize() {
        return this.cacheSize;
    }

    protected String getCacheDirName() {
        return this.cacheDirName;
    }

    protected File getCacheDir() {
        return this.cacheDir;
    }

    protected synchronized void putCacheFile(String cacheId, File file) {
        this.cache.put(cacheId, file);
    }

    protected synchronized File getCacheFile(String cacheId) {
        return this.cache.get(cacheId);
    }

    protected synchronized void clearCache(boolean deleteFiles) {
        if (deleteFiles) {
            for (File file : this.cache.values()) {
                file.delete();
                File gzfile = new File(file.getParentFile(), file.getName() + EXT_COMPRESSED);
                if (!gzfile.exists()) continue;
                gzfile.delete();
            }
        }
        this.cache.clear();
    }

    protected void processRemovedFile(String cacheId, File file) {
        file.delete();
    }

    protected void createCache() {
        this.cacheSize = 1000;
        String value = this.getServletConfig().getInitParameter(P_CACHE_SIZE);
        if (value != null) {
            try {
                this.cacheSize = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.cache = new LRUMap(this.cacheSize){

            protected void processRemovedLRU(Object key, Object value) {
                String cacheId = (String)key;
                File file = (File)value;
                DiskCacheServlet.this.processRemovedFile(cacheId, file);
            }
        };
    }

    protected synchronized void createCacheDir() {
        if (this.cacheDir == null) {
            String subDirName = "latest";
            if (this.cacheDirName != null) {
                subDirName = this.cacheDirName + '/' + subDirName;
            }
            subDirName = subDirName.replace('/', File.separatorChar);
            this.cacheDir = new File(this.getTempDir(), subDirName);
            if (this.cacheDir.exists()) {
                Date date = new Date(this.cacheDir.lastModified());
                String timestamp = new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(date);
                File parentDir = this.cacheDir.getParentFile();
                File backupDir = new File(parentDir, timestamp);
                this.cacheDir.renameTo(backupDir);
                this.cacheDir = new File(this.getTempDir(), subDirName);
            }
            this.cacheDir.mkdirs();
            this.cleanupOldCacheDirs();
        }
    }

    protected void cleanupOldCacheDirs() {
        Thread thread = new Thread(){

            public void run() {
                File[] files;
                File cacheDir = DiskCacheServlet.this.getCacheDir().getParentFile();
                for (File file : files = cacheDir.listFiles(new CacheDirFilter())) {
                    if (!file.isDirectory()) continue;
                    this.delete(file);
                }
            }

            public void delete(File dir) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (file.isDirectory()) {
                        this.delete(file);
                        continue;
                    }
                    file.delete();
                }
                dir.delete();
            }
        };
        thread.start();
    }

    protected File getTempDir() {
        File tempDir = null;
        String cacheDirname = this.getServletConfig().getInitParameter(P_CACHE_DIR);
        if (cacheDirname != null) {
            String webappDirname = this.getServletContext().getRealPath("/").replace(File.separatorChar, '/');
            cacheDirname = cacheDirname.replaceAll("\\$\\{webapp\\}", webappDirname).replace('/', File.separatorChar).trim();
            tempDir = new File(cacheDirname);
        } else {
            tempDir = new File(LC.zimbra_tmp_directory.value() + "/diskcache");
        }
        tempDir.mkdirs();
        return tempDir;
    }

    protected void compress(File src) throws IOException {
        File dest = new File(src.getParentFile(), src.getName() + EXT_COMPRESSED);
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(dest));
        this.copy(src, (OutputStream)out);
        out.finish();
        out.close();
    }

    protected void copy(File src, HttpServletResponse resp, boolean compress) throws IOException {
        if (compress) {
            try {
                resp.setHeader("Content-Encoding", "gzip");
            }
            catch (IllegalStateException e) {
                compress = false;
            }
        }
        try {
            Object out = resp.getOutputStream();
            if (compress) {
                File gzSrc = new File(src.getParentFile(), src.getName() + EXT_COMPRESSED);
                if (gzSrc.exists()) {
                    src = gzSrc;
                    compress = false;
                } else {
                    out = new GZIPOutputStream((OutputStream)out);
                }
            }
            this.copy(src, (OutputStream)out);
            if (compress) {
                ((GZIPOutputStream)out).finish();
            }
        }
        catch (IllegalStateException e) {
            PrintWriter out = resp.getWriter();
            this.copy(src, (Writer)out);
        }
    }

    protected void copy(String src, HttpServletResponse resp, boolean compress) throws IOException {
        if (compress) {
            try {
                resp.setHeader("Content-Encoding", "gzip");
            }
            catch (IllegalStateException e) {
                compress = false;
            }
        }
        try {
            Object out = resp.getOutputStream();
            if (compress) {
                out = new GZIPOutputStream((OutputStream)out);
            }
            out.write(src.getBytes("UTF-8"));
            if (compress) {
                ((GZIPOutputStream)out).finish();
            }
        }
        catch (IllegalStateException e) {
            PrintWriter out = resp.getWriter();
            out.write(src);
        }
    }

    protected void copy(File src, OutputStream dest) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(src);
        while ((count = ((InputStream)in).read(buffer)) != -1) {
            dest.write(buffer, 0, count);
        }
        dest.flush();
        ((InputStream)in).close();
    }

    protected void copy(File src, Writer dest) throws IOException {
        int count;
        char[] buffer = new char[4096];
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(src), "UTF-8");
        while ((count = in.read(buffer)) != -1) {
            dest.write(buffer, 0, count);
        }
        dest.flush();
        ((Reader)in).close();
    }

    protected void copy(String src, File dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        this.copy(src, (OutputStream)out);
        ((OutputStream)out).close();
    }

    protected void copy(String src, OutputStream dest) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(dest, "UTF-8");
        out.write(src);
        ((Writer)out).flush();
    }

    protected void copy(String src, Writer dest) throws IOException {
        dest.write(src);
        dest.flush();
    }

    static class CacheDirFilter
    implements FilenameFilter {
        CacheDirFilter() {
        }

        public boolean accept(File dir, String name) {
            return !name.equals("latest");
        }
    }
}

