/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;

public class WikiServiceException
extends ServiceException {
    public static final String NO_SUCH_WIKI = "wiki.NO_SUCH_WIKI";
    public static final String NOT_WIKI_ITEM = "wiki.NOT_WIKI_ITEM";
    public static final String CANNOT_READ = "wiki.CANNOT_READ";
    public static final String INVALID_PATH = "wiki.INVALID_PATH";
    public static final String ERROR = "wiki.ERROR";
    public static final String WIKI_ID = "w";

    private WikiServiceException(String message, String code, boolean isReceiversFault, ServiceException.Argument ... args) {
        super(message, code, isReceiversFault, args);
    }

    private WikiServiceException(String message, String code, boolean isReceiversFault, Throwable cause) {
        super(message, code, isReceiversFault, cause, new ServiceException.Argument[0]);
    }

    public static WikiServiceException NOT_WIKI_ITEM(String w) {
        return new WikiServiceException("not WikiItem: " + w, NO_SUCH_WIKI, false, new ServiceException.Argument(WIKI_ID, w, ServiceException.Argument.Type.STR));
    }

    public static WikiServiceException CANNOT_READ(String w) {
        return new WikiServiceException("cannot read wiki message body: " + w, CANNOT_READ, true, new ServiceException.Argument(WIKI_ID, w, ServiceException.Argument.Type.STR));
    }

    public static WikiServiceException ERROR(String w) {
        return new WikiServiceException("error: " + w, ERROR, false, new ServiceException.Argument[0]);
    }

    public static WikiServiceException ERROR(String w, Throwable cause) {
        return new WikiServiceException("error: " + w, ERROR, false, cause);
    }

    public static WikiServiceException INVALID_PATH(String path) {
        return new WikiServiceException("invalid path: " + path, ERROR, false, new ServiceException.Argument[0]);
    }

    public static WikiServiceException NOT_ENABLED() {
        return new WikiServiceException("notebook is not enabled", ERROR, true, new ServiceException.Argument[0]);
    }

    public static WikiServiceException BRIEFCASES_NOT_ENABLED() {
        return new WikiServiceException("briefcases is not enabled", ERROR, true, new ServiceException.Argument[0]);
    }

    public static class NoSuchWikiException
    extends WikiServiceException {
        public NoSuchWikiException(String w) {
            super("no such wiki: " + w, WikiServiceException.NO_SUCH_WIKI, false, new ServiceException.Argument[]{new ServiceException.Argument(WikiServiceException.WIKI_ID, w, ServiceException.Argument.Type.STR)});
        }
    }
}

