/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;

public abstract class WikiDocumentHandler
extends MailDocumentHandler {
    private static final String[] TARGET_ID_PATH = new String[]{"w", "id"};
    private static final String[] TARGET_FOLDER_PATH = new String[]{"w", "l"};

    protected String[] getProxiedIdPath(Element request) {
        String id = WikiDocumentHandler.getXPath(request, TARGET_ID_PATH);
        if (id == null) {
            return TARGET_FOLDER_PATH;
        }
        return TARGET_ID_PATH;
    }

    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    protected String getAuthor(ZimbraSoapContext zsc) throws ServiceException {
        return WikiDocumentHandler.getAuthenticatedAccount(zsc).getName();
    }

    protected ItemId getRequestedFolder(Element request, ZimbraSoapContext zsc) throws ServiceException {
        for (Element elem : request.listElements()) {
            String fid = elem.getAttribute("l", null);
            if (fid == null) continue;
            return new ItemId(fid, zsc);
        }
        return null;
    }

    protected void checkNotebookEnabled(ZimbraSoapContext zsc) throws ServiceException {
    }

    protected void checkBriefcaseEnabled(ZimbraSoapContext zsc) throws ServiceException {
    }
}

