/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiAction
extends ItemAction {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        String successes;
        ZimbraSoapContext zsc = WikiAction.getZimbraSoapContext(context);
        Element action = request.getElement("action");
        String operation = action.getAttribute("op").toLowerCase();
        if (operation.equals("rename")) {
            Account author = WikiAction.getAuthenticatedAccount(zsc);
            String id = action.getAttribute("id");
            if (id.indexOf(",") > 0) {
                throw WikiServiceException.ERROR("cannot use more than one id for rename");
            }
            String name = action.getAttribute("name");
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(author);
            mbox.rename(WikiAction.getOperationContext(zsc, context), Integer.parseInt(id), (byte)8, name);
            successes = id;
        } else {
            successes = this.handleCommon(context, request, operation, (byte)14);
        }
        Element response = zsc.createElement(MailConstants.WIKI_ACTION_RESPONSE);
        Element act = response.addUniqueElement("action");
        act.addAttribute("id", successes);
        act.addAttribute("op", operation);
        return response;
    }
}

