/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.service.wiki.WikiDocumentHandler;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.cs.wiki.WikiPage;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveWiki
extends WikiDocumentHandler {
    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int itemId;
        ZimbraSoapContext zsc = SaveWiki.getZimbraSoapContext(context);
        OperationContext octxt = SaveWiki.getOperationContext(zsc, context);
        Element msgElem = request.getElement("w");
        String subject = msgElem.getAttribute("name", null);
        String id = msgElem.getAttribute("id", null);
        int ver = (int)msgElem.getAttributeLong("ver", 0L);
        if (id == null) {
            itemId = 0;
        } else {
            ItemId iid = new ItemId(id, zsc);
            itemId = iid.getId();
        }
        ItemId fid = this.getRequestedFolder(request, zsc);
        ByteArrayInputStream is = null;
        try {
            byte[] rawData = msgElem.getText().getBytes("UTF-8");
            is = new ByteArrayInputStream(rawData);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("can't get the content", ioe);
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(zsc.getRequestedAccountId());
        Document wikiItem = null;
        WikiPage.WikiContext ctxt = new WikiPage.WikiContext(octxt, zsc.getAuthToken());
        if (itemId == 0) {
            wikiItem = mbox.createDocument(octxt, fid.getId(), subject, "text/html; charset=utf-8", this.getAuthor(zsc), is, (byte)14);
        } else {
            WikiPage oldPage = WikiPage.findPage(ctxt, zsc.getRequestedAccountId(), itemId);
            if (oldPage == null) {
                throw new WikiServiceException.NoSuchWikiException("page id=" + id + " not found");
            }
            if (oldPage.getLastVersion() != (long)ver) {
                throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument("name", subject, ServiceException.Argument.Type.STR), new ServiceException.Argument("id", oldPage.getId(), ServiceException.Argument.Type.IID), new ServiceException.Argument("ver", oldPage.getLastVersion(), ServiceException.Argument.Type.NUM));
            }
            wikiItem = mbox.addDocumentRevision(octxt, itemId, is, this.getAuthor(zsc), subject);
        }
        Element response = zsc.createElement(MailConstants.SAVE_WIKI_RESPONSE);
        Element m = response.addElement("w");
        m.addAttribute("id", new ItemIdFormatter(zsc).formatItemId(wikiItem));
        m.addAttribute("ver", wikiItem.getVersion());
        return response;
    }
}

