/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.service.wiki.WikiDocumentHandler;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.cs.wiki.WikiPage;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveDocument
extends WikiDocumentHandler {
    private static String[] TARGET_DOC_ID_PATH = new String[]{"doc", "id"};
    private static String[] TARGET_DOC_FOLDER_PATH = new String[]{"doc", "l"};
    private static final String DEFAULT_DOCUMENT_FOLDER = "16";

    @Override
    protected String[] getProxiedIdPath(Element request) {
        String id = SaveDocument.getXPath(request, TARGET_DOC_ID_PATH);
        return id == null ? TARGET_DOC_FOLDER_PATH : TARGET_DOC_ID_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SaveDocument.getZimbraSoapContext(context);
        OperationContext octxt = SaveDocument.getOperationContext(zsc, context);
        Element docElem = request.getElement("doc");
        Doc doc = null;
        Element response = null;
        boolean success = false;
        try {
            String explicitName = docElem.getAttribute("name", null);
            String explicitCtype = docElem.getAttribute("ct", null);
            if (explicitName != null) {
                try {
                    explicitName = explicitName.replaceAll("\\\\", "/");
                    explicitName = explicitName.substring(explicitName.lastIndexOf("/") + 1);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Element attElem = docElem.getOptionalElement("upload");
            Element msgElem = docElem.getOptionalElement("m");
            if (attElem != null) {
                String aid = attElem.getAttribute("id", null);
                FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(zsc.getAuthtokenAccountId(), aid, zsc.getAuthToken());
                doc = new Doc(up, explicitName, explicitCtype);
            } else if (msgElem != null) {
                String part = msgElem.getAttribute("part");
                ItemId iid = new ItemId(msgElem.getAttribute("id"), zsc);
                doc = this.fetchMimePart(octxt, iid, part, explicitName, explicitCtype, zsc.getAuthToken());
            } else {
                String inlineContent = docElem.getAttribute("content");
                doc = new Doc(inlineContent, explicitName, explicitCtype);
            }
            if (doc.name == null || doc.name.trim().equals("")) {
                throw ServiceException.INVALID_REQUEST("missing required attribute: name", null);
            }
            if (doc.contentType == null || doc.contentType.trim().equals("")) {
                throw ServiceException.INVALID_REQUEST("missing required attribute: ct", null);
            }
            ItemId fid = new ItemId(docElem.getAttribute("l", DEFAULT_DOCUMENT_FOLDER), zsc);
            String id = docElem.getAttribute("id", null);
            int itemId = id == null ? 0 : new ItemId(id, zsc).getId();
            int ver = (int)docElem.getAttributeLong("ver", 0L);
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(zsc.getRequestedAccountId());
            Document docItem = null;
            WikiPage.WikiContext ctxt = new WikiPage.WikiContext(octxt, zsc.getAuthToken());
            InputStream is = null;
            try {
                is = doc.getInputStream();
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("can't save document", e);
            }
            if (itemId == 0) {
                try {
                    docItem = mbox.createDocument(octxt, fid.getId(), doc.name, doc.contentType, this.getAuthor(zsc), is, (byte)8);
                }
                catch (ServiceException e) {
                    MailItem item;
                    if (e.getCode().equals("mail.ALREADY_EXISTS") && (item = mbox.getItemByPath(octxt, doc.name, fid.getId())) != null && item instanceof Document) {
                        throw MailServiceException.ALREADY_EXISTS("name " + doc.name + " in folder " + fid.getId(), new ServiceException.Argument("name", doc.name, ServiceException.Argument.Type.STR), new ServiceException.Argument("id", item.getId(), ServiceException.Argument.Type.IID), new ServiceException.Argument("ver", ((Document)item).getVersion(), ServiceException.Argument.Type.NUM));
                    }
                    throw e;
                }
            } else {
                WikiPage oldPage = WikiPage.findPage(ctxt, zsc.getRequestedAccountId(), itemId);
                if (oldPage == null) {
                    throw new WikiServiceException.NoSuchWikiException("page id=" + id + " not found");
                }
                if (oldPage.getLastVersion() != (long)ver) {
                    throw MailServiceException.MODIFY_CONFLICT(new ServiceException.Argument("name", doc.name, ServiceException.Argument.Type.STR), new ServiceException.Argument("id", oldPage.getId(), ServiceException.Argument.Type.IID), new ServiceException.Argument("ver", oldPage.getLastVersion(), ServiceException.Argument.Type.NUM));
                }
                docItem = mbox.addDocumentRevision(octxt, itemId, is, this.getAuthor(zsc), doc.name);
            }
            response = zsc.createElement(MailConstants.SAVE_DOCUMENT_RESPONSE);
            Element m = response.addElement("doc");
            m.addAttribute("id", new ItemIdFormatter(zsc).formatItemId(docItem));
            m.addAttribute("ver", docItem.getVersion());
            m.addAttribute("name", docItem.getName());
            success = true;
            Object var24_26 = null;
            if (success && doc != null) {
                doc.cleanup();
            }
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            if (success && doc != null) {
                doc.cleanup();
            }
            throw throwable;
        }
        return response;
    }

    private Doc fetchMimePart(OperationContext octxt, ItemId itemId, String partId, String name, String ct, AuthToken authtoken) throws ServiceException {
        String accountId = itemId.getAccountId();
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId);
        if (Provisioning.onLocalServer(acct)) {
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
            Message msg = mbox.getMessageById(octxt, itemId.getId());
            try {
                return new Doc(Mime.getMimePart((MimePart)msg.getMimeMessage(), partId), name, ct);
            }
            catch (MessagingException e) {
                throw ServiceException.RESOURCE_UNREACHABLE("can't fetch mime part msgId=" + itemId + ", partId=" + partId, e, new ServiceException.Argument[0]);
            }
            catch (IOException e) {
                throw ServiceException.RESOURCE_UNREACHABLE("can't fetch mime part msgId=" + itemId + ", partId=" + partId, e, new ServiceException.Argument[0]);
            }
        }
        String url = UserServlet.getRestUrl(acct) + "?auth=co&id=" + itemId + "&part=" + partId;
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        GetMethod get = new GetMethod(url);
        authtoken.encode(client, get, false, acct.getAttr("zimbraMailHost"));
        try {
            int statusCode = client.executeMethod(get);
            if (statusCode != 200) {
                throw ServiceException.RESOURCE_UNREACHABLE("can't fetch remote mime part", null, new ServiceException.InternalArgument("url", url, ServiceException.Argument.Type.STR));
            }
            Header ctHeader = get.getResponseHeader("Content-Type");
            ContentType contentType = new ContentType(ctHeader.getValue());
            return new Doc(get.getResponseBodyAsStream(), contentType, name, ct);
        }
        catch (HttpException e) {
            throw ServiceException.PROXY_ERROR(e, url);
        }
        catch (IOException e) {
            throw ServiceException.RESOURCE_UNREACHABLE("can't fetch remote mime part", e, new ServiceException.InternalArgument("url", url, ServiceException.Argument.Type.STR));
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private static class Doc {
        String name;
        String contentType;
        private FileUploadServlet.Upload up;
        private MimePart mp;
        private String sp;
        private InputStream in;

        Doc(MimePart mpart, String filename, String ctype) {
            this.mp = mpart;
            this.name = Mime.getFilename(mpart);
            this.contentType = Mime.getContentType(mpart);
            this.overrideProperties(filename, ctype);
        }

        Doc(FileUploadServlet.Upload upload, String filename, String ctype) {
            this.up = upload;
            this.name = upload.getName();
            this.contentType = upload.getContentType();
            this.overrideProperties(filename, ctype);
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
        }

        Doc(String content, String filename, String ctype) {
            this.sp = content;
            this.overrideProperties(filename, ctype);
            if (this.contentType != null) {
                this.contentType = new ContentType(this.contentType).setParameter("charset", "utf-8").toString();
            }
        }

        Doc(InputStream in, ContentType ct, String filename, String ctype) {
            this.in = in;
            this.name = ct.getParameter("name");
            if (this.name == null) {
                this.name = "New Document";
            }
            this.contentType = ct.getValue();
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
            this.overrideProperties(filename, ctype);
        }

        private void overrideProperties(String filename, String ctype) {
            if (filename != null && !filename.trim().equals("")) {
                this.name = filename;
            }
            if (ctype != null && !ctype.trim().equals("")) {
                this.contentType = ctype;
            }
        }

        public InputStream getInputStream() throws IOException {
            try {
                if (this.up != null) {
                    return this.up.getInputStream();
                }
                if (this.mp != null) {
                    return this.mp.getInputStream();
                }
                if (this.sp != null) {
                    return new ByteArrayInputStream(this.sp.getBytes("utf-8"));
                }
                if (this.in != null) {
                    return this.in;
                }
                throw new IOException("no contents");
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public void cleanup() {
            if (this.up != null) {
                FileUploadServlet.deleteUpload(this.up);
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

