/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.service.wiki.WikiDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDocumentRevisions
extends WikiDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ListDocumentRevisions.getZimbraSoapContext(context);
        Mailbox mbox = ListDocumentRevisions.getRequestedMailbox(zsc);
        OperationContext octxt = ListDocumentRevisions.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element doc = request.getElement("doc");
        String id = doc.getAttribute("id");
        int version = (int)doc.getAttributeLong("ver", -1L);
        int count = (int)doc.getAttributeLong("count", 1L);
        Element response = zsc.createElement(MailConstants.LIST_DOCUMENT_REVISIONS_RESPONSE);
        ItemId iid = new ItemId(id, zsc);
        Document item = mbox.getDocumentById(octxt, iid.getId());
        byte view = mbox.getFolderById(octxt, item.getFolderId()).getDefaultView();
        if (view == 14) {
            this.checkNotebookEnabled(zsc);
        } else if (view == 8) {
            this.checkBriefcaseEnabled(zsc);
        }
        if (version < 0) {
            version = item.getVersion();
        }
        while (version > 0 && count > 0) {
            item = (Document)mbox.getItemRevision(octxt, item.getId(), item.getType(), version);
            ToXML.encodeDocument(response, ifmt, octxt, item);
            --version;
            --count;
        }
        return response;
    }
}

