/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.service.wiki.WikiDocumentHandler;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetWiki
extends WikiDocumentHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        WikiItem wikiItem;
        ZimbraSoapContext zsc = GetWiki.getZimbraSoapContext(context);
        this.checkNotebookEnabled(zsc);
        Mailbox mbox = GetWiki.getRequestedMailbox(zsc);
        OperationContext octxt = GetWiki.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element wElem = request.getElement("w");
        String word = wElem.getAttribute("name", null);
        String id = wElem.getAttribute("id", null);
        int traverse = (int)wElem.getAttributeLong("tr", 0L);
        int version = (int)wElem.getAttributeLong("ver", -1L);
        int count = (int)wElem.getAttributeLong("count", -1L);
        Element response = zsc.createElement(MailConstants.GET_WIKI_RESPONSE);
        if (word != null) {
            ItemId fid = this.getRequestedFolder(request, zsc);
            MailItem item = mbox.getItemByPath(octxt, word, fid.getId());
            if (!(item instanceof WikiItem)) {
                throw WikiServiceException.NOT_WIKI_ITEM(word);
            }
            wikiItem = (WikiItem)item;
        } else {
            if (id == null) throw ServiceException.FAILURE("missing attribute w or id", null);
            ItemId iid = new ItemId(id, zsc);
            wikiItem = mbox.getWikiById(octxt, iid.getId());
        }
        WikiItem rev = wikiItem;
        if (version > 0) {
            rev = (WikiItem)mbox.getItemRevision(octxt, wikiItem.getId(), wikiItem.getType(), version);
        }
        Element wikiElem = ToXML.encodeWiki(response, ifmt, octxt, rev);
        if (count > 1) {
            if (version <= 0) {
                version = wikiItem.getVersion();
            }
            while (--version > 0 && --count > 0) {
                rev = (WikiItem)mbox.getItemRevision(octxt, wikiItem.getId(), wikiItem.getType(), version);
                ToXML.encodeWiki(response, ifmt, octxt, rev);
            }
            return response;
        } else {
            WikiItem revision = version > 0 ? (Document)mbox.getItemRevision(octxt, wikiItem.getId(), wikiItem.getType(), version) : wikiItem;
            try {
                if (revision == null) return response;
                byte[] raw = revision.getContent();
                wikiElem.addAttribute("body", new String(raw, "UTF-8"), Element.Disposition.CONTENT);
                return response;
            }
            catch (IOException ioe) {
                ZimbraLog.wiki.error((Object)"cannot read the wiki message body", ioe);
                throw WikiServiceException.CANNOT_READ(wikiItem.getWikiWord());
            }
        }
    }
}

