/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.wiki.WikiDocumentHandler;
import com.zimbra.cs.wiki.Diff;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffDocument
extends WikiDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DiffDocument.getZimbraSoapContext(context);
        Mailbox mbox = DiffDocument.getRequestedMailbox(zsc);
        OperationContext octxt = DiffDocument.getOperationContext(zsc, context);
        Element doc = request.getElement("doc");
        String idStr = doc.getAttribute("id", null);
        int v1 = (int)doc.getAttributeLong("v1", -1L);
        int v2 = (int)doc.getAttributeLong("v2", -1L);
        ItemId id = new ItemId(idStr, zsc);
        Document r1 = (Document)mbox.getItemRevision(octxt, id.getId(), (byte)-1, v1);
        Document r2 = (Document)mbox.getItemRevision(octxt, id.getId(), (byte)-1, v2);
        byte view = mbox.getFolderById(octxt, r1.getFolderId()).getDefaultView();
        if (view == 14) {
            this.checkNotebookEnabled(zsc);
        } else if (view == 8) {
            this.checkBriefcaseEnabled(zsc);
        }
        Element response = zsc.createElement(MailConstants.DIFF_DOCUMENT_RESPONSE);
        try {
            Collection<Diff.Chunk> diffResult = Diff.getResult(r1.getContentStream(), r2.getContentStream());
            for (Diff.Chunk c : diffResult) {
                Element chunk = response.addElement("chunk");
                chunk.addAttribute("disp", c.disposition.toString());
                chunk.setText(StringUtil.join("\n", c.content));
            }
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("can't diff documents", e);
        }
        return response;
    }
}

