/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.mailbox.MailServiceException;
import java.util.Enumeration;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class SyncToken
implements Cloneable,
Comparable {
    private int mChangeId;
    private int mOffsetInNext = -1;

    public SyncToken(int changeid) {
        assert (changeid >= 0);
        this.mChangeId = changeid;
    }

    public SyncToken(int changeid, int offsetInNextChange) {
        assert (changeid >= 0 && offsetInNextChange >= 0);
        this.mChangeId = changeid;
        this.mOffsetInNext = offsetInNextChange;
    }

    public SyncToken(String s) throws ServiceException {
        int idx = s.indexOf(45);
        if (idx < 0) {
            this.mChangeId = Integer.parseInt(s);
        } else {
            if (idx == s.length() - 1) {
                throw MailServiceException.INVALID_SYNC_TOKEN(s);
            }
            String lhs = s.substring(0, idx);
            this.mChangeId = Integer.parseInt(lhs);
            String rhs = s.substring(idx + 1);
            this.mOffsetInNext = Integer.parseInt(rhs);
            if (this.mOffsetInNext < 0) {
                throw MailServiceException.INVALID_SYNC_TOKEN(s);
            }
        }
    }

    public int getChangeId() {
        return this.mChangeId;
    }

    public boolean hasOffsetInNext() {
        return this.mOffsetInNext > 0;
    }

    public int getOffsetInNext() {
        return this.mOffsetInNext;
    }

    public String toString() {
        if (this.mOffsetInNext < 0) {
            return Integer.toString(this.mChangeId);
        }
        return this.mChangeId + "-" + this.mOffsetInNext;
    }

    public boolean after(int changeId) {
        return this.mChangeId >= changeId;
    }

    public boolean after(int changeId, int offset) {
        if (this.mChangeId < changeId) {
            return false;
        }
        if (this.mChangeId > changeId) {
            return true;
        }
        return this.mOffsetInNext >= offset;
    }

    public boolean after(SyncToken other) {
        if (other.mOffsetInNext >= 0) {
            return this.after(other.mChangeId, other.mOffsetInNext);
        }
        return this.after(other.mChangeId);
    }

    public SyncToken clone() {
        if (this.mOffsetInNext >= 0) {
            return new SyncToken(this.mChangeId, this.mOffsetInNext);
        }
        return new SyncToken(this.mChangeId);
    }

    public int compareTo(Object arg0) {
        SyncToken other = (SyncToken)arg0;
        int diff = this.mChangeId - other.mChangeId;
        if (diff == 0) {
            if (this.mOffsetInNext == -1 && other.mOffsetInNext == -1) {
                return 0;
            }
            if (this.mOffsetInNext >= 0 && other.mOffsetInNext == -1) {
                return 1;
            }
            if (this.mOffsetInNext == -1 && other.mOffsetInNext >= 0) {
                return -1;
            }
            return this.mOffsetInNext - other.mOffsetInNext;
        }
        return diff;
    }

    public static void main(String[] args) {
        CliUtil.toolSetup("DEBUG");
        TestSuite suite = new TestSuite(Tester.class);
        TestResult results = new TestResult();
        suite.run(results);
        if (!results.wasSuccessful()) {
            System.out.println("\n**************************");
            System.out.println("TEST FAILURES:");
            System.out.println("**************************");
        }
        if (results.failureCount() > 0) {
            Enumeration failures = results.failures();
            while (failures.hasMoreElements()) {
                TestFailure error = (TestFailure)failures.nextElement();
                System.out.println("--> Test Failure: " + error.trace() + error.thrownException());
                System.out.print("\n");
            }
        }
        if (results.errorCount() > 0) {
            Enumeration errors = results.errors();
            while (errors.hasMoreElements()) {
                TestFailure failure = (TestFailure)errors.nextElement();
                System.out.println("--> Test Error: " + failure.trace() + failure.thrownException() + " at ");
                failure.thrownException().printStackTrace();
                System.out.print("\n");
            }
        }
        if (results.wasSuccessful()) {
            System.out.println("\n**************************");
            System.out.println("Tests SUCCESSFUL!");
            System.out.println("**************************");
        }
    }

    public static class Tester
    extends TestCase {
        public void testSyncToken() throws ServiceException {
            SyncToken one = new SyncToken(1);
            SyncToken two = new SyncToken(2);
            SyncToken three = new SyncToken(3);
            SyncToken two_one = new SyncToken(2, 1);
            SyncToken two_two = new SyncToken(2, 2);
            SyncToken three_one = new SyncToken(3, 1);
            Tester.assertTrue((boolean)two.after(one));
            Tester.assertTrue((boolean)three.after(two));
            Tester.assertTrue((boolean)three.after(one));
            Tester.assertFalse((boolean)one.after(three));
            Tester.assertTrue((boolean)two_one.after(two));
            Tester.assertFalse((boolean)two.after(two_one));
            Tester.assertTrue((boolean)two_two.after(two_one));
            Tester.assertFalse((boolean)two_one.after(two_two));
            Tester.assertTrue((boolean)three_one.after(three));
            Tester.assertTrue((boolean)three_one.after(two));
            Tester.assertFalse((boolean)three.after(three_one));
            Tester.assertFalse((boolean)one.after(three_one));
        }
    }
}

