/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.sun.mail.smtp.SMTPMessage;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.BlobDataSource;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.util.JMSession;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpamHandler {
    private static Log mLog = LogFactory.getLog(SpamHandler.class);
    private static SpamHandler sSpamHandler;
    private String mIsSpamAccount;
    private String mIsNotSpamAccount;
    private InternetAddress mIsSpamAddress;
    private InternetAddress mIsNotSpamAddress;
    private Thread mSpamHandlerThread;
    private String mEnvelopeFrom;
    private String mSenderHeader;
    private String mTypeHeader;
    private String mTypeSpam;
    private String mTypeHam;
    private boolean mAddOrigIp;
    private static final int mSpamReportQueueSize;
    private Object mSpamReportQueueLock = new Object();
    List<SpamReport> mSpamReportQueue = new ArrayList<SpamReport>(mSpamReportQueueSize);
    private static String sSpamHeaderValue;
    private static Pattern sSpamPattern;

    public static synchronized SpamHandler getInstance() {
        if (sSpamHandler == null) {
            sSpamHandler = new SpamHandler();
        }
        return sSpamHandler;
    }

    public SpamHandler() {
        Config config;
        try {
            config = Provisioning.getInstance().getConfig();
        }
        catch (ServiceException se) {
            ZimbraLog.misc.warn((Object)"exception configuring spam/notspam", se);
            return;
        }
        this.mIsSpamAccount = config.getAttr("zimbraSpamIsSpamAccount", null);
        if (this.mIsSpamAccount == null) {
            if (mLog.isDebugEnabled()) {
                mLog.debug("zimbraSpamIsSpamAccount is not configured");
            }
        } else {
            try {
                this.mIsSpamAddress = new InternetAddress(this.mIsSpamAccount, true);
            }
            catch (AddressException ae) {
                ZimbraLog.misc.warn((Object)("exception parsing zimbraSpamIsSpamAccount " + this.mIsSpamAccount), ae);
            }
        }
        this.mIsNotSpamAccount = config.getAttr("zimbraSpamIsNotSpamAccount", null);
        if (this.mIsNotSpamAccount == null) {
            if (mLog.isDebugEnabled()) {
                mLog.debug("zimbraSpamIsNotSpamAccount is not configured");
            }
        } else {
            try {
                this.mIsNotSpamAddress = new InternetAddress(this.mIsNotSpamAccount, true);
            }
            catch (AddressException ae) {
                ZimbraLog.misc.warn((Object)("exception parsing zimbraSpamIsNotSpamAccount " + this.mIsNotSpamAccount), ae);
            }
        }
        this.mEnvelopeFrom = config.getAttr("zimbraSpamReportEnvelopeFrom", "<>");
        this.mSenderHeader = config.getAttr("zimbraSpamReportSenderHeader", "X-Zimbra-Spam-Report-Sender");
        this.mTypeHeader = config.getAttr("zimbraSpamReportTypeHeader", "X-Zimbra-Spam-Report-Type");
        this.mTypeSpam = config.getAttr("zimbraSpamReportTypeSpam", "spam");
        this.mTypeHam = config.getAttr("zimbraSpamReportTypeHam", "ham");
        this.mAddOrigIp = config.getBooleanAttr("zimbraSmtpSendAddOriginatingIP", true);
        if (this.mIsSpamAddress != null || this.mIsNotSpamAddress != null) {
            Runnable r = new Runnable(){

                public void run() {
                    SpamHandler.this.reportLoop();
                }
            };
            this.mSpamHandlerThread = new Thread(r);
            this.mSpamHandlerThread.setName("Junk-NotJunk-Handler");
            this.mSpamHandlerThread.setDaemon(true);
            this.mSpamHandlerThread.start();
        }
    }

    private void sendReport(SpamReport sr) throws ServiceException, MessagingException {
        String isSpamString = sr.mIsSpam ? this.mTypeSpam : this.mTypeHam;
        InternetAddress toAddress = sr.mIsSpam ? this.mIsSpamAddress : this.mIsNotSpamAddress;
        SMTPMessage out = new SMTPMessage(JMSession.getSession());
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(sr.mMailboxId);
        com.zimbra.cs.mailbox.Message msg = mbox.getMessageById(null, sr.mMessageId);
        MimeMultipart mmp = null;
        mmp = new MimeMultipart("mixed");
        out.setContent((Multipart)mmp);
        MimeBodyPart infoPart = new MimeBodyPart();
        infoPart.setHeader("Content-Description", "Zimbra spam classification report");
        StringBuffer sb = new StringBuffer(128);
        sb.append("Classified-By: ").append(sr.mAccountName).append("\r\n");
        sb.append("Classified-As: ").append(isSpamString).append("\r\n");
        infoPart.setContent((Object)sb.toString(), "text/plain");
        mmp.addBodyPart((BodyPart)infoPart);
        MailboxBlob blob = msg.getBlob();
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler(new BlobDataSource(blob)));
        mbp.setHeader("Content-Type", "message/rfc822");
        mbp.setHeader("Content-Disposition", "attachment");
        mmp.addBodyPart((BodyPart)mbp);
        out.addHeader(this.mSenderHeader, sr.mAccountName);
        out.addHeader(this.mTypeHeader, isSpamString);
        if (this.mAddOrigIp && sr.mOrigIp != null) {
            out.addHeader("X-Originating-IP", MailSender.formatXOrigIpHeader(sr.mOrigIp));
        }
        out.setRecipient(Message.RecipientType.TO, (Address)toAddress);
        out.setEnvelopeFrom(this.mEnvelopeFrom);
        out.setSubject("zimbra-spam-report: " + sr.mAccountName + ": " + isSpamString);
        Transport.send((Message)out);
        ZimbraLog.misc.info("Sent " + sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void reportLoop() {
        block7: while (true) {
            workQueue = null;
            var2_2 = this.mSpamReportQueueLock;
            synchronized (var2_2) {
                while (this.mSpamReportQueue.size() == 0) {
                    try {
                        this.mSpamReportQueueLock.wait();
                    }
                    catch (InterruptedException ie) {
                        ZimbraLog.misc.warn((Object)"SpamHandler interrupted", ie);
                    }
                }
                workQueue = this.mSpamReportQueue;
                this.mSpamReportQueue = new ArrayList<SpamReport>(SpamHandler.mSpamReportQueueSize);
            }
            if (workQueue == null) {
                if (!ZimbraLog.misc.isDebugEnabled()) continue;
                ZimbraLog.misc.debug("SpamHandler nothing to drain");
                continue;
            }
            i$ = workQueue.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block7;
                sr = i$.next();
                try {
                    this.sendReport(sr);
                    continue;
                }
                catch (Exception e) {
                    ZimbraLog.misc.warn((Object)("exception occurred sending spam report " + sr), e);
                    continue;
                }
                break;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(OperationContext octxt, String accountName, Mailbox mbox, List<com.zimbra.cs.mailbox.Message> msgs, boolean isSpam) {
        String origIp = octxt == null ? null : octxt.getRequestIP();
        Object object = this.mSpamReportQueueLock;
        synchronized (object) {
            for (com.zimbra.cs.mailbox.Message msg : msgs) {
                SpamReport sr = new SpamReport(accountName, mbox.getId(), msg.getId(), isSpam, origIp);
                if (this.mSpamReportQueue.size() > mSpamReportQueueSize) {
                    ZimbraLog.misc.warn("SpamHandler queue size " + this.mSpamReportQueue.size() + " too large, ignored " + sr);
                    continue;
                }
                this.mSpamReportQueue.add(sr);
                if (!ZimbraLog.misc.isDebugEnabled()) continue;
                ZimbraLog.misc.debug("SpamHandler enqueued " + sr);
            }
            this.mSpamReportQueueLock.notify();
        }
    }

    public void handle(OperationContext octxt, Mailbox mbox, int id, byte type, boolean isSpam) throws ServiceException {
        if (isSpam && this.mIsSpamAddress == null) {
            if (mLog.isDebugEnabled()) {
                mLog.debug("isSpam, but isSpamAddress is null, nothing to do");
            }
            return;
        }
        if (!isSpam && this.mIsNotSpamAddress == null) {
            if (mLog.isDebugEnabled()) {
                mLog.debug("isNotSpam, but isNotSpamAddress is null, nothing to do");
            }
            return;
        }
        String accountName = null;
        accountName = mbox.getAccount().getName();
        ArrayList<com.zimbra.cs.mailbox.Message> msgs = null;
        if (type == 5) {
            msgs = new ArrayList<com.zimbra.cs.mailbox.Message>();
            msgs.add(mbox.getMessageById(null, id));
        } else if (type == 4) {
            msgs = mbox.getMessagesByConversation(null, id);
        } else {
            ZimbraLog.misc.warn("SpamHandler called on unhandled item type=" + MailItem.getNameForType(type) + " account=" + accountName + " id=" + id);
            return;
        }
        this.enqueue(octxt, accountName, mbox, msgs, isSpam);
    }

    public static boolean isSpam(MimeMessage msg) {
        try {
            Matcher m;
            String val;
            Provisioning prov = Provisioning.getInstance();
            String spamHeader = prov.getConfig().getAttr("zimbraSpamHeader", null);
            if (StringUtil.isNullOrEmpty(spamHeader)) {
                return false;
            }
            String spamHeaderValue = prov.getConfig().getAttr("zimbraSpamHeaderValue", null);
            if (StringUtil.isNullOrEmpty(spamHeaderValue)) {
                return false;
            }
            if (!spamHeaderValue.equals(sSpamHeaderValue)) {
                sSpamHeaderValue = spamHeaderValue;
                sSpamPattern = Pattern.compile(spamHeaderValue);
            }
            if ((val = Mime.getHeader(msg, spamHeader)) != null && (m = sSpamPattern.matcher(val)).matches()) {
                return true;
            }
        }
        catch (Exception e) {
            ZimbraLog.mailbox.warn((Object)"Unable to determine whether the message is spam.", e);
        }
        return false;
    }

    static {
        mSpamReportQueueSize = LC.zimbra_spam_report_queue_size.intValue();
    }

    private static final class SpamReport {
        final String mAccountName;
        final long mMailboxId;
        final int mMessageId;
        final boolean mIsSpam;
        final String mOrigIp;
        private String mDescString;

        SpamReport(String accountName, long mailboxId, int messageId, boolean isSpam, String origIp) {
            this.mAccountName = accountName;
            this.mMailboxId = mailboxId;
            this.mMessageId = messageId;
            this.mIsSpam = isSpam;
            this.mOrigIp = origIp;
        }

        public String toString() {
            if (this.mDescString == null) {
                this.mDescString = "spamreport: acct=" + this.mAccountName + " mbox=" + this.mMailboxId + " id=" + this.mMessageId + " report=" + (!this.mIsSpam ? "!" : "") + "spam" + " origIp=" + this.mOrigIp;
            }
            return this.mDescString;
        }
    }
}

