/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;

public class ParseMailboxID {
    private static Log mLog = LogFactory.getLog(ParseMailboxID.class);
    protected String mHostName = null;
    protected Mailbox mMailbox = null;
    protected long mMailboxId = 0L;
    protected boolean mIsLocal = false;
    protected boolean mAllMailboxIds = false;
    protected boolean mAllServers = false;
    protected String mInitialString;
    protected String mEmailAddress = null;

    public static ParseMailboxID parse(String idStr) throws ServiceException {
        try {
            ZimbraLog.misc.info("Parsing id string %s", idStr);
            return new ParseMailboxID(idStr, false);
        }
        catch (IllegalArgumentException e) {
            throw ServiceException.FAILURE("Error parsing MailboxID specifier: " + idStr, e);
        }
    }

    public static ParseMailboxID parseForceRemote(String idStr) throws ServiceException {
        try {
            return new ParseMailboxID(idStr, true);
        }
        catch (IllegalArgumentException e) {
            throw ServiceException.FAILURE("Error parsing MailboxID specifier: " + idStr, e);
        }
    }

    public static ParseMailboxID serverAll(String serverID) throws ServiceException {
        return ParseMailboxID.parse("/" + serverID + "/*");
    }

    public String getString() {
        return this.mInitialString;
    }

    public String toString() {
        return this.getString();
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    public String getServer() {
        return this.mHostName;
    }

    public long getMailboxId() {
        return this.mMailboxId;
    }

    public Mailbox getMailbox() {
        return this.mMailbox;
    }

    public boolean isAllMailboxIds() {
        return this.mAllMailboxIds;
    }

    public boolean isAllServers() {
        return this.mAllServers;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    protected ParseMailboxID(Account account, boolean forceRemote) throws ServiceException, IllegalArgumentException {
        this.initFromAccount(account, null, forceRemote);
    }

    protected void initFromAccount(Account account, String idStr, boolean forceRemote) throws ServiceException, IllegalArgumentException {
        this.mHostName = account.getAttr("zimbraMailHost");
        this.mInitialString = idStr == null ? account.getId() : idStr;
        this.mEmailAddress = account.getName();
        if (!forceRemote && Provisioning.onLocalServer(account)) {
            ZimbraLog.misc.info("Account %s is local", account.getId());
            this.mIsLocal = true;
            this.mMailbox = MailboxManager.getInstance().getMailboxByAccount(account);
            this.mMailboxId = this.mMailbox.getId();
            ZimbraLog.misc.info("Account id %s, mailbox id %s", account.getId(), this.mMailbox.getId());
        } else {
            ZimbraLog.misc.info("Account %s is not local", account.getId());
        }
    }

    protected ParseMailboxID(String idStr, boolean forceRemote) throws ServiceException, IllegalArgumentException {
        this.mInitialString = idStr;
        Account acct = null;
        if (idStr.indexOf(64) >= 0) {
            acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, idStr);
            if (acct == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(idStr);
            }
            this.initFromAccount(acct, idStr, forceRemote);
        } else if (idStr.indexOf(47) >= 0) {
            String[] substrs = idStr.split("/");
            if (substrs.length != 3 || substrs[0].length() != 0) {
                if (substrs.length == 2) {
                    throw new IllegalArgumentException("Invalid mailboxID (missing initial '/' ?): " + idStr);
                }
                throw new IllegalArgumentException("Invalid MailboxID: " + idStr);
            }
            this.mHostName = substrs[1];
            if (this.mHostName.equals("*")) {
                this.mAllServers = true;
            }
            if (substrs[2].startsWith("*")) {
                this.mAllMailboxIds = true;
            } else {
                if (this.mAllServers) {
                    throw new IllegalArgumentException("Invalid mailboxID (\"*/number is not allowed): " + idStr);
                }
                this.mMailboxId = Long.parseLong(substrs[2]);
            }
            String localhost = Provisioning.getInstance().getLocalServer().getAttr("zimbraServiceHostname");
            if (this.mHostName.equals(localhost)) {
                this.mIsLocal = true;
                this.mHostName = null;
                if (!this.mAllMailboxIds) {
                    this.mMailbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId);
                }
            }
        } else if (idStr.indexOf(45) >= 0) {
            acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, idStr);
            if (acct == null) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(idStr);
            }
            this.initFromAccount(acct, idStr, forceRemote);
        } else if (idStr.equals("*")) {
            this.mHostName = "*";
            this.mAllMailboxIds = true;
            this.mAllServers = true;
        } else {
            this.mMailboxId = Integer.parseInt(idStr);
            this.mIsLocal = true;
            this.mMailbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId);
        }
    }

    private ParseMailboxID() {
    }

    private ParseMailboxID(Account acct, String idStr, boolean forceRemote) throws ServiceException {
        this.initFromAccount(acct, idStr, forceRemote);
    }

    private void initAllMailboxes() {
        this.mHostName = "*";
        this.mAllMailboxIds = true;
        this.mAllServers = true;
    }

    public static ParseMailboxID allMailboxes() {
        ParseMailboxID pmid = new ParseMailboxID();
        pmid.initAllMailboxes();
        return pmid;
    }

    public static ParseMailboxID byAccount(Account acct) throws ServiceException {
        mLog.debug("byAccount %s %s", acct.getName(), acct.getId());
        return new ParseMailboxID(acct, null, false);
    }

    public static ParseMailboxID byEmailAddress(String idStr) throws ServiceException {
        mLog.debug("byEmailAddress %s", idStr);
        return ParseMailboxID.byEmailAddress(idStr, false);
    }

    public static ParseMailboxID byAccountId(String idStr) throws ServiceException {
        mLog.debug("byAccountId %s", idStr);
        return ParseMailboxID.byAccountId(idStr, false);
    }

    private static ParseMailboxID byEmailAddress(String idStr, boolean forceRemote) throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, idStr);
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(idStr);
        }
        return new ParseMailboxID(acct, idStr, forceRemote);
    }

    private static ParseMailboxID byAccountId(String idStr, boolean forceRemote) throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, idStr);
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(idStr);
        }
        return new ParseMailboxID(acct, idStr, forceRemote);
    }
}

