/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;

public class ItemIdFormatter {
    private boolean mUnqualifiedItemIds;
    private String mAuthenticatedId;
    private String mDefaultId;

    public ItemIdFormatter() {
        this((String)null, (String)null, false);
    }

    public ItemIdFormatter(String authId) {
        this(authId, authId, false);
    }

    public ItemIdFormatter(boolean noqualify) {
        this((String)null, (String)null, noqualify);
    }

    public ItemIdFormatter(ZimbraSoapContext zsc) {
        this(zsc.getAuthtokenAccountId(), zsc.getRequestedAccountId(), zsc.wantsUnqualifiedIds());
    }

    public ItemIdFormatter(Account authAcct, Account defaultAcct, boolean noqualify) {
        this(authAcct == null ? null : authAcct.getId(), defaultAcct == null ? null : defaultAcct.getId(), noqualify);
    }

    public ItemIdFormatter(Account authAcct, Mailbox mbox, boolean noqualify) {
        this(authAcct == null ? null : authAcct.getId(), mbox.getAccountId(), noqualify);
    }

    public ItemIdFormatter(String authId, Mailbox mbox, boolean noqualify) {
        this(authId, mbox.getAccountId(), noqualify);
    }

    public ItemIdFormatter(String authId, String defaultId, boolean noqualify) {
        this.mAuthenticatedId = authId;
        this.mDefaultId = defaultId == null ? authId : defaultId;
        this.mUnqualifiedItemIds = noqualify;
    }

    public String getAuthenticatedId() {
        return this.mAuthenticatedId;
    }

    public String getDefaultAccountId() {
        return this.mDefaultId;
    }

    public String formatItemId(MailItem item) {
        return this.mUnqualifiedItemIds ? this.formatItemId(item.getId()) : new ItemId(item).toString(this);
    }

    public String formatItemId(MailItem item, int subId) {
        return this.mUnqualifiedItemIds ? this.formatItemId(item.getId(), subId) : new ItemId(item, subId).toString(this);
    }

    public String formatItemId(int itemId) {
        return new ItemId(this.mUnqualifiedItemIds ? null : this.mDefaultId, itemId).toString(this);
    }

    public String formatItemId(int itemId, int subId) {
        return new ItemId(this.mUnqualifiedItemIds ? null : this.mDefaultId, itemId, subId).toString(this);
    }

    public String formatItemId(ItemId iid) {
        if (iid == null) {
            return null;
        }
        return this.mUnqualifiedItemIds ? this.formatItemId(iid.getId(), iid.getSubpartId()) : iid.toString(this);
    }
}

