/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemId {
    private static final char ACCOUNT_DELIMITER = ':';
    private static final char PART_DELIMITER = '-';
    private String mAccountId;
    private int mId;
    private int mSubpartId = -1;

    public ItemId(MailItem item) {
        this(item.getMailbox(), item.getId());
    }

    public ItemId(Mailbox mbox, int id) {
        this(mbox.getAccountId(), id);
    }

    public ItemId(String acctId, int id) {
        this.mAccountId = acctId;
        this.mId = id;
    }

    public ItemId(MailItem item, int subId) {
        this(item.getMailbox().getAccountId(), item.getId(), subId);
    }

    public ItemId(String acctId, int id, int subId) {
        this.mAccountId = acctId;
        this.mId = id;
        this.mSubpartId = subId;
    }

    public ItemId(String encoded, ZimbraSoapContext zsc) throws ServiceException {
        this(encoded, zsc.getRequestedAccountId());
    }

    public ItemId(String encoded, String defaultAccountId) throws ServiceException {
        if (encoded == null || encoded.equals("")) {
            throw ServiceException.INVALID_REQUEST("empty/missing item ID", null);
        }
        int delimiter = encoded.indexOf(58);
        if (delimiter == 0 || delimiter == encoded.length() - 1) {
            throw ServiceException.INVALID_REQUEST("malformed item ID: " + encoded, null);
        }
        if (delimiter != -1) {
            this.mAccountId = encoded.substring(0, delimiter);
        } else if (defaultAccountId != null) {
            this.mAccountId = defaultAccountId;
        }
        encoded = encoded.substring(delimiter + 1);
        delimiter = encoded.indexOf(45);
        if (delimiter == encoded.length() - 1) {
            throw ServiceException.INVALID_REQUEST("malformed item ID: " + encoded, null);
        }
        try {
            if (delimiter > 0) {
                this.mSubpartId = Integer.parseInt(encoded.substring(delimiter + 1));
                if (this.mSubpartId < 0) {
                    throw ServiceException.INVALID_REQUEST("malformed item ID: " + encoded, null);
                }
                encoded = encoded.substring(0, delimiter);
            }
            this.mId = Integer.parseInt(encoded);
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("malformed item ID: " + encoded, nfe);
        }
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public int getId() {
        return this.mId;
    }

    public int getSubpartId() {
        return this.mSubpartId;
    }

    public boolean hasSubpart() {
        return this.mSubpartId >= 0;
    }

    public boolean isLocal() throws ServiceException {
        if (this.mAccountId == null) {
            return true;
        }
        Account acctTarget = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mAccountId);
        if (acctTarget == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(this.mAccountId);
        }
        return DocumentHandler.getLocalHost().equalsIgnoreCase(acctTarget.getAttr("zimbraMailHost"));
    }

    public boolean belongsTo(Account acct) {
        return acct == null || this.mAccountId == null || this.mAccountId.equals(acct.getId());
    }

    public boolean belongsTo(String acctId) {
        return acctId == null || this.mAccountId == null || this.mAccountId.equals(acctId);
    }

    public boolean belongsTo(Mailbox mbox) {
        return mbox == null || this.mAccountId == null || this.mAccountId.equals(mbox.getAccountId());
    }

    public String toString() {
        return this.toString((String)null);
    }

    public String toString(Account authAccount) {
        return this.toString(authAccount == null ? null : authAccount.getId());
    }

    public String toString(ItemIdFormatter ifmt) {
        return this.toString(ifmt == null ? null : ifmt.getAuthenticatedId());
    }

    public String toString(String authAccountId) {
        StringBuffer sb = new StringBuffer();
        if (this.mAccountId != null && this.mAccountId.length() > 0 && !this.mAccountId.equals(authAccountId)) {
            sb.append(this.mAccountId).append(':');
        }
        sb.append(this.mId);
        if (this.hasSubpart()) {
            sb.append('-').append(this.mSubpartId);
        }
        return sb.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ItemId)) {
            return false;
        }
        ItemId other = (ItemId)that;
        if (this.mAccountId == other.mAccountId || this.mAccountId != null && this.mAccountId.equalsIgnoreCase(other.mAccountId)) {
            return other.mId == this.mId && other.mSubpartId == this.mSubpartId;
        }
        return false;
    }

    public int hashCode() {
        return (this.mAccountId == null ? 0 : this.mAccountId.hashCode()) ^ this.mId;
    }

    public static Map<String, List<Integer>> groupFoldersByAccount(OperationContext octxt, Mailbox mbox, List<ItemId> folderIids) throws ServiceException {
        HashMap<String, List<Integer>> foldersMap = new HashMap<String, List<Integer>>();
        for (ItemId iidFolder : folderIids) {
            String targetAccountId = iidFolder.getAccountId();
            int folderId = iidFolder.getId();
            try {
                ArrayList<Integer> folderList;
                if (mbox.getAccountId().equals(targetAccountId)) {
                    boolean isMountpoint = true;
                    int hopCount = 0;
                    while (isMountpoint && hopCount < 5) {
                        Folder folder = mbox.getFolderById(octxt, folderId);
                        isMountpoint = folder instanceof Mountpoint;
                        if (!isMountpoint) continue;
                        Mountpoint mp = (Mountpoint)folder;
                        folderId = mp.getRemoteId();
                        if (!mp.isLocal()) {
                            targetAccountId = mp.getOwnerId();
                            Account targetAcct = Provisioning.getInstance().get(Provisioning.AccountBy.id, targetAccountId);
                            if (targetAcct != null) break;
                            throw MailServiceException.NO_SUCH_MOUNTPOINT(mp.getId(), mp.getOwnerId(), mp.getRemoteId(), AccountServiceException.NO_SUCH_ACCOUNT(targetAccountId));
                        }
                        ++hopCount;
                    }
                    if (hopCount >= 5) {
                        throw MailServiceException.TOO_MANY_HOPS(iidFolder);
                    }
                }
                if ((folderList = (ArrayList<Integer>)foldersMap.get(targetAccountId)) == null) {
                    folderList = new ArrayList<Integer>();
                    foldersMap.put(targetAccountId, folderList);
                }
                folderList.add(folderId);
            }
            catch (ServiceException e) {
                String ecode = e.getCode();
                ItemIdFormatter ifmt = new ItemIdFormatter(targetAccountId, targetAccountId, false);
                if (ecode.equals("service.PERM_DENIED")) {
                    ZimbraLog.calendar.warn((Object)("Ignorable permission error " + ifmt.formatItemId(folderId)), e);
                    continue;
                }
                if (ecode.equals("mail.NO_SUCH_FOLDER")) {
                    ZimbraLog.calendar.warn("Ignoring deleted folder " + ifmt.formatItemId(folderId));
                    continue;
                }
                throw e;
            }
        }
        return foldersMap;
    }

    public static void main(String[] args) {
        ItemId foo = null;
        try {
            foo = new ItemId("34480-508bc90b-d85e-45d6-bca2-7c34b7c407cb:34479", (String)null);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        System.out.println(foo.toString());
    }
}

