/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.tar.TarEntry;
import com.zimbra.common.util.tar.TarInputStream;
import com.zimbra.common.util.tar.TarOutputStream;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.service.util.ItemData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;

public class ItemDataFile {
    public static void create(String path, OutputStream os, boolean verbose) throws IOException {
        ItemDataFile.create(path, null, "UTF-8", os, verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(String path, byte[] types, String cset, OutputStream os, boolean verbose) throws IOException {
        File f = new File(path);
        TarOutputStream tos = new TarOutputStream((OutputStream)new GZIPOutputStream(os), cset == null ? "UTF-8" : cset);
        tos.setLongFileMode(2);
        try {
            if (f.isDirectory()) {
                ItemDataFile.addDir(f, f.getPath(), types, tos, verbose);
            } else {
                ItemDataFile.addFile(f, f.getParent(), types, tos, verbose);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            tos.close();
            throw throwable;
        }
        tos.close();
    }

    public static void extract(InputStream is, boolean verbose) throws IOException {
        ItemDataFile.extract(is, true, null, null, "UTF-8", verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(InputStream is, boolean meta, byte[] types, String cset, String dir, boolean verbose) throws IOException {
        byte[] buf = new byte[10240];
        TarInputStream tis = new TarInputStream((InputStream)new GZIPInputStream(is), cset == null ? "UTF-8" : cset);
        if (dir == null) {
            dir = ".";
        }
        try {
            TarEntry te;
            while ((te = tis.getNextEntry()) != null) {
                FileOutputStream out;
                if (ItemDataFile.skip(types, (byte)te.getMajorDeviceId())) continue;
                File f = new File(dir + File.separator + te.getName());
                if (!f.getParent().equals(".")) {
                    f.getParentFile().mkdir();
                }
                if (te.getName().endsWith(".meta")) {
                    if (!meta) continue;
                    System.out.println(f);
                    out = new FileOutputStream(f);
                    ItemData id = new ItemData(ItemDataFile.getData(tis, te));
                    out.write(id.encode(2).getBytes("UTF-8"));
                } else {
                    int in;
                    System.out.println(f);
                    out = new FileOutputStream(f);
                    while ((in = tis.read(buf)) != -1) {
                        out.write(buf, 0, in);
                    }
                }
                out.close();
                f.setLastModified(te.getModTime().getTime());
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            tis.close();
            throw throwable;
        }
        tis.close();
    }

    public static void list(InputStream is, PrintStream os) throws IOException {
        ItemDataFile.list(is, null, "UTF-8", os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void list(InputStream is, byte[] types, String cset, PrintStream os) throws IOException {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        TarInputStream tis = new TarInputStream((InputStream)new GZIPInputStream(is), cset == null ? "UTF-8" : cset);
        os.format("%-13s %17s %10s %6s %s\n", "TYPE", "DATE", "SIZE", "METASZ", "PATH");
        try {
            TarEntry te;
            TarEntry idEntry = null;
            while ((te = tis.getNextEntry()) != null) {
                if (te.getName().endsWith(".meta")) {
                    if (idEntry != null && !ItemDataFile.skip(types, (byte)idEntry.getMajorDeviceId())) {
                        os.format("%-13s %17s %10s %6d %s\n", idEntry.getGroupName(), df.format(idEntry.getModTime()), 0, idEntry.getSize(), idEntry.getName().substring(0, idEntry.getName().indexOf(".meta")));
                    }
                    idEntry = te;
                    continue;
                }
                if (!ItemDataFile.skip(types, (byte)te.getMajorDeviceId())) {
                    os.format("%-13s %17s %10s %6d %s\n", te.getGroupName(), df.format(te.getModTime()), te.getSize(), idEntry == null ? 0L : idEntry.getSize(), te.getName());
                }
                idEntry = null;
            }
            if (idEntry != null && !ItemDataFile.skip(types, (byte)idEntry.getMajorDeviceId())) {
                os.format("%-13s %17s %10s %6d %s\n", idEntry.getGroupName(), df.format(idEntry.getModTime()), 0, idEntry.getSize(), idEntry.getName().substring(0, idEntry.getName().indexOf(".meta")));
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            tis.close();
            throw throwable;
        }
        tis.close();
    }

    static byte[] getData(TarInputStream tis, TarEntry te) throws IOException {
        int dsz = (int)te.getSize();
        byte[] data = new byte[dsz];
        if (tis.read(data, 0, dsz) != dsz) {
            throw new IOException("archive read err");
        }
        return data;
    }

    static boolean skip(byte[] types, byte type) {
        if (types == null) {
            return false;
        }
        for (byte t : types) {
            if (t != type) continue;
            return false;
        }
        return true;
    }

    static void addDir(File f, String topdir, byte[] types, TarOutputStream tos, boolean verbose) throws IOException {
        String path = f.getPath();
        Object[] all = f.list();
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        Arrays.sort(all);
        for (Object file : all) {
            File subf = new File(path + File.separator + (String)file);
            if (subf.getName().equals("Tags") && path.equals(topdir)) {
                ItemDataFile.addDir(subf, topdir, types, tos, verbose);
                continue;
            }
            if (subf.isDirectory()) {
                dirs.add(subf);
                continue;
            }
            if (subf.getName().endsWith(".meta")) {
                file = subf.getPath().substring(0, subf.getPath().indexOf(".meta"));
                f = new File((String)file);
                if (f.exists() && !f.isDirectory()) continue;
                files.add(f);
                continue;
            }
            files.add(subf);
        }
        for (File file : files) {
            ItemDataFile.addFile(file, topdir, types, tos, verbose);
        }
        for (File dir : dirs) {
            ItemDataFile.addDir(dir, topdir, types, tos, verbose);
        }
    }

    static void addFile(File f, String topdir, byte[] types, TarOutputStream tos, boolean verbose) throws IOException {
        TarEntry te;
        byte type;
        FileInputStream fis;
        ItemData id = null;
        String path = f.getPath();
        File mf = new File(path + ".meta");
        if (path.indexOf(topdir) == 0) {
            path = path.substring(topdir.length() + 1);
        }
        path = path.replace('\\', '/');
        if (mf.exists()) {
            fis = new FileInputStream(mf);
            byte[] meta = new byte[(int)mf.length()];
            if ((long)fis.read(meta) != mf.length()) {
                throw new IOException("meta read err: " + f.getPath());
            }
            fis.close();
            id = new ItemData(meta);
            type = id.ud.type;
            if (ItemDataFile.skip(types, type)) {
                return;
            }
            te = new TarEntry(path + ".meta");
            System.out.println(te.getName());
            te.setGroupName(MailItem.getNameForType(id.ud.type));
            te.setMajorDeviceId((int)id.ud.type);
            te.setModTime(mf.lastModified());
            te.setSize((long)meta.length);
            tos.putNextEntry(te);
            tos.write(meta);
            tos.closeEntry();
        } else {
            type = path.endsWith(".csv") || path.endsWith(".vcf") ? (byte)6 : (path.endsWith(".eml") ? (byte)5 : (path.endsWith(".ics") ? (path.startsWith("Tasks/") ? (byte)15 : 11) : (path.endsWith(".wiki") ? (byte)14 : 8)));
            if (ItemDataFile.skip(types, type)) {
                return;
            }
        }
        if (f.exists() && !f.isDirectory() && (id != null || types == null)) {
            int in;
            byte[] buf = new byte[10240];
            fis = new FileInputStream(f);
            te = new TarEntry(path);
            System.out.println(te.getName());
            te.setGroupName(MailItem.getNameForType(id.ud.type));
            te.setMajorDeviceId((int)id.ud.type);
            te.setModTime(mf.lastModified());
            te.setSize(f.length());
            tos.putNextEntry(te);
            while ((in = fis.read(buf)) > 0) {
                tos.write(buf, 0, in);
            }
            fis.close();
            tos.closeEntry();
        }
    }

    private static void usage(Options opts) {
        new HelpFormatter().printHelp(ItemDataFile.class.getSimpleName() + " [options] file", opts);
        System.exit(1);
    }

    public static void main(String[] args) {
        String cset = null;
        Options opts = new Options();
        GnuParser parser = new GnuParser();
        boolean verbose = false;
        opts.addOption("a", "assemble", false, "assemble backup");
        opts.addOption("c", "charset", true, "path charset");
        opts.addOption("e", "extract", false, "extract backup");
        opts.addOption("h", "help", false, "help");
        opts.addOption("l", "list", false, "list backup");
        opts.addOption("n", "nometa", false, "ignore metadata");
        opts.addOption("p", "path", true, "extracted backup path");
        opts.addOption("t", "types", true, "item types");
        opts.addOption("v", "verbose", false, "verbose");
        ZimbraLog.toolSetupLog4j("ERROR", null);
        try {
            CommandLine cl = parser.parse(opts, args);
            String path = ".";
            String file = null;
            boolean meta = true;
            byte[] types = null;
            if (cl.hasOption('c')) {
                cset = cl.getOptionValue('c');
            }
            if (cl.hasOption('n')) {
                meta = false;
            }
            if (cl.hasOption('p')) {
                path = cl.getOptionValue('p');
            }
            if (cl.hasOption('t')) {
                types = MailboxIndex.parseTypesString(cl.getOptionValue('t'));
            }
            if (cl.hasOption('h') || cl.getArgs().length != 1) {
                ItemDataFile.usage(opts);
            }
            if (cl.hasOption('v')) {
                verbose = true;
            }
            file = cl.getArgs()[0];
            if (cl.hasOption('a')) {
                ItemDataFile.create(path, types, cset, new FileOutputStream(file), verbose);
            } else if (cl.hasOption('e')) {
                ItemDataFile.extract(new FileInputStream(file), meta, types, cset, path, verbose);
            } else if (cl.hasOption('l')) {
                ItemDataFile.list(file.equals("-") ? System.in : new FileInputStream(file), types, cset, System.out);
            } else {
                ItemDataFile.usage(opts);
            }
        }
        catch (Exception e) {
            if (e instanceof UnrecognizedOptionException) {
                ItemDataFile.usage(opts);
            } else {
                e.printStackTrace(System.out);
            }
            System.exit(1);
        }
    }
}

