/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.util;

import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailItem;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemData {
    public String sender;
    public String extra;
    public String flags;
    public String path;
    public String tags;
    public MailItem.UnderlyingData ud;

    public ItemData(MailItem mi) throws IOException {
        this(mi, null);
    }

    public ItemData(MailItem mi, String userData) throws IOException {
        try {
            this.sender = mi.getSender();
            this.extra = userData;
            this.flags = mi.getFlagString();
            this.path = mi.getPath();
            this.tags = mi.getTagString();
            this.ud = mi.getUnderlyingData();
        }
        catch (Exception e) {
            throw new IOException("data error: " + e);
        }
    }

    public ItemData(String encoded) throws IOException {
        try {
            JSONObject json = new JSONObject(encoded);
            byte version = (byte)json.getInt(Keys.Ver.toString());
            if (version > 10) {
                throw new IOException("unsupported data version");
            }
            this.ud = new MailItem.UnderlyingData();
            this.ud.id = json.getInt(Keys.id.toString());
            this.ud.type = (byte)json.getInt(Keys.type.toString());
            this.ud.parentId = json.getInt(Keys.parent_id.toString());
            this.ud.folderId = json.getInt(Keys.folder_id.toString());
            this.ud.indexId = null;
            this.ud.locator = null;
            this.ud.imapId = json.getInt(Keys.imap_id.toString());
            this.ud.date = json.getInt(Keys.date.toString());
            this.ud.size = json.getLong(Keys.size.toString());
            this.ud.setBlobDigest(json.optString(Keys.blob_digest.toString()));
            this.ud.unreadCount = json.getInt(Keys.unread.toString());
            this.ud.flags = json.getInt(Keys.flags.toString()) | Flag.BITMASK_UNCACHED;
            this.ud.tags = json.getLong(Keys.tags.toString());
            this.ud.subject = json.optString(Keys.subject.toString());
            this.ud.name = json.optString(Keys.name.toString());
            this.ud.metadata = json.optString(Keys.metadata.toString());
            this.ud.modMetadata = json.getInt(Keys.mod_metadata.toString());
            this.ud.dateChanged = json.getInt(Keys.change_date.toString());
            this.ud.modContent = json.getInt(Keys.mod_content.toString());
            this.sender = json.optString(Keys.sender.toString());
            this.extra = json.optString(Keys.ExtraStr.toString());
            this.flags = json.optString(Keys.FlagStr.toString());
            this.path = json.optString(Keys.Path.toString());
            this.tags = json.optString(Keys.TagStr.toString());
        }
        catch (JSONException e) {
            throw new IOException("decode error: " + e);
        }
    }

    public ItemData(byte[] encoded) throws IOException {
        this(new String(encoded, "UTF-8"));
    }

    public JSONObject toJSON() throws IOException {
        try {
            return new JSONObject().put(Keys.id.toString(), this.ud.id).put(Keys.type.toString(), this.ud.type).put(Keys.parent_id.toString(), this.ud.parentId).put(Keys.folder_id.toString(), this.ud.folderId).put(Keys.index_id.toString(), 0).put(Keys.imap_id.toString(), this.ud.imapId).put(Keys.date.toString(), this.ud.date).put(Keys.size.toString(), this.ud.size).put(Keys.volume_id.toString(), 0).putOpt(Keys.blob_digest.toString(), this.ud.getBlobDigest()).put(Keys.unread.toString(), this.ud.unreadCount).put(Keys.flags.toString(), this.ud.flags).put(Keys.tags.toString(), this.ud.tags).putOpt(Keys.subject.toString(), this.ud.subject).putOpt(Keys.name.toString(), this.ud.name).putOpt(Keys.metadata.toString(), this.ud.metadata).put(Keys.mod_metadata.toString(), this.ud.modMetadata).put(Keys.change_date.toString(), this.ud.dateChanged).put(Keys.mod_content.toString(), this.ud.modContent).putOpt(Keys.sender.toString(), this.sender).putOpt(Keys.ExtraStr.toString(), this.extra).putOpt(Keys.FlagStr.toString(), this.flags).put(Keys.Path.toString(), this.path).putOpt(Keys.TagStr.toString(), this.tags).put(Keys.Ver.toString(), 10);
        }
        catch (Exception e) {
            throw new IOException("encode error: " + e);
        }
    }

    public String encode(int indent) throws IOException {
        try {
            return this.toJSON().toString(indent);
        }
        catch (Exception e) {
            throw new IOException("encode error: " + e);
        }
    }

    public byte[] encode() throws IOException {
        try {
            return this.toJSON().toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new IOException("encode error: " + e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Keys {
        id,
        type,
        parent_id,
        folder_id,
        index_id,
        imap_id,
        date,
        size,
        volume_id,
        blob_digest,
        unread,
        flags,
        tags,
        subject,
        name,
        metadata,
        mod_metadata,
        change_date,
        mod_content,
        sender,
        ExtraStr,
        FlagStr,
        Path,
        TagStr,
        Ver;

    }
}

