/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminServiceException;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.SyncToken;
import com.zimbra.cs.session.IWaitSet;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetCallback;
import com.zimbra.cs.session.WaitSetError;
import com.zimbra.cs.session.WaitSetMgr;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitSetRequest
extends MailDocumentHandler {
    private static final long DEFAULT_TIMEOUT = LC.zimbra_waitset_default_request_timeout.longValueWithinRange(0L, 86400L) * 1000L;
    private static final long MIN_TIMEOUT = LC.zimbra_waitset_min_request_timeout.longValueWithinRange(0L, 86400L) * 1000L;
    private static final long MAX_TIMEOUT = LC.zimbra_waitset_max_request_timeout.longValueWithinRange(0L, 86400L) * 1000L;
    private static final long DEFAULT_ADMIN_TIMEOUT = LC.zimbra_admin_waitset_default_request_timeout.longValueWithinRange(0L, 86400L) * 1000L;
    private static final long MIN_ADMIN_TIMEOUT = LC.zimbra_admin_waitset_min_request_timeout.longValueWithinRange(0L, 86400L) * 1000L;
    private static final long MAX_ADMIN_TIMEOUT = LC.zimbra_admin_waitset_max_request_timeout.longValueWithinRange(0L, 86400L) * 1000L;
    private static final long INITIAL_SLEEP_TIME = LC.zimbra_waitset_initial_sleep_time.longValueWithinRange(0L, 300000L);
    private static final long NODATA_SLEEP_TIME = LC.zimbra_waitset_nodata_sleep_time.longValueWithinRange(0L, 300000L);
    private static final String VARS_ATTR_NAME = WaitSetRequest.class.getName() + ".vars";

    private static long getTimeout(Element request, boolean isAdminRequest) throws ServiceException {
        if (!isAdminRequest) {
            long to = request.getAttributeLong("timeout", DEFAULT_TIMEOUT);
            if (to < MIN_TIMEOUT) {
                to = MIN_TIMEOUT;
            }
            if (to > MAX_TIMEOUT) {
                to = MAX_TIMEOUT;
            }
            return to;
        }
        long to = request.getAttributeLong("timeout", DEFAULT_ADMIN_TIMEOUT);
        if (to < MIN_ADMIN_TIMEOUT) {
            to = MIN_ADMIN_TIMEOUT;
        }
        if (to > MAX_ADMIN_TIMEOUT) {
            to = MAX_ADMIN_TIMEOUT;
        }
        return to;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = WaitSetRequest.getZimbraSoapContext(context);
        boolean adminAllowed = zsc.getAuthToken().isAdmin();
        Element response = zsc.createElement(MailConstants.WAIT_SET_RESPONSE);
        return WaitSetRequest.staticHandle(request, context, response, adminAllowed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element staticHandle(Element request, Map<String, Object> context, Element response, boolean adminAllowed) throws ServiceException {
        Continuation continuation;
        Callback cb;
        ZimbraSoapContext zsc = WaitSetRequest.getZimbraSoapContext(context);
        HttpServletRequest servletRequest = (HttpServletRequest)context.get("servlet.request");
        String waitSetId = request.getAttribute("waitSet");
        String lastKnownSeqNo = request.getAttribute("seq");
        boolean block = request.getAttributeBool("block", false);
        if (context.containsKey("zimbra.resumedRequest")) {
            cb = (Callback)servletRequest.getAttribute(VARS_ATTR_NAME);
            continuation = ContinuationSupport.getContinuation((HttpServletRequest)servletRequest, (Object)cb);
        } else {
            Mailbox mbox;
            cb = new Callback();
            cb.continuation = continuation = ContinuationSupport.getContinuation((HttpServletRequest)servletRequest, (Object)cb);
            servletRequest.setAttribute(VARS_ATTR_NAME, (Object)cb);
            String defInterestStr = null;
            if (waitSetId.startsWith("AllWaitSet-")) {
                if (!adminAllowed) {
                    throw MailServiceException.PERM_DENIED("Non-Admin accounts may not wait on other accounts");
                }
                defInterestStr = request.getAttribute("defTypes");
                int defaultInterests = WaitSetRequest.parseInterestStr(defInterestStr, 0);
                cb.ws = WaitSetMgr.lookupOrCreateForAllAccts(zsc.getRequestedAccountId(), waitSetId, defaultInterests, lastKnownSeqNo);
            } else {
                cb.ws = WaitSetMgr.lookup(waitSetId);
            }
            if (cb.ws == null) {
                throw AdminServiceException.NO_SUCH_WAITSET(waitSetId);
            }
            if (!cb.ws.getOwnerAccountId().equals(zsc.getRequestedAccountId())) {
                throw ServiceException.PERM_DENIED("Not owner of waitset");
            }
            ArrayList<String> allowedAccountIds = null;
            if (!adminAllowed) {
                allowedAccountIds = new ArrayList<String>(1);
                allowedAccountIds.add(zsc.getRequestedAccountId());
            }
            List<WaitSetAccount> add = WaitSetRequest.parseAddUpdateAccounts(request.getOptionalElement("add"), cb.ws.getDefaultInterest(), allowedAccountIds);
            List<WaitSetAccount> update = WaitSetRequest.parseAddUpdateAccounts(request.getOptionalElement("update"), cb.ws.getDefaultInterest(), allowedAccountIds);
            List<String> remove = WaitSetRequest.parseRemoveAccounts(request.getOptionalElement("remove"), allowedAccountIds);
            ArrayList<Mailbox> referencedMailboxes = new ArrayList<Mailbox>();
            for (WaitSetAccount acct : add) {
                try {
                    mbox = MailboxManager.getInstance().getMailboxByAccountId(acct.getAccountId(), MailboxManager.FetchMode.AUTOCREATE);
                    referencedMailboxes.add(mbox);
                }
                catch (ServiceException e) {
                    ZimbraLog.session.debug((Object)"Caught exception preloading mailbox for waitset", e);
                }
            }
            for (WaitSetAccount acct : update) {
                try {
                    mbox = MailboxManager.getInstance().getMailboxByAccountId(acct.getAccountId(), MailboxManager.FetchMode.AUTOCREATE);
                    referencedMailboxes.add(mbox);
                }
                catch (ServiceException e) {
                    ZimbraLog.session.debug((Object)"Caught exception preloading mailbox for waitset", e);
                }
            }
            try {
                Thread.sleep(INITIAL_SLEEP_TIME);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            cb.errors.addAll(cb.ws.removeAccounts(remove));
            IWaitSet ex = cb.ws;
            synchronized (ex) {
                Callback callback = cb;
                synchronized (callback) {
                    cb.errors.addAll(cb.ws.doWait(cb, lastKnownSeqNo, add, update));
                    if (cb.completed) {
                        block = false;
                    }
                }
            }
            if (block) {
                try {
                    Thread.sleep(NODATA_SLEEP_TIME);
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                Callback callback = cb;
                synchronized (callback) {
                    if (!cb.completed) {
                        continuation.suspend(WaitSetRequest.getTimeout(request, adminAllowed));
                    }
                }
            }
        }
        cb.ws.doneWaiting();
        response.addAttribute("waitSet", waitSetId);
        if (cb.canceled) {
            response.addAttribute("canceled", true);
        } else if (cb.completed) {
            response.addAttribute("seq", cb.seqNo);
            for (String s : cb.signalledAccounts) {
                Element saElt = response.addElement("a");
                saElt.addAttribute("id", s);
            }
        } else {
            response.addAttribute("seq", lastKnownSeqNo);
        }
        WaitSetRequest.encodeErrors(response, cb.errors);
        return response;
    }

    /*
     * Enabled aggressive block sorting
     */
    static List<WaitSetAccount> parseAddUpdateAccounts(Element elt, int defaultInterest, List<String> allowedAccountIds) throws ServiceException {
        ArrayList<WaitSetAccount> toRet = new ArrayList<WaitSetAccount>();
        if (elt != null) {
            Iterator<Element> iter = elt.elementIterator("a");
            while (iter.hasNext()) {
                String id;
                Element a;
                block6: {
                    a = iter.next();
                    String name = a.getAttribute("name", null);
                    if (name != null) {
                        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, name);
                        if (acct != null) {
                            id = acct.getId();
                            break block6;
                        } else {
                            WaitSetError err = new WaitSetError(name, WaitSetError.Type.NO_SUCH_ACCOUNT);
                            continue;
                        }
                    }
                    id = a.getAttribute("id");
                }
                if (allowedAccountIds != null && !allowedAccountIds.contains(id)) {
                    throw ServiceException.PERM_DENIED("Only admins may listen to other account IDs");
                }
                String tokenStr = a.getAttribute("token", null);
                SyncToken token = tokenStr != null ? new SyncToken(tokenStr) : null;
                int interests = WaitSetRequest.parseInterestStr(a.getAttribute("types", null), defaultInterest);
                toRet.add(new WaitSetAccount(id, token, interests));
            }
        }
        return toRet;
    }

    static List<String> parseRemoveAccounts(Element elt, List<String> allowedAccountIds) throws ServiceException {
        ArrayList<String> remove = new ArrayList<String>();
        if (elt != null) {
            Iterator<Element> iter = elt.elementIterator("a");
            while (iter.hasNext()) {
                Element a = iter.next();
                String id = a.getAttribute("id");
                if (allowedAccountIds != null && !allowedAccountIds.contains(id)) {
                    throw ServiceException.PERM_DENIED("Only adins may listen to other account IDs");
                }
                remove.add(id);
            }
        }
        return remove;
    }

    public static final String expandInterestStr(int interest) {
        if (interest == TypeEnum.all.getMask()) {
            return TypeEnum.all.name();
        }
        StringBuilder toRet = new StringBuilder();
        for (TypeEnum type : TypeEnum.values()) {
            if ((interest & type.getMask()) == 0) continue;
            toRet.append(type.name());
        }
        return toRet.toString();
    }

    public static final void encodeErrors(Element parent, List<WaitSetError> errors) {
        for (WaitSetError error : errors) {
            Element errorElt = parent.addElement("error");
            errorElt.addAttribute("id", error.accountId);
            errorElt.addAttribute("t", error.error.name());
        }
    }

    public static final int parseInterestStr(String typesList, int defaultInterest) {
        if (typesList == null) {
            return defaultInterest;
        }
        int toRet = 0;
        for (String s : typesList.split(",")) {
            s = s.trim();
            TypeEnum te = TypeEnum.valueOf(s);
            toRet |= te.getMask();
        }
        return toRet;
    }

    public static final String interestToStr(int interests) {
        StringBuilder toRet = new StringBuilder();
        boolean atFirst = true;
        for (TypeEnum t : TypeEnum.values()) {
            if (t == TypeEnum.all || (interests & t.getMask()) == 0) continue;
            if (!atFirst) {
                toRet.append(',');
            }
            atFirst = false;
            toRet.append(t.name());
        }
        return toRet.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeEnum {
        m(MailItem.typeToBitmask((byte)5)),
        c(MailItem.typeToBitmask((byte)6)),
        a(MailItem.typeToBitmask((byte)11)),
        all(0xFFFFFF);

        private final int mMask;

        private TypeEnum(int mask) {
            this.mMask = mask;
        }

        public int getMask() {
            return this.mMask;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Callback
    implements WaitSetCallback {
        public boolean completed = false;
        public boolean canceled;
        public String[] signalledAccounts;
        public IWaitSet waitSet;
        public String seqNo;
        public IWaitSet ws;
        public List<WaitSetError> errors = new ArrayList<WaitSetError>();
        public Continuation continuation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataReady(IWaitSet ws, String seqNo, boolean canceled, List<WaitSetError> inErrors, String[] signalledAccounts) {
            Callback callback = this;
            synchronized (callback) {
                ZimbraLog.session.debug("WaitSet: Called WaitSetCallback.dataReady()!");
                if (inErrors != null && inErrors.size() > 0) {
                    this.errors.addAll(inErrors);
                }
                this.waitSet = ws;
                this.canceled = canceled;
                this.signalledAccounts = signalledAccounts;
                this.seqNo = seqNo;
                this.completed = true;
                if (this.continuation != null) {
                    this.continuation.resume();
                }
            }
        }
    }
}

