/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.service.FileUploadServlet;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;

public abstract class UploadScanner {
    public static final Result ACCEPT = new Result("ACCEPT");
    public static final Result REJECT = new Result("REJECT");
    public static final Result ERROR = new Result("ERROR");
    private static List<UploadScanner> sRegisteredScanners = new LinkedList<UploadScanner>();

    public static void registerScanner(UploadScanner scanner) {
        sRegisteredScanners.add(scanner);
    }

    public static void unregisterScanner(UploadScanner scanner) {
        sRegisteredScanners.remove(scanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result accept(FileUploadServlet.Upload up, StringBuffer info) {
        for (UploadScanner scanner : sRegisteredScanners) {
            Object var8_6;
            Result result;
            if (!scanner.isEnabled()) continue;
            InputStream is = null;
            try {
                is = up.getInputStream();
            }
            catch (IOException ioe) {
                ZimbraLog.misc.error((Object)"exception getting input stream for scanning", ioe);
                info.append(" ").append(ioe);
                return ERROR;
            }
            try {
                result = scanner.accept(is, info);
                var8_6 = null;
            }
            catch (Throwable throwable) {
                var8_6 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            if (result != REJECT && result != ERROR) continue;
            return result;
        }
        return ACCEPT;
    }

    protected abstract Result accept(InputStream var1, StringBuffer var2);

    protected abstract Result accept(byte[] var1, StringBuffer var2);

    public abstract void setURL(String var1) throws MalformedURLException;

    public abstract boolean isEnabled();

    public static final class Result {
        private String mDesc;

        Result(String desc) {
            this.mDesc = desc;
        }

        public String toString() {
            return this.mDesc;
        }
    }
}

