/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.TruncatingWriter;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.html.HtmlDefang;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Chat;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.OperationContextData;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.SenderList;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mailbox.calendar.Alarm;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.Recurrence;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedAddress;
import com.zimbra.cs.mime.handler.TextEnrichedHandler;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.mail.FolderAction;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToXML {
    public static final int NOTIFY_FIELDS = -4194305;
    private static Log mLog = LogFactory.getLog(ToXML.class);
    private static final int MAX_INLINE_MSG_SIZE = 40000;
    private static final String CONTENT_SERVLET_URI = "/service/content/get?id=";
    private static final String PART_PARAM_STRING = "&part=";

    private ToXML() {
    }

    public static Element encodeItem(Element parent, ItemIdFormatter ifmt, OperationContext octxt, MailItem item, int fields) throws ServiceException {
        if (item instanceof Folder) {
            return ToXML.encodeFolder(parent, ifmt, octxt, (Folder)item, fields);
        }
        if (item instanceof Tag) {
            return ToXML.encodeTag(parent, ifmt, (Tag)item, fields);
        }
        if (item instanceof Note) {
            return ToXML.encodeNote(parent, ifmt, (Note)item, fields);
        }
        if (item instanceof Contact) {
            return ToXML.encodeContact(parent, ifmt, (Contact)item, false, null, fields);
        }
        if (item instanceof CalendarItem) {
            return ToXML.encodeCalendarItemSummary(parent, ifmt, octxt, (CalendarItem)item, fields, true);
        }
        if (item instanceof Conversation) {
            return ToXML.encodeConversationSummary(parent, ifmt, octxt, (Conversation)item, null, OutputParticipants.PUT_SENDERS, fields, false);
        }
        if (item instanceof WikiItem) {
            return ToXML.encodeWiki(parent, ifmt, octxt, (WikiItem)item, fields);
        }
        if (item instanceof Document) {
            return ToXML.encodeDocument(parent, ifmt, octxt, (Document)item, fields);
        }
        if (item instanceof Message) {
            OutputParticipants output = fields == -4194305 ? OutputParticipants.PUT_BOTH : OutputParticipants.PUT_SENDERS;
            return ToXML.encodeMessageSummary(parent, ifmt, octxt, (Message)item, output, fields);
        }
        return null;
    }

    private static boolean needToOutput(int fields, int fieldMask) {
        return (fields & fieldMask) > 0;
    }

    public static Element encodeMailbox(Element parent, OperationContext octxt, Mailbox mbox) {
        return ToXML.encodeMailbox(parent, octxt, mbox, -4194305);
    }

    public static Element encodeMailbox(Element parent, OperationContext octxt, Mailbox mbox, int fields) {
        Element elem = parent.addElement("mbx");
        if (octxt.isDelegatedRequest(mbox)) {
            elem.addAttribute("acct", mbox.getAccountId());
        }
        if (ToXML.needToOutput(fields, 16)) {
            elem.addAttribute("s", mbox.getSize());
        }
        return elem;
    }

    public static Element encodeFolder(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Folder folder) {
        return ToXML.encodeFolder(parent, ifmt, octxt, folder, -4194305);
    }

    public static Element encodeFolder(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Folder folder, int fields) {
        return ToXML.encodeFolder(parent, ifmt, octxt, folder, fields, false);
    }

    public static Element encodeFolder(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Folder folder, int fields, boolean exposeAclAccessKey) {
        boolean canAdminister;
        String url;
        if (folder instanceof SearchFolder) {
            return ToXML.encodeSearchFolder(parent, ifmt, (SearchFolder)folder, fields);
        }
        if (folder instanceof Mountpoint) {
            return ToXML.encodeMountpoint(parent, ifmt, (Mountpoint)folder, fields);
        }
        Element elem = parent.addElement("folder");
        ToXML.encodeFolderCommon(elem, ifmt, folder, fields);
        if (ToXML.needToOutput(fields, 16)) {
            elem.addAttribute("n", folder.getItemCount());
            elem.addAttribute("s", folder.getTotalSize());
            elem.addAttribute("i4ms", folder.getImapMODSEQ());
            elem.addAttribute("i4next", folder.getImapUIDNEXT());
        }
        if (ToXML.needToOutput(fields, 262144) && (!(url = folder.getUrl()).equals("") || fields != -4194305)) {
            elem.addAttribute("url", HttpUtil.sanitizeURL(url));
        }
        Mailbox mbox = folder.getMailbox();
        boolean remote = octxt != null && octxt.isDelegatedRequest(mbox);
        boolean bl = canAdminister = !remote;
        if (remote) {
            String perms = ToXML.encodeEffectivePermissions(folder, octxt);
            elem.addAttribute("perm", perms);
            boolean bl2 = canAdminister = perms != null && perms.indexOf(97) != -1;
        }
        if (canAdminister && ToXML.needToOutput(fields, 0x200000) && (fields != -4194305 || folder.isTagged(-23))) {
            ToXML.encodeACL(octxt, elem, folder.getEffectiveACL(), exposeAclAccessKey);
        }
        return elem;
    }

    public static String encodeEffectivePermissions(Folder folder, OperationContext octxt) {
        try {
            short perms = folder.getMailbox().getEffectivePermissions(octxt, folder.getId(), (byte)1);
            return ACL.rightsToString(perms);
        }
        catch (ServiceException e) {
            mLog.warn((Object)("ignoring exception while fetching effective permissions for folder " + folder.getId()), e);
            return null;
        }
    }

    public static Element encodeACL(OperationContext octxt, Element parent, ACL acl, boolean exposeAclAccessKey) {
        Element eACL = parent.addUniqueElement("acl");
        if (acl == null) {
            return eACL;
        }
        boolean needDispName = OperationContextData.getNeedGranteeName(octxt);
        for (ACL.Grant grant : acl.getGrants()) {
            String name = null;
            byte granteeType = grant.getGranteeType();
            if (needDispName && (name = grant.getGranteeName()) == null) {
                NamedEntry nentry;
                OperationContextData.GranteeNames granteeNames = OperationContextData.getGranteeNames(octxt);
                if (granteeNames != null) {
                    name = granteeNames.getNameById(grant.getGranteeId(), granteeType);
                }
                if (name == null && (nentry = FolderAction.lookupGranteeByZimbraId(grant.getGranteeId(), granteeType)) != null) {
                    name = nentry.getName();
                }
            }
            Element eGrant = eACL.addElement("grant");
            eGrant.addAttribute("zid", grant.getGranteeId()).addAttribute("gt", ACL.typeToString(granteeType)).addAttribute("perm", ACL.rightsToString(grant.getGrantedRights()));
            if (needDispName) {
                if (OperationContextData.GranteeNames.INVALID_GRANT == name) {
                    eGrant.addAttribute("invalid", true);
                    eGrant.addAttribute("d", "");
                } else {
                    eGrant.addAttribute("d", name);
                }
            }
            if (granteeType == 8) {
                if (!exposeAclAccessKey) continue;
                eGrant.addAttribute("key", grant.getPassword());
                continue;
            }
            eGrant.addAttribute("pw", grant.getPassword());
        }
        return eACL;
    }

    public static Element encodeACE(Element parent, ZimbraACE ace) {
        Element eACE = parent.addElement("ace").addAttribute("zid", ace.getGrantee()).addAttribute("gt", ace.getGranteeType().getCode()).addAttribute("right", ace.getRight().getName()).addAttribute("d", ace.getGranteeDisplayName());
        if (ace.getGranteeType() == GranteeType.GT_KEY) {
            eACE.addAttribute("key", ace.getSecret());
        } else if (ace.getGranteeType() == GranteeType.GT_GUEST) {
            eACE.addAttribute("pw", ace.getSecret());
        }
        if (ace.deny()) {
            eACE.addAttribute("deny", ace.deny());
        }
        return eACE;
    }

    private static Element encodeFolderCommon(Element elem, ItemIdFormatter ifmt, Folder folder, int fields) {
        byte view;
        int unread;
        int folderId = folder.getId();
        elem.addAttribute("id", ifmt.formatItemId(folder));
        if (folderId != 11) {
            String name;
            if (ToXML.needToOutput(fields, 4096) && (name = folder.getName()) != null && name.length() > 0) {
                elem.addAttribute("name", name);
            }
            if (ToXML.needToOutput(fields, 256)) {
                elem.addAttribute("l", ifmt.formatItemId(folder.getFolderId()));
            }
        }
        if (ToXML.needToOutput(fields, 4)) {
            String flags = folder.getMailbox().getItemFlagString(folder);
            if (fields != -4194305 || !flags.equals("")) {
                elem.addAttribute("f", flags);
            }
        }
        if (ToXML.needToOutput(fields, 8192)) {
            elem.addAttribute("rgb", folder.getRgbColor().toString());
            byte color = folder.getColor();
            if (color != 0 || fields != -4194305) {
                elem.addAttribute("color", color);
            }
        }
        if (ToXML.needToOutput(fields, 1) && ((unread = folder.getUnreadCount()) > 0 || fields != -4194305)) {
            elem.addAttribute("u", unread);
        }
        if (ToXML.needToOutput(fields, 0x100000) && (view = folder.getDefaultView()) != -1) {
            elem.addAttribute("view", MailItem.getNameForType(view));
        }
        if (ToXML.needToOutput(fields, 65536)) {
            elem.addAttribute("rev", folder.getSavedSequence());
            elem.addAttribute("ms", folder.getModifiedSequence());
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            elem.addAttribute("md", folder.getChangeDate() / 1000L);
            elem.addAttribute("ms", folder.getModifiedSequence());
        }
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(elem, folder, fields);
        }
        return elem;
    }

    public static Element encodeSearchFolder(Element parent, ItemIdFormatter ifmt, SearchFolder search) {
        return ToXML.encodeSearchFolder(parent, ifmt, search, -4194305);
    }

    public static Element encodeSearchFolder(Element parent, ItemIdFormatter ifmt, SearchFolder search, int fields) {
        Element elem = parent.addElement("search");
        ToXML.encodeFolderCommon(elem, ifmt, search, fields);
        if (ToXML.needToOutput(fields, 32768)) {
            elem.addAttribute("query", search.getQuery());
            elem.addAttribute("sortBy", search.getSortField());
            elem.addAttribute("types", search.getReturnTypes());
        }
        return elem;
    }

    public static Element encodeMountpoint(Element parent, ItemIdFormatter ifmt, Mountpoint mpt) {
        return ToXML.encodeMountpoint(parent, ifmt, mpt, -4194305);
    }

    public static Element encodeMountpoint(Element parent, ItemIdFormatter ifmt, Mountpoint mpt, int fields) {
        Element elem = parent.addElement("link");
        ToXML.encodeFolderCommon(elem, ifmt, mpt, fields);
        if (ToXML.needToOutput(fields, 65536)) {
            elem.addAttribute("zid", mpt.getOwnerId());
            elem.addAttribute("rid", mpt.getRemoteId());
            NamedEntry nentry = FolderAction.lookupGranteeByZimbraId(mpt.getOwnerId(), (byte)1);
            elem.addAttribute("owner", nentry == null ? null : nentry.getName());
            if (mpt.getDefaultView() != -1) {
                elem.addAttribute("view", MailItem.getNameForType(mpt.getDefaultView()));
            }
        }
        return elem;
    }

    public static Element encodeRestUrl(Element elem, MailItem item) {
        try {
            return elem.addAttribute("rest", UserServlet.getRestUrl(item));
        }
        catch (ServiceException se) {
            mLog.error((Object)"cannot generate REST url", se);
            return elem;
        }
    }

    public static void recordItemTags(Element elem, MailItem item, int fields) {
        String tags;
        if (ToXML.needToOutput(fields, 5)) {
            String flags = item.getFlagString();
            if (fields != -4194305 || !flags.equals("")) {
                elem.addAttribute("f", flags);
            }
        }
        if (ToXML.needToOutput(fields, 2) && (!(tags = item.getTagString()).equals("") || fields != -4194305)) {
            elem.addAttribute("t", tags);
        }
    }

    public static void encodeAllCustomMetadata(Element elem, MailItem item, int fields) {
        List<String> sections = item.getCustomDataSections();
        if (sections == null || sections.isEmpty()) {
            if (fields != -4194305) {
                elem.addElement("meta");
            }
            return;
        }
        for (String section : sections) {
            try {
                ToXML.encodeCustomMetadata(elem, item.getCustomData(section));
            }
            catch (ServiceException e) {
                ZimbraLog.soap.warn("could not deserialize custom metadata; skipping (section '" + section + "', item " + new ItemId(item) + ")");
            }
        }
    }

    public static Element encodeCustomMetadata(Element elem, MailItem.CustomMetadata custom) {
        if (custom == null) {
            return null;
        }
        Element serialized = elem.addElement("meta");
        serialized.addAttribute("section", custom.getSectionKey());
        for (Map.Entry entry : custom.entrySet()) {
            serialized.addKeyValuePair((String)entry.getKey(), (String)entry.getValue());
        }
        return serialized;
    }

    public static Element encodeContact(Element parent, ItemIdFormatter ifmt, Contact contact, boolean summary, List<String> attrFilter) {
        return ToXML.encodeContact(parent, ifmt, contact, summary, attrFilter, -4194305);
    }

    public static Element encodeContact(Element parent, ItemIdFormatter ifmt, Contact contact, boolean summary, List<String> attrFilter, int fields) {
        Element elem;
        block23: {
            List<Contact.Attachment> attachments;
            Map<String, String> attrs;
            block22: {
                elem = parent.addElement("cn");
                elem.addAttribute("id", ifmt.formatItemId(contact));
                if (ToXML.needToOutput(fields, 256)) {
                    elem.addAttribute("l", ifmt.formatItemId(contact.getFolderId()));
                }
                ToXML.recordItemTags(elem, contact, fields);
                if (ToXML.needToOutput(fields, 0x400000)) {
                    elem.addAttribute("md", contact.getChangeDate() / 1000L);
                    elem.addAttribute("ms", contact.getModifiedSequence());
                    elem.addAttribute("d", contact.getDate());
                    elem.addAttribute("rev", contact.getSavedSequence());
                } else if (ToXML.needToOutput(fields, 65536)) {
                    elem.addAttribute("d", contact.getDate());
                    elem.addAttribute("rev", contact.getSavedSequence());
                }
                if (ToXML.needToOutput(fields, 524288)) {
                    ToXML.encodeAllCustomMetadata(elem, contact, fields);
                }
                if (!ToXML.needToOutput(fields, 65536)) {
                    if (summary) {
                        try {
                            elem.addAttribute("fileAsStr", contact.getFileAsString());
                        }
                        catch (ServiceException e) {
                            // empty catch block
                        }
                        elem.addAttribute("email", contact.get("email"));
                        elem.addAttribute("email2", contact.get("email2"));
                        elem.addAttribute("email3", contact.get("email3"));
                        String type = contact.get("type");
                        String dlist = contact.get("dlist");
                        if (type == null && dlist != null) {
                            type = "group";
                        }
                        elem.addAttribute("type", type);
                        if (dlist != null) {
                            elem.addAttribute("dlist", dlist);
                        }
                        elem.addAttribute("md", contact.getChangeDate() / 1000L);
                    }
                    return elem;
                }
                try {
                    elem.addAttribute("fileAsStr", contact.getFileAsString());
                }
                catch (ServiceException e) {
                    // empty catch block
                }
                attrs = contact.getFields();
                attachments = contact.getAttachments();
                if (attrFilter == null) break block22;
                for (String name : attrFilter) {
                    String value = attrs.get(name);
                    if (value != null && !value.equals("")) {
                        elem.addKeyValuePair(name, value);
                        continue;
                    }
                    if (attachments == null) continue;
                    for (Contact.Attachment attach : attachments) {
                        if (!attach.getName().equals(name)) continue;
                        ToXML.encodeContactAttachment(elem, attach);
                    }
                }
                break block23;
            }
            for (Map.Entry<String, String> me : attrs.entrySet()) {
                String name = me.getKey();
                String value = me.getValue();
                if (name == null || name.trim().equals("") || value == null || value.equals("")) continue;
                if (Contact.isMultiValueAttr(value)) {
                    try {
                        for (String v : Contact.parseMultiValueAttr(value)) {
                            elem.addKeyValuePair(name, v);
                        }
                        continue;
                    }
                    catch (JSONException e) {
                        // empty catch block
                    }
                }
                elem.addKeyValuePair(name, value);
            }
            if (attachments == null) break block23;
            for (Contact.Attachment attach : attachments) {
                ToXML.encodeContactAttachment(elem, attach);
            }
        }
        return elem;
    }

    private static void encodeContactAttachment(Element elem, Contact.Attachment attach) {
        Element.KeyValuePair kvp = elem.addKeyValuePair(attach.getName(), null);
        kvp.addAttribute("part", attach.getPartName()).addAttribute("ct", attach.getContentType());
        kvp.addAttribute("s", attach.getSize()).addAttribute("filename", attach.getFilename());
    }

    public static Element encodeNote(Element parent, ItemIdFormatter ifmt, Note note) {
        return ToXML.encodeNote(parent, ifmt, note, -4194305);
    }

    public static Element encodeNote(Element parent, ItemIdFormatter ifmt, Note note, int fields) {
        Element elem = parent.addElement("note");
        elem.addAttribute("id", ifmt.formatItemId(note));
        if (ToXML.needToOutput(fields, 65536) && note.getSavedSequence() != 0) {
            elem.addAttribute("rev", note.getSavedSequence());
        }
        if (ToXML.needToOutput(fields, 256)) {
            elem.addAttribute("l", ifmt.formatItemId(note.getFolderId()));
        }
        if (ToXML.needToOutput(fields, 32)) {
            elem.addAttribute("d", note.getDate());
        }
        ToXML.recordItemTags(elem, note, fields);
        if (ToXML.needToOutput(fields, 16384)) {
            elem.addAttribute("pos", note.getBounds().toString());
        }
        if (ToXML.needToOutput(fields, 8192)) {
            elem.addAttribute("rgb", note.getRgbColor().toString());
            elem.addAttribute("color", note.getColor());
        }
        if (ToXML.needToOutput(fields, 65536)) {
            elem.addAttribute("content", note.getText(), Element.Disposition.CONTENT);
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            elem.addAttribute("md", note.getChangeDate() / 1000L);
            elem.addAttribute("ms", note.getModifiedSequence());
        }
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(elem, note, fields);
        }
        return elem;
    }

    public static Element encodeTag(Element parent, ItemIdFormatter ifmt, Tag tag) {
        return ToXML.encodeTag(parent, ifmt, tag, -4194305);
    }

    public static Element encodeTag(Element parent, ItemIdFormatter ifmt, Tag tag, int fields) {
        int unreadCount;
        Element elem = parent.addElement("tag");
        elem.addAttribute("id", ifmt.formatItemId(tag));
        if (ToXML.needToOutput(fields, 4096)) {
            elem.addAttribute("name", tag.getName());
        }
        if (ToXML.needToOutput(fields, 8192)) {
            elem.addAttribute("rgb", tag.getRgbColor().toString());
            elem.addAttribute("color", tag.getColor());
        }
        if (ToXML.needToOutput(fields, 1) && ((unreadCount = tag.getUnreadCount()) > 0 || fields != -4194305)) {
            elem.addAttribute("u", unreadCount);
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            elem.addAttribute("d", tag.getDate());
            elem.addAttribute("rev", tag.getSavedSequence());
            elem.addAttribute("md", tag.getChangeDate() / 1000L);
            elem.addAttribute("ms", tag.getModifiedSequence());
        }
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(elem, tag, fields);
        }
        return elem;
    }

    public static Element encodeConversation(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Conversation conv, SearchParams params) throws ServiceException {
        Mailbox mbox = conv.getMailbox();
        List<Message> msgs = mbox.getMessagesByConversation(octxt, conv.getId(), SortBy.DATE_ASCENDING);
        return ToXML.encodeConversation(parent, ifmt, octxt, conv, msgs, params);
    }

    public static Element encodeConversation(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Conversation conv, List<Message> msgs, SearchParams params) throws ServiceException {
        int fields = -4194305;
        Element c = ToXML.encodeConversationCommon(parent, ifmt, conv, msgs, fields);
        if (msgs.isEmpty()) {
            return c;
        }
        c.addAttribute("su", msgs.get(0).getSubject(), Element.Disposition.CONTENT);
        SearchParams.ExpandResults expand = params.getInlineRule();
        for (Message msg : msgs) {
            if (msg.isTagged(-8)) continue;
            if (expand == SearchParams.ExpandResults.FIRST || expand == SearchParams.ExpandResults.ALL || expand.matches(msg)) {
                ToXML.encodeMessageAsMP(c, ifmt, octxt, msg, null, params.getMaxInlinedLength(), params.getWantHtml(), params.getNeuterImages(), params.getInlinedHeaders(), true);
                if (expand != SearchParams.ExpandResults.FIRST) continue;
                expand = SearchParams.ExpandResults.NONE;
                continue;
            }
            Element m = c.addElement("m");
            m.addAttribute("id", ifmt.formatItemId(msg));
            m.addAttribute("d", msg.getDate());
            m.addAttribute("s", msg.getSize());
            m.addAttribute("l", ifmt.formatItemId(msg.getFolderId()));
            ToXML.recordItemTags(m, msg, fields);
            m.addAttribute("fr", msg.getFragment(), Element.Disposition.CONTENT);
            ToXML.encodeEmail(m, msg.getSender(), EmailType.FROM);
        }
        return c;
    }

    public static Element encodeConversationSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Conversation conv, int fields) throws ServiceException {
        return ToXML.encodeConversationSummary(parent, ifmt, octxt, conv, null, OutputParticipants.PUT_SENDERS, fields, true);
    }

    public static Element encodeConversationSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Conversation conv, Message msgHit, OutputParticipants output) throws ServiceException {
        return ToXML.encodeConversationSummary(parent, ifmt, octxt, conv, msgHit, output, -4194305, true);
    }

    private static Element encodeConversationSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Conversation conv, Message msgHit, OutputParticipants output, int fields, boolean alwaysSerialize) throws ServiceException {
        Element c;
        boolean addRecips = msgHit != null && msgHit.isFromMe() && (output == OutputParticipants.PUT_RECIPIENTS || output == OutputParticipants.PUT_BOTH);
        boolean addSenders = (output == OutputParticipants.PUT_BOTH || !addRecips) && ToXML.needToOutput(fields, 2048);
        Mailbox mbox = conv.getMailbox();
        List<Message> msgs = null;
        if (octxt != null && octxt.isDelegatedRequest(mbox) || conv.isTagged(-8)) {
            msgs = mbox.getMessagesByConversation(octxt, conv.getId(), SortBy.DATE_ASCENDING);
        }
        boolean noneVisible = msgs != null && msgs.isEmpty();
        Element element = c = noneVisible && !alwaysSerialize ? null : ToXML.encodeConversationCommon(parent, ifmt, conv, msgs, fields);
        if (noneVisible) {
            return c;
        }
        if (ToXML.needToOutput(fields, 32)) {
            c.addAttribute("d", msgHit != null ? msgHit.getDate() : conv.getDate());
        }
        if (ToXML.needToOutput(fields, 64)) {
            c.addAttribute("su", msgHit != null ? msgHit.getSubject() : conv.getSubject(), Element.Disposition.CONTENT);
        }
        if (fields == -4194305 && msgHit != null) {
            c.addAttribute("fr", msgHit.getFragment(), Element.Disposition.CONTENT);
        }
        if (addRecips && msgHit != null) {
            ToXML.addEmails(c, Mime.parseAddressHeader(msgHit.getRecipients()), EmailType.TO);
        }
        if (addSenders) {
            SenderList sl;
            try {
                if (msgs != null) {
                    sl = new SenderList();
                    for (Message msg : msgs) {
                        if (msg.isTagged(-8)) continue;
                        sl.add(msg);
                    }
                } else {
                    sl = mbox.getConversationSenderList(conv.getId());
                }
            }
            catch (SenderList.RefreshException slre) {
                ZimbraLog.soap.warn("out-of-order messages returned for conversation " + conv.getId());
                return c;
            }
            catch (ServiceException e) {
                return c;
            }
            if (sl.getFirstAddress() != null) {
                ToXML.encodeEmail(c, sl.getFirstAddress(), EmailType.FROM);
            }
            if (sl.isElided()) {
                c.addAttribute("elided", true);
            }
            for (ParsedAddress pa : sl.getLastAddresses()) {
                ToXML.encodeEmail(c, pa, EmailType.FROM);
            }
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            c.addAttribute("md", conv.getChangeDate() / 1000L);
            c.addAttribute("ms", conv.getModifiedSequence());
        }
        return c;
    }

    private static Element encodeConversationCommon(Element parent, ItemIdFormatter ifmt, Conversation conv, List<Message> msgs, int fields) {
        Element c = parent.addElement("c");
        c.addAttribute("id", ifmt.formatItemId(conv));
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(c, conv, fields);
        }
        if (ToXML.needToOutput(fields, 1040)) {
            int count;
            int nondeleted = count = conv.getMessageCount();
            if (msgs != null) {
                count = nondeleted = msgs.size();
                for (Message msg : msgs) {
                    if (!msg.isTagged(-8)) continue;
                    --nondeleted;
                }
            }
            c.addAttribute("n", nondeleted);
            if (count != nondeleted) {
                c.addAttribute("total", count);
            }
        }
        if (msgs == null) {
            ToXML.recordItemTags(c, conv, fields);
        } else if (ToXML.needToOutput(fields, 7)) {
            int flags = 0;
            long tags = 0L;
            for (Message msg : msgs) {
                if (msg.isTagged(-8)) continue;
                flags |= msg.getFlagBitmask();
                tags |= msg.getTagBitmask();
            }
            if (ToXML.needToOutput(fields, 5) && (fields != -4194305 || flags != 0)) {
                c.addAttribute("f", Flag.bitmaskToFlags(flags));
            }
            if (ToXML.needToOutput(fields, 2) && (fields != -4194305 || tags != 0L)) {
                c.addAttribute("t", Tag.bitmaskToTags(tags));
            }
        }
        return c;
    }

    public static Element encodeMessageAsMP(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Message msg, String part, int maxSize, boolean wantHTML, boolean neuter, Set<String> headers, boolean serializeType) throws ServiceException {
        Element m;
        boolean wholeMessage;
        boolean bl = wholeMessage = part == null || part.trim().equals("");
        if (wholeMessage) {
            m = ToXML.encodeMessageCommon(parent, ifmt, msg, -4194305, serializeType);
            m.addAttribute("id", ifmt.formatItemId(msg));
        } else {
            m = parent.addElement("m");
            m.addAttribute("id", ifmt.formatItemId(msg));
            m.addAttribute("part", part);
        }
        try {
            List<MPartInfo> parts;
            Date sent;
            String messageID;
            String fragment;
            MimeMessage mm = msg.getMimeMessage();
            if (!wholeMessage) {
                MimePart mp = Mime.getMimePart((MimePart)mm, part);
                if (mp == null) {
                    throw MailServiceException.NO_SUCH_PART(part);
                }
                MimeMessage content = Mime.getMessageContent(mp);
                if (!(content instanceof MimeMessage)) {
                    throw MailServiceException.NO_SUCH_PART(part);
                }
                mm = content;
            } else {
                part = "";
            }
            ToXML.addEmails(m, Mime.parseAddressHeader(mm, "From"), EmailType.FROM);
            ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Sender"), EmailType.SENDER);
            ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Reply-To"), EmailType.REPLY_TO);
            ToXML.addEmails(m, Mime.parseAddressHeader(mm, "To"), EmailType.TO);
            ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Cc"), EmailType.CC);
            ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Bcc"), EmailType.BCC);
            if (!octxt.isDelegatedRequest(msg.getMailbox())) {
                ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Disposition-Notification-To"), EmailType.READ_RECEIPT);
            }
            String calIntendedFor = msg.getCalendarIntendedFor();
            m.addAttribute("cif", calIntendedFor);
            String subject = Mime.getSubject(mm);
            if (subject != null) {
                m.addAttribute("su", StringUtil.stripControlCharacters(subject), Element.Disposition.CONTENT);
            }
            if ((fragment = msg.getFragment()) != null && !fragment.equals("")) {
                m.addAttribute("fr", fragment, Element.Disposition.CONTENT);
            }
            if ((messageID = mm.getMessageID()) != null && !messageID.trim().equals("")) {
                m.addAttribute("mid", StringUtil.stripControlCharacters(messageID), Element.Disposition.CONTENT);
            }
            if (wholeMessage && msg.isDraft()) {
                String inReplyTo;
                if (!msg.getDraftOrigId().equals("")) {
                    m.addAttribute("origid", ifmt.formatItemId(new ItemId(msg.getDraftOrigId(), msg.getMailbox().getAccountId())));
                }
                if (!msg.getDraftReplyType().equals("")) {
                    m.addAttribute("rt", msg.getDraftReplyType());
                }
                if (!msg.getDraftIdentityId().equals("")) {
                    m.addAttribute("idnt", msg.getDraftIdentityId());
                }
                if (!msg.getDraftAccountId().equals("")) {
                    m.addAttribute("forAcct", msg.getDraftAccountId());
                }
                if ((inReplyTo = mm.getHeader("In-Reply-To", null)) != null && !inReplyTo.equals("")) {
                    m.addAttribute("irt", StringUtil.stripControlCharacters(inReplyTo), Element.Disposition.CONTENT);
                }
            }
            if (!wholeMessage) {
                m.addAttribute("s", mm.getSize());
            }
            if ((sent = mm.getSentDate()) != null) {
                m.addAttribute("sd", sent.getTime());
            }
            if (msg.isInvite() && msg.hasCalendarItemInfos()) {
                ToXML.encodeInvitesForMessage(m, ifmt, octxt, msg, -4194305, neuter);
            }
            if (headers != null) {
                for (String name : headers) {
                    String[] values = mm.getHeader(name);
                    if (values == null) continue;
                    for (int i = 0; i < values.length; ++i) {
                        m.addKeyValuePair(name, values[i], "header", "n");
                    }
                }
            }
            if ((parts = Mime.getParts(mm)) != null && !parts.isEmpty()) {
                Set<MPartInfo> bodies = Mime.getBody(parts, wantHTML);
                ToXML.addParts(m, parts.get(0), bodies, part, maxSize, neuter, false, ToXML.getDefaultCharset(msg));
            }
        }
        catch (IOException ex) {
            throw ServiceException.FAILURE(ex.getMessage(), ex);
        }
        catch (MessagingException ex) {
            throw ServiceException.FAILURE(ex.getMessage(), ex);
        }
        return m;
    }

    public static void setCalendarItemFields(Element calItemElem, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem, int fields, boolean encodeInvites, boolean includeContent, boolean neuter) throws ServiceException {
        ToXML.recordItemTags(calItemElem, calItem, fields);
        calItemElem.addAttribute("uid", calItem.getUid());
        calItemElem.addAttribute("id", ifmt.formatItemId(calItem));
        calItemElem.addAttribute("l", ifmt.formatItemId(calItem.getFolderId()));
        if (ToXML.needToOutput(fields, 65536) && calItem.getSavedSequence() != 0) {
            calItemElem.addAttribute("rev", calItem.getSavedSequence());
        }
        if (ToXML.needToOutput(fields, 16)) {
            calItemElem.addAttribute("s", calItem.getSize());
        }
        if (ToXML.needToOutput(fields, 32)) {
            calItemElem.addAttribute("d", calItem.getDate());
        }
        if (ToXML.needToOutput(fields, 256)) {
            calItemElem.addAttribute("l", ifmt.formatItemId(calItem.getFolderId()));
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            calItemElem.addAttribute("md", calItem.getChangeDate() / 1000L);
            calItemElem.addAttribute("ms", calItem.getModifiedSequence());
        }
        if (ToXML.needToOutput(fields, 65536) && encodeInvites) {
            boolean isPublic = true;
            for (int i = 0; i < calItem.numInvites(); ++i) {
                Invite inv = calItem.getInvite(i);
                ToXML.encodeInvite(calItemElem, ifmt, octxt, calItem, calItem.getInvite(i), includeContent, neuter);
                if (inv.isPublic()) continue;
                isPublic = false;
            }
            if (isPublic || ToXML.allowPrivateAccess(octxt, calItem)) {
                ToXML.encodeCalendarReplies(calItemElem, calItem);
            }
            ToXML.encodeAlarmTimes(calItemElem, calItem);
        }
    }

    public static void setCalendarItemFields(Element calItemElem, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem, int fields, boolean encodeInvites, boolean neuter) throws ServiceException {
        ToXML.setCalendarItemFields(calItemElem, ifmt, octxt, calItem, fields, encodeInvites, false, neuter);
    }

    public static Element encodeInvite(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem cal, Invite inv, boolean neuter) throws ServiceException {
        return ToXML.encodeInvite(parent, ifmt, octxt, cal, inv, false, neuter);
    }

    public static Element encodeInvite(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem cal, Invite inv, boolean includeContent, boolean neuter) throws ServiceException {
        int invId;
        MimeMessage mm;
        Element ie = parent.addElement("inv");
        ToXML.setCalendarItemType(ie, cal.getType());
        ToXML.encodeTimeZoneMap(ie, cal.getTimeZoneMap());
        ie.addAttribute("seq", inv.getSeqNo());
        ie.addAttribute("id", ifmt.formatItemId(inv.getMailItemId()));
        ie.addAttribute("compNum", inv.getComponentNum());
        if (inv.hasRecurId()) {
            ie.addAttribute("recurId", inv.getRecurId().toString());
        }
        ToXML.encodeInviteComponent(ie, ifmt, octxt, cal, inv, -4194305, neuter);
        if (includeContent && (inv.isPublic() || ToXML.allowPrivateAccess(octxt, cal)) && (mm = cal.getSubpartMessage(invId = inv.getMailItemId())) != null) {
            List<MPartInfo> parts;
            try {
                parts = Mime.getParts(mm);
            }
            catch (IOException ex) {
                throw ServiceException.FAILURE(ex.getMessage(), ex);
            }
            catch (MessagingException ex) {
                throw ServiceException.FAILURE(ex.getMessage(), ex);
            }
            if (parts != null && !parts.isEmpty()) {
                ToXML.addParts(ie, parts.get(0), null, "", -1, false, true, ToXML.getDefaultCharset(cal));
            }
        }
        return ie;
    }

    public static Element encodeCalendarItemSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem, int fields, boolean includeInvites, boolean includeContent) throws ServiceException {
        Element elem = calItem instanceof Appointment ? parent.addElement("appt") : parent.addElement("task");
        ToXML.setCalendarItemFields(elem, ifmt, octxt, calItem, fields, includeInvites, includeContent, true);
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(elem, calItem, fields);
        }
        return elem;
    }

    public static Element encodeCalendarItemSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem, int fields, boolean includeInvites) throws ServiceException {
        return ToXML.encodeCalendarItemSummary(parent, ifmt, octxt, calItem, fields, includeInvites, false);
    }

    public static void encodeCalendarReplies(Element parent, CalendarItem calItem, Invite inv, String recurIdZ) {
        List<CalendarItem.ReplyInfo> replies = calItem.getReplyInfo(inv, recurIdZ);
        ToXML.encodeCalendarReplies(parent, calItem, replies);
    }

    public static void encodeCalendarReplies(Element parent, CalendarItem calItem) {
        List<CalendarItem.ReplyInfo> replies = calItem.getAllReplies();
        ToXML.encodeCalendarReplies(parent, calItem, replies);
    }

    private static void encodeCalendarReplies(Element parent, CalendarItem calItem, List<CalendarItem.ReplyInfo> replies) {
        Element repliesElt = parent.addElement("replies");
        for (CalendarItem.ReplyInfo repInfo : replies) {
            RecurId rid;
            Element curElt = repliesElt.addElement("reply");
            curElt.addAttribute("seq", repInfo.getSeq());
            curElt.addAttribute("d", repInfo.getDtStamp());
            ZAttendee attendee = repInfo.getAttendee();
            curElt.addAttribute("at", attendee.getAddress());
            if (attendee.hasSentBy()) {
                curElt.addAttribute("sentBy", attendee.getSentBy());
            }
            if (attendee.hasPartStat()) {
                curElt.addAttribute("ptst", attendee.getPartStat());
            }
            if ((rid = repInfo.getRecurId()) == null) continue;
            rid.toXml(curElt);
        }
    }

    private static String getDefaultCharset(MailItem item) throws ServiceException {
        Account acct = item == null ? null : item.getAccount();
        return acct == null ? null : acct.getAttr("zimbraPrefMailDefaultCharset", null);
    }

    public static Element encodeInviteAsMP(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem, String recurIdZ, ItemId iid, String part, int maxSize, boolean wantHTML, boolean neuter, Set<String> headers, boolean serializeType) throws ServiceException {
        Element m;
        boolean wholeMessage;
        int invId = iid.getSubpartId();
        Invite[] invites = calItem.getInvites(invId);
        boolean isPublic = calItem.isPublic();
        boolean showAll = isPublic || ToXML.allowPrivateAccess(octxt, calItem);
        boolean bl = wholeMessage = part == null || part.trim().equals("");
        if (wholeMessage) {
            m = ToXML.encodeMessageCommon(parent, ifmt, calItem, -4194305, serializeType);
            m.addAttribute("id", ifmt.formatItemId(calItem, invId));
        } else {
            m = parent.addElement("m");
            m.addAttribute("id", ifmt.formatItemId(calItem, invId));
            m.addAttribute("part", part);
        }
        try {
            MimeMessage mm = calItem.getSubpartMessage(invId);
            if (mm != null) {
                if (!wholeMessage) {
                    MimePart mp = Mime.getMimePart((MimePart)mm, part);
                    if (mp == null) {
                        throw MailServiceException.NO_SUCH_PART(part);
                    }
                    MimeMessage content = Mime.getMessageContent(mp);
                    if (!(content instanceof MimeMessage)) {
                        throw MailServiceException.NO_SUCH_PART(part);
                    }
                    mm = content;
                } else {
                    part = "";
                }
                if (showAll) {
                    Date sent;
                    String messageID;
                    ToXML.addEmails(m, Mime.parseAddressHeader(mm, "From"), EmailType.FROM);
                    ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Sender"), EmailType.SENDER);
                    ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Reply-To"), EmailType.REPLY_TO);
                    ToXML.addEmails(m, Mime.parseAddressHeader(mm, "To"), EmailType.TO);
                    ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Cc"), EmailType.CC);
                    ToXML.addEmails(m, Mime.parseAddressHeader(mm, "Bcc"), EmailType.BCC);
                    String subject = Mime.getSubject(mm);
                    if (subject != null) {
                        m.addAttribute("su", StringUtil.stripControlCharacters(subject), Element.Disposition.CONTENT);
                    }
                    if ((messageID = mm.getMessageID()) != null && !messageID.trim().equals("")) {
                        m.addAttribute("mid", StringUtil.stripControlCharacters(messageID), Element.Disposition.CONTENT);
                    }
                    if (!wholeMessage) {
                        m.addAttribute("s", mm.getSize());
                    }
                    if ((sent = mm.getSentDate()) != null) {
                        m.addAttribute("sd", sent.getTime());
                    }
                }
            }
            Element invElt = m.addElement("inv");
            ToXML.setCalendarItemType(invElt, calItem.getType());
            ToXML.encodeTimeZoneMap(invElt, calItem.getTimeZoneMap());
            if (invites.length > 0) {
                if (showAll) {
                    ToXML.encodeCalendarReplies(invElt, calItem, invites[0], recurIdZ);
                }
                for (Invite inv : invites) {
                    ToXML.encodeInviteComponent(invElt, ifmt, octxt, calItem, inv, -4194305, neuter);
                }
            }
            if (mm != null && showAll) {
                List<MPartInfo> parts;
                if (headers != null) {
                    for (String name : headers) {
                        String[] values = mm.getHeader(name);
                        if (values == null) continue;
                        for (int i = 0; i < values.length; ++i) {
                            m.addKeyValuePair(name, values[i], "header", "n");
                        }
                    }
                }
                if ((parts = Mime.getParts(mm)) != null && !parts.isEmpty()) {
                    Set<MPartInfo> bodies = Mime.getBody(parts, wantHTML);
                    ToXML.addParts(m, parts.get(0), bodies, part, maxSize, neuter, true, ToXML.getDefaultCharset(calItem));
                }
            }
        }
        catch (IOException ex) {
            throw ServiceException.FAILURE(ex.getMessage(), ex);
        }
        catch (MessagingException ex) {
            throw ServiceException.FAILURE(ex.getMessage(), ex);
        }
        return m;
    }

    public static Element encodeMessageAsMIME(Element parent, ItemIdFormatter ifmt, Message msg, String part, boolean serializeType) throws ServiceException {
        return ToXML.encodeMessageAsMIME(parent, ifmt, msg, part, false, serializeType);
    }

    public static Element encodeMessageAsMIME(Element parent, ItemIdFormatter ifmt, Message msg, String part, boolean mustInline, boolean serializeType) throws ServiceException {
        Element m;
        boolean wholeMessage;
        boolean bl = wholeMessage = part == null || part.trim().equals("");
        if (wholeMessage) {
            m = ToXML.encodeMessageCommon(parent, ifmt, msg, -4194305, serializeType);
            m.addAttribute("id", ifmt.formatItemId(msg));
        } else {
            m = parent.addElement("m");
            m.addAttribute("id", ifmt.formatItemId(msg));
            m.addAttribute("part", part);
        }
        Element content = m.addUniqueElement("content");
        long size = msg.getSize() + 2048L;
        if (!wholeMessage) {
            content.addAttribute("url", CONTENT_SERVLET_URI + ifmt.formatItemId(msg) + PART_PARAM_STRING + part);
        } else if (!mustInline && size > 40000L) {
            content.addAttribute("url", CONTENT_SERVLET_URI + ifmt.formatItemId(msg));
        } else {
            try {
                byte[] raw = msg.getContent();
                if (!ByteUtil.isASCII(raw)) {
                    if (!mustInline) {
                        content.addAttribute("url", CONTENT_SERVLET_URI + ifmt.formatItemId(msg));
                    } else {
                        content.setText(new String(raw, "utf-8"));
                    }
                } else {
                    content.setText(new String(raw, "US-ASCII"));
                }
            }
            catch (IOException ex) {
                throw ServiceException.FAILURE(ex.getMessage(), ex);
            }
        }
        return m;
    }

    public static Element encodeMessageSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Message msg, OutputParticipants output) {
        return ToXML.encodeMessageSummary(parent, ifmt, octxt, msg, output, -4194305);
    }

    public static Element encodeMessageSummary(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Message msg, OutputParticipants output, int fields) {
        boolean addSenders;
        Element elem = ToXML.encodeMessageCommon(parent, ifmt, msg, fields, true);
        elem.addAttribute("id", ifmt.formatItemId(msg));
        if (!ToXML.needToOutput(fields, 65536)) {
            return elem;
        }
        boolean addRecips = msg.isFromMe() && (output == OutputParticipants.PUT_RECIPIENTS || output == OutputParticipants.PUT_BOTH);
        boolean bl = addSenders = output == OutputParticipants.PUT_BOTH || !addRecips;
        if (addRecips) {
            ToXML.addEmails(elem, Mime.parseAddressHeader(msg.getRecipients()), EmailType.TO);
        }
        if (addSenders) {
            ToXML.encodeEmail(elem, msg.getSender(), EmailType.FROM);
        }
        elem.addAttribute("su", StringUtil.stripControlCharacters(msg.getSubject()), Element.Disposition.CONTENT);
        String fragment = msg.getFragment();
        if (!fragment.equals("")) {
            elem.addAttribute("fr", fragment, Element.Disposition.CONTENT);
        }
        if (msg.isInvite() && msg.hasCalendarItemInfos()) {
            try {
                ToXML.encodeInvitesForMessage(elem, ifmt, octxt, msg, fields, true);
            }
            catch (ServiceException ex) {
                mLog.debug((Object)("Caught exception while encoding Invites for msg " + msg.getId()), ex);
            }
        }
        return elem;
    }

    private static Element encodeMessageCommon(Element parent, ItemIdFormatter ifmt, MailItem item, int fields, boolean serializeType) {
        String name = serializeType && item instanceof Chat ? "chat" : "m";
        Element elem = parent.addElement(name);
        if (ToXML.needToOutput(fields, 16)) {
            elem.addAttribute("s", item.getSize());
        }
        if (ToXML.needToOutput(fields, 32)) {
            elem.addAttribute("d", item.getDate());
        }
        if (ToXML.needToOutput(fields, 256)) {
            elem.addAttribute("l", ifmt.formatItemId(item.getFolderId()));
        }
        if (item instanceof Message) {
            Message msg = (Message)item;
            if (ToXML.needToOutput(fields, 512) && (fields != -4194305 || msg.getConversationId() != -1)) {
                elem.addAttribute("cid", ifmt.formatItemId(msg.getConversationId()));
            }
        }
        ToXML.recordItemTags(elem, item, fields);
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(elem, item, fields);
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            elem.addAttribute("rev", item.getSavedSequence());
            elem.addAttribute("md", item.getChangeDate() / 1000L);
            elem.addAttribute("ms", item.getModifiedSequence());
        } else if (ToXML.needToOutput(fields, 65536) && item.getSavedSequence() != 0) {
            elem.addAttribute("rev", item.getSavedSequence());
        }
        return elem;
    }

    private static void encodeTimeZoneMap(Element parent, TimeZoneMap tzmap) {
        assert (tzmap != null);
        Iterator<ICalTimeZone> iter = tzmap.tzIterator();
        while (iter.hasNext()) {
            ICalTimeZone tz = iter.next();
            Element e = parent.addElement("tz");
            e.addAttribute("id", tz.getID());
            e.addAttribute("stdoff", tz.getStandardOffset() / 60 / 1000);
            e.addAttribute("stdname", tz.getStandardTzname());
            if (!tz.useDaylightTime()) continue;
            ICalTimeZone.SimpleOnset standard = tz.getStandardOnset();
            ICalTimeZone.SimpleOnset daylight = tz.getDaylightOnset();
            if (standard == null || daylight == null) continue;
            e.addAttribute("dayoff", tz.getDaylightOffset() / 60 / 1000);
            e.addAttribute("dayname", tz.getDaylightTzname());
            Element std = e.addElement("standard");
            int standardWeek = standard.getWeek();
            if (standardWeek != 0) {
                std.addAttribute("week", standardWeek);
                std.addAttribute("wkday", standard.getDayOfWeek());
            } else {
                std.addAttribute("mday", standard.getDayOfMonth());
            }
            std.addAttribute("mon", standard.getMonth());
            std.addAttribute("hour", standard.getHour());
            std.addAttribute("min", standard.getMinute());
            std.addAttribute("sec", standard.getSecond());
            Element day = e.addElement("daylight");
            int daylightWeek = daylight.getWeek();
            if (daylightWeek != 0) {
                day.addAttribute("week", daylightWeek);
                day.addAttribute("wkday", daylight.getDayOfWeek());
            } else {
                day.addAttribute("mday", daylight.getDayOfMonth());
            }
            day.addAttribute("mon", daylight.getMonth());
            day.addAttribute("hour", daylight.getHour());
            day.addAttribute("min", daylight.getMinute());
            day.addAttribute("sec", daylight.getSecond());
        }
    }

    private static boolean allowPrivateAccess(OperationContext octxt, CalendarItem calItem) throws ServiceException {
        Account authAccount = octxt != null ? octxt.getAuthenticatedUser() : null;
        boolean asAdmin = octxt != null ? octxt.isUsingAdminPrivileges() : false;
        return calItem.allowPrivateAccess(authAccount, asAdmin);
    }

    public static Element encodeInviteComponent(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem, Invite invite, int fields, boolean neuter) throws ServiceException {
        boolean allowPrivateAccess;
        boolean allFields = true;
        if (fields != -4194305) {
            allFields = false;
            if (!ToXML.needToOutput(fields, 131072)) {
                return parent;
            }
        }
        Element e = parent.addElement("comp");
        e.addAttribute("method", invite.getMethod());
        e.addAttribute("compNum", invite.getComponentNum());
        e.addAttribute("rsvp", invite.getRsvp());
        boolean bl = allowPrivateAccess = calItem != null ? ToXML.allowPrivateAccess(octxt, calItem) : true;
        if (allFields) {
            ParsedDuration dur;
            ParsedDateTime dtEnd;
            Recurrence.IRecurrence recur;
            if (invite.isPublic() || allowPrivateAccess) {
                String descHtml;
                String desc;
                Geo geo;
                List<String> contacts;
                List<String> comments;
                String priority = invite.getPriority();
                if (priority != null) {
                    e.addAttribute("priority", priority);
                }
                e.addAttribute("name", invite.getName());
                e.addAttribute("loc", invite.getLocation());
                List<String> categories = invite.getCategories();
                if (categories != null) {
                    for (String cat : categories) {
                        e.addElement("category").setText(cat);
                    }
                }
                if ((comments = invite.getComments()) != null) {
                    for (String cmt : comments) {
                        e.addElement("comment").setText(cmt);
                    }
                }
                if ((contacts = invite.getContacts()) != null) {
                    for (String contact : contacts) {
                        e.addElement("contact").setText(contact);
                    }
                }
                if ((geo = invite.getGeo()) != null) {
                    geo.toXml(e);
                }
                if (invite.isTodo()) {
                    long completed;
                    String pct = invite.getPercentComplete();
                    if (pct != null) {
                        e.addAttribute("percentComplete", pct);
                    }
                    if ((completed = invite.getCompleted()) != 0L) {
                        ParsedDateTime c = ParsedDateTime.fromUTCTime(completed);
                        e.addAttribute("completed", c.getDateTimePartString());
                    }
                }
                List<ZAttendee> attendees = invite.getAttendees();
                for (ZAttendee at : attendees) {
                    at.toXml(e);
                }
                Iterator<Alarm> alarmsIter = invite.alarmsIterator();
                while (alarmsIter.hasNext()) {
                    Alarm alarm = alarmsIter.next();
                    alarm.toXml(e);
                }
                ToXML.encodeXProps(e, invite.xpropsIterator());
                String fragment = invite.getFragment();
                if (fragment != null && fragment.length() > 0) {
                    e.addAttribute("fr", fragment, Element.Disposition.CONTENT);
                }
                if (!invite.hasBlobPart()) {
                    e.addAttribute("noBlob", true);
                }
                if ((desc = invite.getDescription()) != null) {
                    Element descElem = e.addElement("desc");
                    descElem.setText(desc);
                }
                if ((descHtml = invite.getDescriptionHtml()) != null) {
                    try {
                        descHtml = StringUtil.stripControlCharacters(descHtml);
                        descHtml = HtmlDefang.defang(descHtml, neuter);
                        Element descHtmlElem = e.addElement("descHtml");
                        descHtmlElem.setText(descHtml);
                    }
                    catch (IOException ex) {
                        ZimbraLog.calendar.warn((Object)"Unable to defang HTML for SetAppointmentRequest", ex);
                    }
                }
                if (invite.isEvent()) {
                    if (calItem != null && calItem instanceof Appointment) {
                        CalendarItem.Instance inst = CalendarItem.Instance.fromInvite(calItem.getId(), invite);
                        Appointment appt = (Appointment)calItem;
                        e.addAttribute("fba", appt.getEffectiveFreeBusyActual(invite, inst));
                    }
                    e.addAttribute("fb", invite.getFreeBusy());
                    e.addAttribute("transp", invite.getTransparency());
                }
            }
            if (invite.isOrganizer()) {
                e.addAttribute("isOrg", true);
            }
            if (invite.hasOrganizer()) {
                ZOrganizer org = invite.getOrganizer();
                org.toXml(e);
            }
            boolean isRecurring = false;
            e.addAttribute("x_uid", invite.getUid());
            e.addAttribute("uid", invite.getUid());
            e.addAttribute("seq", invite.getSeqNo());
            e.addAttribute("d", invite.getDTStamp());
            if (calItem != null) {
                String itemId = ifmt.formatItemId(calItem);
                e.addAttribute("calItemId", itemId);
                if (invite.isEvent()) {
                    e.addAttribute("apptId", itemId);
                }
            }
            if ((recur = invite.getRecurrence()) != null) {
                isRecurring = true;
                Element recurElt = e.addElement("recur");
                recur.toXml(recurElt);
            }
            e.addAttribute("status", invite.getStatus());
            e.addAttribute("class", invite.getClassProp());
            e.addAttribute("url", invite.getUrl());
            boolean allDay = invite.isAllDayEvent();
            boolean isException = invite.hasRecurId();
            if (isException) {
                e.addAttribute("ex", true);
                RecurId rid = invite.getRecurId();
                e.addAttribute("ridZ", rid.getDtZ());
                ToXML.encodeRecurId(e, rid, allDay);
            }
            boolean forceUTC = DebugConfig.calendarForceUTC && !isRecurring && !isException && !allDay;
            ParsedDateTime dtStart = invite.getStartTime();
            if (dtStart != null) {
                ToXML.encodeDtStart(e, dtStart, allDay, forceUTC);
            }
            if ((dtEnd = invite.getEndTime()) != null) {
                ToXML.encodeDtEnd(e, dtEnd, allDay, invite.isTodo(), forceUTC);
            }
            if ((dur = invite.getDuration()) != null) {
                dur.toXml(e);
            }
            if (allDay) {
                e.addAttribute("allDay", true);
            }
        }
        return e;
    }

    public static void encodeXParams(Element parent, Iterator<ZCalendar.ZParameter> xparamsIterator) {
        while (xparamsIterator.hasNext()) {
            ZCalendar.ZParameter xparam = xparamsIterator.next();
            String paramName = xparam.getName();
            if (paramName == null) continue;
            Element paramElem = parent.addElement("xparam");
            paramElem.addAttribute("name", paramName);
            String paramValue = xparam.getValue();
            if (paramValue == null) continue;
            paramElem.addAttribute("value", paramValue);
        }
    }

    public static void encodeXProps(Element parent, Iterator<ZCalendar.ZProperty> xpropsIterator) {
        while (xpropsIterator.hasNext()) {
            ZCalendar.ZProperty xprop = xpropsIterator.next();
            String propName = xprop.getName();
            if (propName == null) continue;
            String propValue = xprop.getValue();
            Element propElem = parent.addElement("xprop");
            propElem.addAttribute("name", propName);
            if (propValue != null) {
                propElem.addAttribute("value", propValue);
            }
            ToXML.encodeXParams(propElem, xprop.parameterIterator());
        }
    }

    private static Element encodeInvitesForMessage(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Message msg, int fields, boolean neuter) throws ServiceException {
        if (fields != -4194305 && !ToXML.needToOutput(fields, 131072)) {
            return parent;
        }
        Element ie = parent.addElement("inv");
        Mailbox mbox = msg.getMailbox();
        Iterator<Message.CalendarItemInfo> iter = msg.getCalendarItemInfoIterator();
        while (iter.hasNext()) {
            Message.CalendarItemInfo info = iter.next();
            CalendarItem calItem = null;
            ZCalendar.ICalTok method = ZCalendar.ICalTok.REQUEST;
            Invite invCi = info.getInvite();
            if (invCi != null) {
                method = Invite.lookupMethod(invCi.getMethod());
            }
            Invite invite = invCi;
            if (info.calItemCreated()) {
                block15: {
                    try {
                        calItem = mbox.getCalendarItemById(octxt, info.getCalendarItemId());
                    }
                    catch (MailServiceException.NoSuchItemException e) {
                    }
                    catch (ServiceException e) {
                        if (e.getCode() == "service.PERM_DENIED") break block15;
                        throw e;
                    }
                }
                if ((ZCalendar.ICalTok.REQUEST.equals((Object)method) || ZCalendar.ICalTok.PUBLISH.equals((Object)method)) && calItem != null && calItem.getFolderId() != 3) {
                    invite = calItem.getInvite(msg.getId(), info.getComponentNo());
                }
            } else if (invCi != null) {
                if (!Invite.isOrganizerMethod(invCi.getMethod()) || ZCalendar.ICalTok.DECLINECOUNTER.equals((Object)method)) {
                    invite = invCi;
                } else {
                    Invite invCurr;
                    block16: {
                        try {
                            calItem = mbox.getCalendarItemByUid(octxt, invCi.getUid());
                        }
                        catch (MailServiceException.NoSuchItemException e) {
                        }
                        catch (ServiceException e) {
                            if (e.getCode() == "service.PERM_DENIED") break block16;
                            throw e;
                        }
                    }
                    invite = calItem != null ? ((invCurr = calItem.getInvite(invCi.getRecurId())) != null ? (invCi.getSeqNo() >= invCurr.getSeqNo() ? invCi : null) : invCi) : invCi;
                }
            }
            if (invite == null) continue;
            ToXML.setCalendarItemType(ie, invite.getItemType());
            ToXML.encodeTimeZoneMap(ie, invite.getTimeZoneMap());
            ToXML.encodeInviteComponent(ie, ifmt, octxt, calItem, invite, fields, neuter);
        }
        return ie;
    }

    private static void addParts(Element root, MPartInfo mpi, Set<MPartInfo> bodies, String prefix, int maxSize, boolean neuter, boolean excludeCalendarParts, String defaultCharset) {
        LinkedList<Pair<Element, LinkedList<MPartInfo>>> queue = new LinkedList<Pair<Element, LinkedList<MPartInfo>>>();
        Pair level = new Pair(root, new LinkedList());
        level.getSecond().add(mpi);
        queue.add(level);
        VisitPhase phase = VisitPhase.PREVISIT;
        while (!queue.isEmpty()) {
            level = (Pair)queue.getLast();
            LinkedList parts = (LinkedList)level.getSecond();
            if (parts.isEmpty()) {
                queue.removeLast();
                phase = VisitPhase.POSTVISIT;
                continue;
            }
            mpi = (MPartInfo)parts.getFirst();
            Element child = ToXML.addPart(phase, (Element)level.getFirst(), root, mpi, bodies, prefix, maxSize, neuter, excludeCalendarParts, defaultCharset);
            if (phase == VisitPhase.PREVISIT && child != null && mpi.hasChildren()) {
                queue.addLast(new Pair<Element, LinkedList<MPartInfo>>(child, new LinkedList<MPartInfo>(mpi.getChildren())));
                continue;
            }
            parts.removeFirst();
            phase = VisitPhase.PREVISIT;
        }
    }

    private static Element addPart(VisitPhase phase, Element parent, Element root, MPartInfo mpi, Set<MPartInfo> bodies, String prefix, int maxSize, boolean neuter, boolean excludeCalendarParts, String defaultCharset) {
        if (phase == VisitPhase.POSTVISIT) {
            return null;
        }
        String ctype = StringUtil.stripControlCharacters(mpi.getContentType());
        if (excludeCalendarParts && "text/calendar".equalsIgnoreCase(ctype)) {
            return null;
        }
        Element elem = parent.addElement("mp");
        MimePart mp = mpi.getMimePart();
        String part = mpi.getPartName();
        part = prefix + (prefix.equals("") || part.equals("") ? "" : ".") + part;
        elem.addAttribute("part", part);
        if ("xml/x-zimbra-share".equals(ctype)) {
            Element shr = root.addElement("shr");
            try {
                ToXML.addContent(shr, mpi, maxSize, defaultCharset);
            }
            catch (IOException e) {
                if (mLog.isWarnEnabled()) {
                    mLog.warn((Object)"error writing body part: ", e);
                }
            }
            catch (MessagingException e) {}
        } else if ("text/enriched".equals(ctype)) {
            ctype = "text/html";
        }
        elem.addAttribute("ct", ctype);
        try {
            int size = mp.getSize();
            if (size >= 0) {
                if ("base64".equalsIgnoreCase(mp.getEncoding())) {
                    size = (int)((double)size * 0.75 - (double)(size / 76));
                }
            } else {
                size = 0;
            }
            elem.addAttribute("s", size);
        }
        catch (MessagingException me) {
            // empty catch block
        }
        try {
            String disp = mp.getHeader("Content-Disposition", null);
            if (disp != null) {
                ContentDisposition cdisp = new ContentDisposition(MimeUtility.decodeText((String)disp));
                elem.addAttribute("cd", StringUtil.stripControlCharacters(cdisp.getDisposition()));
            }
        }
        catch (MessagingException me) {
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        try {
            MimeMessage content;
            String fname = Mime.getFilename(mp);
            if (fname == null && "message/rfc822".equals(ctype) && (content = Mime.getMessageContent(mp)) instanceof MimeMessage) {
                fname = Mime.getSubject(content);
            }
            if (fname != null && !fname.equals("")) {
                elem.addAttribute("filename", StringUtil.stripControlCharacters(fname));
            }
        }
        catch (MessagingException me) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            String cid = mp.getContentID();
            if (cid != null) {
                elem.addAttribute("ci", StringUtil.stripControlCharacters(cid));
            }
        }
        catch (MessagingException me) {
            // empty catch block
        }
        try {
            String cl = mp.getHeader("Content-Location", null);
            if (cl != null) {
                elem.addAttribute("cl", StringUtil.stripControlCharacters(cl));
            }
        }
        catch (MessagingException me) {
            // empty catch block
        }
        if (bodies == null || bodies.contains(mpi)) {
            if (bodies != null) {
                elem.addAttribute("body", true);
            }
            try {
                ToXML.addContent(elem, mpi, maxSize, neuter, defaultCharset);
            }
            catch (IOException ioe) {
                if (mLog.isWarnEnabled()) {
                    mLog.warn((Object)"error writing body part: ", ioe);
                }
            }
            catch (MessagingException me) {
                // empty catch block
            }
        }
        return elem;
    }

    private static void addContent(Element elt, MPartInfo mpi, int maxSize, String defaultCharset) throws IOException, MessagingException {
        ToXML.addContent(elt, mpi, maxSize, true, defaultCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addContent(Element elt, MPartInfo mpi, int maxSize, boolean neuter, String defaultCharset) throws IOException, MessagingException {
        String data;
        block18: {
            String ctype = mpi.getContentType();
            if (!ctype.matches("text/.*") && !ctype.matches("xml/.*")) {
                return;
            }
            MimePart mp = mpi.getMimePart();
            Mime.repairTransferEncoding(mp);
            data = null;
            try {
                maxSize = maxSize <= 0 ? (int)Provisioning.getInstance().getLocalServer().getMailContentMaxSize() : Math.min(maxSize, (int)Provisioning.getInstance().getLocalServer().getMailContentMaxSize());
            }
            catch (ServiceException e) {
                ZimbraLog.soap.warn((Object)"Unable to determine max content size", e);
            }
            if (ctype.equals("text/html")) {
                String charset = mpi.getContentTypeParameter("charset");
                InputStream stream = null;
                StringWriter sw = new StringWriter();
                TruncatingWriter tw = null;
                Writer out = sw;
                if (maxSize > 0) {
                    tw = new TruncatingWriter(sw, maxSize + 1);
                    out = tw;
                }
                Reader reader = null;
                try {
                    if (charset != null && !charset.trim().equals("")) {
                        stream = mp.getInputStream();
                        reader = Mime.getTextReader(stream, mp.getContentType(), defaultCharset);
                        HtmlDefang.defang(reader, neuter, out);
                        data = sw.toString();
                    } else {
                        String cte = mp.getEncoding();
                        if (cte != null && !cte.trim().toLowerCase().equals("7bit")) {
                            try {
                                stream = mp.getInputStream();
                                HtmlDefang.defang(stream, neuter, out);
                                data = sw.toString();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        if (data == null) {
                            reader = Mime.getContentAsReader(mp, defaultCharset);
                            HtmlDefang.defang(reader, neuter, out);
                            data = sw.toString();
                        }
                    }
                    Object var17_22 = null;
                }
                catch (Throwable throwable) {
                    Object var17_23 = null;
                    ByteUtil.closeStream(stream);
                    ByteUtil.closeReader(reader);
                    throw throwable;
                }
                ByteUtil.closeStream(stream);
                ByteUtil.closeReader(reader);
                {
                    break block18;
                }
            }
            if (ctype.equals("text/enriched")) {
                int maxChars;
                Reader reader = Mime.getContentAsReader(mp, defaultCharset);
                String enriched = ByteUtil.getContent(reader, maxChars = maxSize > 0 ? maxSize + 1 : -1, true);
                if (enriched.length() == maxChars) {
                    elt.addAttribute("truncated", true);
                }
                data = TextEnrichedHandler.convertToHTML(enriched);
            } else {
                Reader reader = Mime.getContentAsReader(mp, defaultCharset);
                int maxChars = maxSize > 0 ? maxSize + 1 : -1;
                data = ByteUtil.getContent(reader, maxChars, true);
            }
        }
        if (data != null) {
            data = StringUtil.stripControlCharacters(data);
            if (maxSize > 0 && data.length() > maxSize) {
                data = data.substring(0, maxSize);
                elt.addAttribute("truncated", true);
            }
            elt.addAttribute("content", data, Element.Disposition.CONTENT);
        }
    }

    private static void addEmails(Element m, InternetAddress[] recipients, EmailType emailType) {
        for (int i = 0; i < recipients.length; ++i) {
            ToXML.encodeEmail(m, recipients[i], emailType);
        }
    }

    public static Element encodeEmail(Element parent, InternetAddress ia, EmailType type) {
        return ToXML.encodeEmail(parent, new ParsedAddress(ia).parse(), type);
    }

    public static Element encodeEmail(Element parent, String addr, EmailType type) {
        return ToXML.encodeEmail(parent, new ParsedAddress(addr).parse(), type);
    }

    public static Element encodeEmail(Element parent, ParsedAddress pa, EmailType type) {
        Element elem = parent.addElement("e");
        elem.addAttribute("a", IDNUtil.toUnicode(pa.emailPart));
        elem.addAttribute("d", pa.firstName);
        elem.addAttribute("p", pa.personalPart);
        elem.addAttribute("t", type.toString());
        return elem;
    }

    public static Element encodeWiki(Element parent, ItemIdFormatter ifmt, OperationContext octxt, WikiItem wiki) {
        return ToXML.encodeWiki(parent, ifmt, octxt, wiki, -4194305);
    }

    public static Element encodeWiki(Element parent, ItemIdFormatter ifmt, OperationContext octxt, WikiItem wiki, int fields) {
        Element elem = parent.addElement("w");
        ToXML.encodeDocumentCommon(elem, ifmt, octxt, wiki, fields);
        return elem;
    }

    public static Element encodeDocument(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Document doc) {
        return ToXML.encodeDocument(parent, ifmt, octxt, doc, -1);
    }

    public static Element encodeDocument(Element parent, ItemIdFormatter ifmt, OperationContext octxt, Document doc, int fields) {
        Element elem = parent.addElement("doc");
        ToXML.encodeDocumentCommon(elem, ifmt, octxt, doc, fields);
        elem.addAttribute("ct", doc.getContentType());
        return elem;
    }

    public static Element encodeDocumentCommon(Element m, ItemIdFormatter ifmt, OperationContext octxt, Document doc, int fields) {
        m.addAttribute("id", ifmt.formatItemId(doc));
        if (ToXML.needToOutput(fields, 4096)) {
            m.addAttribute("name", doc.getName());
        }
        if (ToXML.needToOutput(fields, 16)) {
            m.addAttribute("s", doc.getSize());
        }
        if (ToXML.needToOutput(fields, 32)) {
            m.addAttribute("d", doc.getDate());
        }
        if (ToXML.needToOutput(fields, 256)) {
            m.addAttribute("l", new ItemId(doc.getMailbox().getAccountId(), doc.getFolderId()).toString(ifmt));
        }
        if (ToXML.needToOutput(fields, 0x400000)) {
            m.addAttribute("ms", doc.getModifiedSequence());
            m.addAttribute("md", doc.getChangeDate() / 1000L);
            m.addAttribute("rev", doc.getSavedSequence());
        }
        ToXML.recordItemTags(m, doc, fields);
        if (ToXML.needToOutput(fields, 524288)) {
            ToXML.encodeAllCustomMetadata(m, doc, fields);
        }
        if (ToXML.needToOutput(fields, 65536)) {
            try {
                Document revision;
                m.addAttribute("ver", doc.getVersion());
                m.addAttribute("leb", doc.getCreator());
                m.addAttribute("md", doc.getDate());
                String fragment = doc.getFragment();
                if (fragment != null && !fragment.equals("")) {
                    m.addAttribute("fr", fragment, Element.Disposition.CONTENT);
                }
                if ((revision = (Document)doc.getMailbox().getItemRevision(octxt, doc.getId(), doc.getType(), 1)) != null) {
                    m.addAttribute("cr", revision.getCreator());
                    m.addAttribute("cd", revision.getDate());
                }
            }
            catch (Exception ex) {
                mLog.warn((Object)("ignoring exception while fetching revision for document " + doc.getSubject()), ex);
            }
        }
        return m;
    }

    public static Element encodeDataSource(Element parent, DataSource ds) {
        String lastError;
        Element m = parent.addElement(ToXML.getDsType(ds));
        m.addAttribute("id", ds.getId());
        m.addAttribute("name", ds.getName());
        m.addAttribute("l", ds.getFolderId());
        m.addAttribute("isEnabled", ds.isEnabled());
        if (ds.getType() == DataSource.Type.pop3) {
            m.addAttribute("leaveOnServer", ds.leaveOnServer());
        }
        if (ds.getHost() != null) {
            m.addAttribute("host", ds.getHost());
        }
        if (ds.getPort() != null) {
            m.addAttribute("port", ds.getPort().intValue());
        }
        if (ds.getConnectionType() != null) {
            m.addAttribute("connectionType", ds.getConnectionType().name());
        }
        if (ds.getUsername() != null) {
            m.addAttribute("username", ds.getUsername());
        }
        try {
            if (ds.getPollingInterval() > 0L) {
                m.addAttribute("pollingInterval", ds.getAttr("zimbraDataSourcePollingInterval"));
            }
        }
        catch (ServiceException e) {
            mLog.warn("Unable to get polling interval from %s", (Object)ds, e);
        }
        m.addAttribute("emailAddress", ds.getEmailAddress());
        m.addAttribute("useAddressForForwardReply", ds.useAddressForForwardReply());
        m.addAttribute("defaultSignature", ds.getDefaultSignature());
        m.addAttribute("fromDisplay", ds.getFromDisplay());
        m.addAttribute("fromAddress", ds.getFromAddress());
        m.addAttribute("replyToAddress", ds.getReplyToAddress());
        m.addAttribute("replyToDisplay", ds.getReplyToDisplay());
        Date date = ds.getGeneralizedTimeAttr("zimbraDataSourceFailingSince", null);
        if (date != null) {
            m.addAttribute("failingSince", date.getTime() / 1000L);
        }
        if ((lastError = ds.getAttr("zimbraDataSourceLastError")) != null) {
            m.addElement("lastError").setText(lastError);
        }
        return m;
    }

    private static String getDsType(DataSource ds) {
        switch (ds.getType()) {
            case imap: {
                return "imap";
            }
            case pop3: {
                return "pop3";
            }
            case caldav: {
                return "caldav";
            }
            case yab: {
                return "yab";
            }
            case rss: {
                return "rss";
            }
            case gal: {
                return "gal";
            }
            case cal: {
                return "cal";
            }
        }
        return "unknown";
    }

    private static void setCalendarItemType(Element elem, byte itemType) {
        elem.addAttribute("type", itemType == 11 ? "appt" : "task");
    }

    public static void encodeAlarmTimes(Element elem, CalendarItem calItem) {
        long nextAlarm;
        CalendarItem.AlarmData alarmData = calItem.getAlarmData();
        if (alarmData != null && (nextAlarm = alarmData.getNextAt()) < Long.MAX_VALUE) {
            elem.addAttribute("nextAlarm", nextAlarm);
        }
    }

    public static Element encodeAlarmData(Element parent, CalendarItem calItem, CalendarItem.AlarmData alarmData) {
        Alarm alarmObj;
        Element alarmElem = parent.addElement("alarmData");
        ToXML.encodeAlarmTimes(alarmElem, calItem);
        long alarmInstStart = alarmData.getNextInstanceStart();
        alarmElem.addAttribute("alarmInstStart", alarmInstStart);
        int alarmInvId = alarmData.getInvId();
        int alarmCompNum = alarmData.getCompNum();
        Invite alarmInv = calItem.getInvite(alarmInvId, alarmCompNum);
        if (alarmInv != null) {
            alarmElem.addAttribute("name", alarmInv.getName());
            alarmElem.addAttribute("loc", alarmInv.getLocation());
            alarmElem.addAttribute("invId", alarmInvId);
            alarmElem.addAttribute("compNum", alarmCompNum);
        }
        if ((alarmObj = alarmData.getAlarm()) != null) {
            alarmObj.toXml(alarmElem);
        }
        return alarmElem;
    }

    public static Element encodeFreeBusy(Element parent, FreeBusy fb) {
        Element resp = parent.addElement("usr");
        resp.addAttribute("id", fb.getName());
        for (FreeBusy.Interval cur : fb) {
            Element elt;
            String status = cur.getStatus();
            if (status.equals("F")) {
                elt = resp.addElement("f");
            } else if (status.equals("B")) {
                elt = resp.addElement("b");
            } else if (status.equals("T")) {
                elt = resp.addElement("t");
            } else if (status.equals("O")) {
                elt = resp.addElement("u");
            } else {
                assert (false);
                elt = null;
            }
            if (elt == null) continue;
            elt.addAttribute("s", cur.getStart());
            elt.addAttribute("e", cur.getEnd());
        }
        return resp;
    }

    private static Element encodeRecurId(Element parent, RecurId recurId, boolean allDay) {
        int rangeType;
        ParsedDateTime ridDt = recurId.getDt();
        Element ridElem = parent.addElement("exceptId");
        ridElem.addAttribute("d", ridDt.getDateTimePartString(false));
        if (!allDay) {
            ridElem.addAttribute("tz", ridDt.getTZName());
        }
        if ((rangeType = recurId.getRange()) != RecurId.RANGE_NONE) {
            ridElem.addAttribute("rangeType", rangeType);
        }
        return ridElem;
    }

    private static Element encodeDtStart(Element parent, ParsedDateTime dtStart, boolean allDay, boolean forceUtc) {
        String tzName;
        if (forceUtc) {
            dtStart = (ParsedDateTime)dtStart.clone();
            dtStart.toUTC();
        }
        if (allDay && dtStart.hasTime()) {
            dtStart = (ParsedDateTime)dtStart.clone();
            dtStart.setHasTime(false);
        } else if (!allDay && !dtStart.hasTime()) {
            allDay = true;
        }
        Element dtStartElem = parent.addElement("s");
        dtStartElem.addAttribute("d", dtStart.getDateTimePartString(false));
        if (!allDay && (tzName = dtStart.getTZName()) != null) {
            dtStartElem.addAttribute("tz", tzName);
        }
        return dtStartElem;
    }

    private static Element encodeDtEnd(Element parent, ParsedDateTime dtEnd, boolean allDay, boolean isTodo, boolean forceUtc) {
        if (forceUtc) {
            dtEnd = (ParsedDateTime)dtEnd.clone();
            dtEnd.toUTC();
        }
        if (allDay && dtEnd.hasTime()) {
            dtEnd = (ParsedDateTime)dtEnd.clone();
            dtEnd.setHasTime(false);
        } else if (!allDay && !dtEnd.hasTime()) {
            allDay = true;
        }
        Element dtEndElem = parent.addElement("e");
        if (!allDay) {
            String tzName = dtEnd.getTZName();
            if (tzName != null) {
                dtEndElem.addAttribute("tz", tzName);
            }
        } else if (!isTodo) {
            dtEnd = dtEnd.add(ParsedDuration.NEGATIVE_ONE_DAY);
        }
        dtEndElem.addAttribute("d", dtEnd.getDateTimePartString(false));
        return dtEndElem;
    }

    public static void encodeCalendarItemRecur(Element parent, ItemIdFormatter ifmt, OperationContext octxt, CalendarItem calItem) {
        Invite[] invites;
        TimeZoneMap tzmap = calItem.getTimeZoneMap();
        ToXML.encodeTimeZoneMap(parent, tzmap);
        for (Invite inv : invites = calItem.getInvites()) {
            ParsedDateTime dtEnd;
            String elemName = inv.isCancel() ? "cancel" : (inv.hasRecurId() ? "except" : "comp");
            Element compElem = parent.addElement(elemName);
            boolean allDay = inv.isAllDayEvent();
            if (inv.hasRecurId()) {
                ToXML.encodeRecurId(compElem, inv.getRecurId(), allDay);
            }
            if (inv.isCancel()) continue;
            ParsedDateTime dtStart = inv.getStartTime();
            if (dtStart != null) {
                ToXML.encodeDtStart(compElem, dtStart, allDay, false);
            }
            if ((dtEnd = inv.getEndTime()) != null) {
                ToXML.encodeDtEnd(compElem, dtEnd, allDay, inv.isTodo(), false);
            } else {
                ParsedDuration dur = inv.getDuration();
                if (dur != null) {
                    dur.toXml(compElem);
                }
            }
            Recurrence.IRecurrence recurrence = inv.getRecurrence();
            if (recurrence == null) continue;
            Element recurElem = compElem.addElement("recur");
            recurrence.toXml(recurElem);
        }
    }

    public static void encodeGalContact(Element response, GalContact contact) {
        Element cn = response.addElement("cn");
        cn.addAttribute("id", contact.getId());
        Map<String, Object> attrs = contact.getAttrs();
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] sa = (String[])value;
                for (int i = 0; i < sa.length; ++i) {
                    cn.addKeyValuePair(entry.getKey(), sa[i], "a", "n");
                }
                continue;
            }
            cn.addKeyValuePair(entry.getKey(), (String)value, "a", "n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmailType {
        NONE(null),
        FROM("f"),
        TO("t"),
        CC("c"),
        BCC("b"),
        REPLY_TO("r"),
        SENDER("s"),
        READ_RECEIPT("n");

        private final String mRep;

        private EmailType(String c) {
            this.mRep = c;
        }

        public String toString() {
            return this.mRep;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VisitPhase {
        PREVISIT,
        POSTVISIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputParticipants {
        PUT_SENDERS,
        PUT_RECIPIENTS,
        PUT_BOTH;

    }
}

