/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.SystemUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.service.mail.CreateDataSource;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ModifyDataSource;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataSource
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        String error;
        Element response;
        Element eDataSource;
        block17: {
            String value;
            ZimbraSoapContext zsc = TestDataSource.getZimbraSoapContext(context);
            Provisioning prov = Provisioning.getInstance();
            Account account = TestDataSource.getRequestedAccount(zsc);
            if (!this.canModifyOptions(zsc, account)) {
                throw ServiceException.PERM_DENIED("can not modify options");
            }
            HashMap<String, Object> testAttrs = new HashMap<String, Object>();
            String testId = "TestId";
            eDataSource = CreateDataSource.getDataSourceElement(request);
            DataSource.Type type = DataSource.Type.fromString(eDataSource.getName());
            String id = eDataSource.getAttribute("id", null);
            String password = null;
            if (id != null) {
                DataSource dsOrig = prov.get(account, Provisioning.DataSourceBy.id, id);
                Map<String, Object> origAttrs = dsOrig.getAttrs();
                for (String key : origAttrs.keySet()) {
                    if (key.equals("zimbraDataSourcePassword")) {
                        password = dsOrig.getDecryptedPassword();
                        continue;
                    }
                    testAttrs.put(key, dsOrig.getAttr(key));
                }
            }
            if ((value = eDataSource.getAttribute("host", null)) != null) {
                testAttrs.put("zimbraDataSourceHost", value);
            }
            if ((value = eDataSource.getAttribute("port", null)) != null) {
                testAttrs.put("zimbraDataSourcePort", value);
            }
            if ((value = eDataSource.getAttribute("connectionType", null)) != null) {
                testAttrs.put("zimbraDataSourceConnectionType", value);
            }
            if ((value = eDataSource.getAttribute("username", null)) != null) {
                testAttrs.put("zimbraDataSourceUsername", value);
            }
            if ((value = eDataSource.getAttribute("password", null)) != null) {
                password = value;
            }
            if ((value = eDataSource.getAttribute("leaveOnServer", null)) != null) {
                testAttrs.put("zimbraDataSourceLeaveOnServer", value.toUpperCase());
            }
            if ((value = eDataSource.getAttribute("l", null)) != null) {
                testAttrs.put("zimbraDataSourceFolderId", value);
            }
            if (password != null) {
                testAttrs.put("zimbraDataSourcePassword", DataSource.encryptData(testId, password));
            }
            if ((value = eDataSource.getAttribute("importClass", DataSourceManager.getDefaultImportClass(type))) != null) {
                testAttrs.put("zimbraDataSourceImportClassName", value);
            }
            ModifyDataSource.processCommonOptionalAttrs(testAttrs, eDataSource);
            DataSource ds = new DataSource(account, type, "Test", testId, testAttrs, null);
            response = zsc.createElement(MailConstants.TEST_DATA_SOURCE_RESPONSE);
            eDataSource = response.addElement(type.toString());
            error = null;
            try {
                DataSourceManager.test(ds);
            }
            catch (ServiceException x) {
                Throwable t = SystemUtil.getInnermostException(x);
                error = t.getMessage();
                if (error != null) break block17;
                error = "datasource test failed";
            }
        }
        if (error == null) {
            eDataSource.addAttribute("success", true);
        } else {
            eDataSource.addAttribute("success", false);
            eDataSource.addAttribute("error", error);
        }
        return response;
    }
}

