/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagAction
extends ItemAction {
    public static final String OP_UNFLAG = "!flag";
    public static final String OP_UNTAG = "!tag";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext lc = TagAction.getZimbraSoapContext(context);
        Element action = request.getElement("action");
        String operation = action.getAttribute("op").toLowerCase();
        if (operation.equals("tag") || operation.equals("flag") || operation.equals(OP_UNTAG) || operation.equals(OP_UNFLAG)) {
            throw ServiceException.INVALID_REQUEST("cannot tag/flag a tag", null);
        }
        if (operation.endsWith("move") || operation.endsWith("copy") || operation.endsWith("spam") || operation.endsWith("trash")) {
            throw ServiceException.INVALID_REQUEST("invalid operation on tag: " + operation, null);
        }
        String successes = this.handleCommon(context, request, operation, (byte)3);
        Element response = lc.createElement(MailConstants.TAG_ACTION_RESPONSE);
        Element result = response.addUniqueElement("action");
        result.addAttribute("id", successes);
        result.addAttribute("op", operation);
        return response;
    }
}

