/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.OperationContextData;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.util.TypedIdList;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sync
extends MailDocumentHandler {
    protected static final String[] TARGET_FOLDER_PATH = new String[]{"l"};
    private static final int DEFAULT_FOLDER_ID = 11;
    private static final int CALENDAR_TYPES_BITMASK = MailItem.typeToBitmask((byte)11) | MailItem.typeToBitmask((byte)15);
    private static final int FETCH_BATCH_SIZE = 200;
    private static final int MAXIMUM_CHANGE_COUNT = 3990;
    private static final int MUTABLE_FIELDS = 4223782;
    private static final int FOLDER_TYPES_BITMASK = MailItem.typeToBitmask((byte)1) | MailItem.typeToBitmask((byte)2) | MailItem.typeToBitmask((byte)13);

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int itemCutoff;
        int tokenInt;
        ZimbraSoapContext zsc = Sync.getZimbraSoapContext(context);
        Mailbox mbox = Sync.getRequestedMailbox(zsc);
        OperationContext octxt = Sync.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        String token = request.getAttribute("token", "0");
        Element response = zsc.createElement(MailConstants.SYNC_RESPONSE);
        response.addAttribute("md", System.currentTimeMillis() / 1000L);
        try {
            int delimiter = token.indexOf(45);
            if (delimiter < 1) {
                tokenInt = Integer.parseInt(token);
                itemCutoff = -1;
            } else {
                tokenInt = Integer.parseInt(token.substring(0, delimiter));
                itemCutoff = Integer.parseInt(token.substring(delimiter + 1));
            }
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("malformed sync token: " + token, nfe);
        }
        boolean initialSync = tokenInt <= 0;
        long calendarStart = request.getAttributeLong("calCutoff", -1L);
        Folder root = null;
        ItemId iidFolder = null;
        try {
            iidFolder = new ItemId(request.getAttribute("l", "11"), zsc);
            OperationContext octxtOwner = new OperationContext(mbox);
            root = mbox.getFolderById(octxtOwner, iidFolder.getId());
        }
        catch (MailServiceException.NoSuchItemException nsie) {
            // empty catch block
        }
        Set<Folder> visible = octxt.isDelegatedRequest(mbox) ? mbox.getVisibleFolders(octxt) : null;
        Mailbox.FolderNode rootNode = null;
        rootNode = root == null || iidFolder == null ? mbox.getFolderTree(octxt, null, true) : mbox.getFolderTree(octxt, iidFolder, true);
        OperationContextData.addGranteeNames(octxt, rootNode);
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            mbox.beginTrackingSync();
            if (initialSync) {
                response.addAttribute("token", mbox.getLastChangeID());
                response.addAttribute("s", mbox.getSize());
                boolean anyFolders = Sync.folderSync(response, octxt, ifmt, mbox, root, visible, calendarStart, SyncPhase.INITIAL);
                if (!anyFolders) {
                    response.addElement("folder");
                }
            } else {
                boolean typedDeletes = request.getAttributeBool("typed", false);
                String newToken = Sync.deltaSync(response, octxt, ifmt, mbox, tokenInt, itemCutoff, typedDeletes, root, visible);
                response.addAttribute("token", newToken);
            }
        }
        return response;
    }

    private static boolean folderSync(Element response, OperationContext octxt, ItemIdFormatter ifmt, Mailbox mbox, Folder folder, Set<Folder> visible, long calendarStart, SyncPhase phase) throws ServiceException {
        if (folder == null) {
            return false;
        }
        if (visible != null && visible.isEmpty()) {
            return false;
        }
        boolean isVisible = visible == null || visible.remove(folder);
        List<Folder> subfolders = folder.getSubfolders(null);
        if (!isVisible && subfolders.isEmpty()) {
            return false;
        }
        boolean initial = phase == SyncPhase.INITIAL;
        Element f = ToXML.encodeFolder(response, ifmt, octxt, folder, -1);
        if (initial && isVisible && folder.getType() == 1) {
            if (folder.getId() == 8) {
                Sync.initialTagSync(f, octxt, ifmt, mbox);
            } else {
                TypedIdList idlist = mbox.getItemIds(octxt, folder.getId());
                Sync.initialItemSync(f, "m", idlist.getIds((byte)5));
                Sync.initialItemSync(f, "chat", idlist.getIds((byte)16));
                Sync.initialItemSync(f, "cn", idlist.getIds((byte)6));
                Sync.initialItemSync(f, "note", idlist.getIds((byte)9));
                Sync.initialCalendarSync(f, idlist, octxt, mbox, folder, calendarStart);
                Sync.initialItemSync(f, "doc", idlist.getIds((byte)8));
                Sync.initialItemSync(f, "w", idlist.getIds((byte)14));
            }
        }
        if (isVisible && visible != null && visible.isEmpty()) {
            return true;
        }
        for (Folder subfolder : subfolders) {
            if (subfolder == null) continue;
            isVisible |= Sync.folderSync(f, octxt, ifmt, mbox, subfolder, visible, calendarStart, phase);
        }
        if (!isVisible) {
            f.detach();
        }
        return isVisible;
    }

    private static void initialTagSync(Element f, OperationContext octxt, ItemIdFormatter ifmt, Mailbox mbox) throws ServiceException {
        for (Tag tag : mbox.getTagList(octxt)) {
            if (tag == null || tag instanceof Flag) continue;
            ToXML.encodeTag(f, ifmt, tag, -1);
        }
    }

    private static void initialCalendarSync(Element f, TypedIdList idlist, OperationContext octxt, Mailbox mbox, Folder folder, long calendarStart) throws ServiceException {
        if (calendarStart > 0L && (idlist.getTypesMask() & CALENDAR_TYPES_BITMASK) != 0) {
            idlist = mbox.listCalendarItemsForRange(octxt, (byte)-1, calendarStart, -1L, folder.getId());
        }
        Sync.initialItemSync(f, "appt", idlist.getIds((byte)11));
        Sync.initialItemSync(f, "task", idlist.getIds((byte)15));
    }

    private static void initialItemSync(Element f, String ename, List<Integer> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        f.addElement(ename).addAttribute("ids", StringUtil.join(",", items));
    }

    private static String deltaSync(Element response, OperationContext octxt, ItemIdFormatter ifmt, Mailbox mbox, int begin, int itemCutoff, boolean typedDeletes, Folder root, Set<Folder> visible) throws ServiceException {
        HashSet<Integer> targetIds;
        List<Folder> hierarchy;
        String newToken = mbox.getLastChangeID() + "";
        if (begin >= mbox.getLastChangeID()) {
            return newToken;
        }
        TypedIdList tombstones = mbox.getTombstones(begin);
        Element eDeleted = response.addElement("deleted");
        List<Folder> list = hierarchy = root == null || root.getId() == 1 ? null : root.getSubfolderHierarchy();
        HashSet<Integer> hashSet = root != null && root.getId() == 1 ? null : (targetIds = new HashSet<Integer>(hierarchy == null ? 0 : hierarchy.size()));
        if (hierarchy != null) {
            for (Folder folder : hierarchy) {
                targetIds.add(folder.getId());
            }
        }
        if (octxt.isDelegatedRequest(mbox)) {
            boolean anyFolders;
            if ((!mbox.getModifiedFolders(begin).isEmpty() || tombstones != null && (tombstones.getTypesMask() & FOLDER_TYPES_BITMASK) != 0) && !(anyFolders = Sync.folderSync(response, octxt, ifmt, mbox, root, visible, -1L, SyncPhase.DELTA))) {
                response.addElement("folder");
            }
        } else {
            for (Folder folder : mbox.getModifiedFolders(begin)) {
                if (targetIds == null || targetIds.contains(folder.getId())) {
                    ToXML.encodeFolder(response, ifmt, octxt, folder, -1);
                    continue;
                }
                tombstones.add(folder.getType(), folder.getId());
            }
        }
        for (Tag tag : mbox.getModifiedTags(octxt, begin)) {
            ToXML.encodeTag(response, ifmt, tag, -1);
        }
        int itemCount = 0;
        Pair<List<Integer>, TypedIdList> changed = mbox.getModifiedItems(octxt, begin, (byte)-1, targetIds);
        List<Integer> modified = changed.getFirst();
        block3: while (!modified.isEmpty()) {
            List<Integer> batch = modified.subList(0, Math.min(modified.size(), 200));
            for (MailItem item : mbox.getItemById(octxt, batch, (byte)-1)) {
                if (item.getModifiedSequence() == begin + 1 && item.getId() < itemCutoff) continue;
                if (itemCount >= 3990) {
                    response.addAttribute("more", true);
                    newToken = item.getModifiedSequence() - 1 + "-" + item.getId();
                    break block3;
                }
                boolean created = item.getSavedSequence() > begin;
                ToXML.encodeItem(response, ifmt, octxt, item, created ? 0x400100 : 4223782);
                ++itemCount;
            }
            batch.clear();
        }
        if (changed.getSecond() != null) {
            tombstones.add(changed.getSecond());
        }
        if (tombstones == null || tombstones.isEmpty()) {
            eDeleted.detach();
        } else {
            StringBuilder deleted = new StringBuilder();
            StringBuilder typed = new StringBuilder();
            for (Map.Entry<Byte, List<Integer>> entry : tombstones) {
                String eltName;
                typed.setLength(0);
                for (Integer id : entry.getValue()) {
                    deleted.append(deleted.length() == 0 ? "" : ",").append(id);
                    if (!typedDeletes) continue;
                    typed.append(typed.length() == 0 ? "" : ",").append(id);
                }
                if (!typedDeletes || (eltName = Sync.elementNameForType(entry.getKey())) == null) continue;
                eDeleted.addElement(eltName).addAttribute("ids", typed.toString());
            }
            eDeleted.addAttribute("ids", deleted.toString());
        }
        return newToken;
    }

    public static String elementNameForType(byte type) {
        switch (type) {
            case 1: {
                return "folder";
            }
            case 2: {
                return "search";
            }
            case 13: {
                return "link";
            }
            case 3: 
            case 10: {
                return "tag";
            }
            case 4: 
            case 12: {
                return "c";
            }
            case 16: {
                return "chat";
            }
            case 5: {
                return "m";
            }
            case 6: {
                return "cn";
            }
            case 11: {
                return "appt";
            }
            case 15: {
                return "task";
            }
            case 9: {
                return "note";
            }
            case 14: {
                return "w";
            }
            case 8: {
                return "doc";
            }
        }
        return null;
    }

    public static byte typeForElementName(String name) {
        if (name.equals("folder")) {
            return 1;
        }
        if (name.equals("search")) {
            return 2;
        }
        if (name.equals("link")) {
            return 13;
        }
        if (name.equals("tag")) {
            return 3;
        }
        if (name.equals("c")) {
            return 4;
        }
        if (name.equals("m")) {
            return 5;
        }
        if (name.equals("chat")) {
            return 16;
        }
        if (name.equals("cn")) {
            return 6;
        }
        if (name.equals("appt")) {
            return 11;
        }
        if (name.equals("task")) {
            return 15;
        }
        if (name.equals("note")) {
            return 9;
        }
        if (name.equals("w")) {
            return 14;
        }
        if (name.equals("doc")) {
            return 8;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SyncPhase {
        INITIAL,
        DELTA;

    }
}

