/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetMailboxMetadata
extends MailDocumentHandler {
    private static final int TOTAL_METADATA_LIMIT = 10000;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SetMailboxMetadata.getZimbraSoapContext(context);
        Mailbox mbox = SetMailboxMetadata.getRequestedMailbox(zsc);
        OperationContext octxt = SetMailboxMetadata.getOperationContext(zsc, context);
        Element meta = request.getElement("meta");
        String section = meta.getAttribute("section");
        if ((section = section.trim()).length() == 0 || section.length() > 36 || section.indexOf(58) < 1) {
            throw ServiceException.INVALID_REQUEST("invalid mailbox metadata section name", null);
        }
        SectionNames.valueOf(section.substring(0, section.indexOf(58)));
        Metadata metadata = null;
        int roughSize = 0;
        List<Element.KeyValuePair> keyvals = meta.listKeyValuePairs();
        if (!keyvals.isEmpty()) {
            metadata = new Metadata();
            for (Element.KeyValuePair kvp : keyvals) {
                if ((roughSize += kvp.getKey().length() + kvp.getValue().length()) > 10000) {
                    throw MailServiceException.TOO_MUCH_METADATA(10000);
                }
                metadata.put(kvp.getKey(), kvp.getValue());
            }
        }
        mbox.setConfig(octxt, section, metadata);
        Element response = zsc.createElement(MailConstants.SET_MAILBOX_METADATA_RESPONSE);
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SectionNames {
        zwc;

    }
}

