/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCustomMetadata
extends MailDocumentHandler {
    private static final String[] TARGET_ITEM_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_ITEM_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SetCustomMetadata.getZimbraSoapContext(context);
        Mailbox mbox = SetCustomMetadata.getRequestedMailbox(zsc);
        OperationContext octxt = SetCustomMetadata.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element meta = request.getElement("meta");
        String section = meta.getAttribute("section");
        if ((section = section.trim()).length() == 0 || section.length() > 36) {
            throw ServiceException.INVALID_REQUEST("invalid length for custom metadata section name", null);
        }
        MailItem.CustomMetadata custom = new MailItem.CustomMetadata(section);
        for (Element.KeyValuePair kvp : meta.listKeyValuePairs()) {
            custom.put(kvp.getKey(), kvp.getValue());
        }
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        mbox.setCustomData(octxt, iid.getId(), (byte)-1, custom);
        Element response = zsc.createElement(MailConstants.SET_METADATA_RESPONSE);
        response.addAttribute("id", ifmt.formatItemId(iid));
        return response;
    }
}

