/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.mail.SendMsg;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCalendarItem
extends CalendarRequest {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"l"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SetCalendarItem.getZimbraSoapContext(context);
        Mailbox mbox = SetCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = SetCalendarItem.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        String flagsStr = request.getAttribute("f", null);
        int flags = flagsStr != null ? Flag.flagsToBitmask(flagsStr) : 0;
        String tagsStr = request.getAttribute("t", null);
        long tags = tagsStr != null ? Tag.tagsToBitmask(tagsStr) : 0L;
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            int defaultFolder = this.getItemType() == 15 ? 15 : 10;
            String defaultFolderStr = Integer.toString(defaultFolder);
            String folderIdStr = request.getAttribute("l", defaultFolderStr);
            ItemId iidFolder = new ItemId(folderIdStr, zsc);
            Folder folder = mbox.getFolderById(octxt, iidFolder.getId());
            SetCalendarItemParseResult parsed = SetCalendarItem.parseSetAppointmentRequest(request, zsc, octxt, folder, this.getItemType(), false);
            CalendarItem calItem = mbox.setCalendarItem(octxt, iidFolder.getId(), flags, tags, parsed.defaultInv, parsed.exceptions, parsed.replies, parsed.nextAlarm);
            Element response = this.getResponseElement(zsc);
            if (parsed.defaultInv != null) {
                response.addElement("default").addAttribute("id", ifmt.formatItemId(parsed.defaultInv.mInv.getMailItemId()));
            }
            if (parsed.exceptions != null) {
                for (Mailbox.SetCalendarItemData cur : parsed.exceptions) {
                    Element e = response.addElement("except");
                    e.addAttribute("recurId", cur.mInv.getRecurId().toString());
                    e.addAttribute("id", ifmt.formatItemId(cur.mInv.getMailItemId()));
                }
            }
            String itemId = ifmt.formatItemId(calItem == null ? 0 : calItem.getId());
            response.addAttribute("calItemId", itemId);
            if (!parsed.isTodo) {
                response.addAttribute("apptId", itemId);
            }
            return response;
        }
    }

    static Mailbox.SetCalendarItemData getSetCalendarItemData(ZimbraSoapContext zsc, OperationContext octxt, Account acct, Mailbox mbox, Element e, ParseMimeMessage.InviteParser parser) throws ServiceException {
        Invite inv;
        String partStatStr = e.getAttribute("ptst", "NE");
        Element msgElem = e.getElement("m");
        String attachmentId = msgElem.getAttribute("aid", null);
        Element contentElement = msgElem.getOptionalElement("content");
        ParseMimeMessage.InviteParserResult ipr = null;
        MimeMessage mm = null;
        if (attachmentId != null) {
            ParseMimeMessage.MimeMessageData mimeData = new ParseMimeMessage.MimeMessageData();
            mm = SendMsg.parseUploadedMessage(zsc, attachmentId, mimeData);
        } else if (contentElement != null) {
            mm = ParseMimeMessage.importMsgSoap(msgElem);
        } else {
            CalendarRequest.CalSendData dat = SetCalendarItem.handleMsgElement(zsc, octxt, msgElem, acct, mbox, parser);
            mm = dat.mMm;
            ipr = parser.getResult();
        }
        if (ipr == null && msgElem.getOptionalElement("inv") != null && (ipr = parser.parse(zsc, octxt, mbox.getAccount(), msgElem.getElement("inv"))) != null && ipr.mInvite != null && mm != null) {
            String desc = Invite.getDescription((Part)mm, "text/plain");
            String descHtml = Invite.getDescription((Part)mm, "text/html");
            if (desc != null && desc.length() > 0 || descHtml != null && descHtml.length() > 0) {
                ipr.mInvite.setDescription(desc, descHtml);
            }
        }
        ParsedMessage pm = new ParsedMessage(mm, mbox.attachmentsIndexingEnabled());
        Invite invite = inv = ipr == null ? null : ipr.mInvite;
        if (inv == null || inv.getDTStamp() == -1L) {
            ParsedMessage.CalendarPartInfo cpi = pm.getCalendarPartInfo();
            ZCalendar.ZVCalendar cal = null;
            if (cpi != null && CalendarItem.isAcceptableInvite(mbox.getAccount(), cpi)) {
                cal = cpi.cal;
            }
            if (cal == null) {
                throw ServiceException.FAILURE("SetCalendarItem could not build an iCalendar object", null);
            }
            boolean sentByMe = false;
            Invite iCalInv = Invite.createFromCalendar(acct, pm.getFragment(), cal, sentByMe).get(0);
            if (inv == null) {
                inv = iCalInv;
            } else {
                inv.setDtStamp(iCalInv.getDTStamp());
                inv.setFragment(iCalInv.getFragment());
            }
        }
        inv.setPartStat(partStatStr);
        Mailbox.SetCalendarItemData sadata = new Mailbox.SetCalendarItemData();
        sadata.mInv = inv;
        sadata.mPm = pm;
        return sadata;
    }

    public static SetCalendarItemParseResult parseSetAppointmentRequest(Element request, ZimbraSoapContext zsc, OperationContext octxt, Folder folder, byte itemType, boolean parseIds) throws ServiceException {
        Mailbox.SetCalendarItemData exDat;
        Account acct = SetCalendarItem.getRequestedAccount(zsc);
        Mailbox mbox = SetCalendarItem.getRequestedMailbox(zsc);
        SetCalendarItemParseResult result = new SetCalendarItemParseResult();
        ArrayList<Mailbox.SetCalendarItemData> exceptions = new ArrayList<Mailbox.SetCalendarItemData>();
        Invite defInv = null;
        Element e = request.getOptionalElement("default");
        if (e != null) {
            result.defaultInv = SetCalendarItem.getSetCalendarItemData(zsc, octxt, acct, mbox, e, new SetCalendarItemInviteParser(false, false, folder, itemType));
            if (defInv == null) {
                defInv = result.defaultInv.mInv;
            }
        }
        for (Element e2 : request.listElements("except")) {
            exDat = SetCalendarItem.getSetCalendarItemData(zsc, octxt, acct, mbox, e2, new SetCalendarItemInviteParser(true, false, folder, itemType));
            exceptions.add(exDat);
            if (defInv != null) continue;
            defInv = exDat.mInv;
        }
        for (Element e2 : request.listElements("cancel")) {
            exDat = SetCalendarItem.getSetCalendarItemData(zsc, octxt, acct, mbox, e2, new SetCalendarItemInviteParser(true, true, folder, itemType));
            exceptions.add(exDat);
            if (defInv != null) continue;
            defInv = exDat.mInv;
        }
        if (exceptions.size() > 0) {
            result.exceptions = new Mailbox.SetCalendarItemData[exceptions.size()];
            exceptions.toArray(result.exceptions);
        } else if (result.defaultInv == null) {
            throw ServiceException.INVALID_REQUEST("No default/except/cancel specified", null);
        }
        Element repliesElem = request.getOptionalElement("replies");
        if (repliesElem != null) {
            result.replies = CalendarUtils.parseReplyList(repliesElem, defInv.getTimeZoneMap());
        }
        result.isTodo = defInv != null && defInv.isTodo();
        boolean noNextAlarm = request.getAttributeBool("noNextAlarm", false);
        result.nextAlarm = noNextAlarm ? -1L : request.getAttributeLong("nextAlarm", 0L);
        return result;
    }

    public static class SetCalendarItemParseResult {
        public Mailbox.SetCalendarItemData defaultInv;
        public Mailbox.SetCalendarItemData[] exceptions;
        public List<CalendarItem.ReplyInfo> replies;
        public boolean isTodo;
        public long nextAlarm;
    }

    static class SetCalendarItemInviteParser
    extends ParseMimeMessage.InviteParser {
        private boolean mExceptOk = false;
        private boolean mForCancel = false;
        private Folder mFolder;
        private byte mItemType;

        SetCalendarItemInviteParser(boolean exceptOk, boolean forCancel, Folder folder, byte itemType) {
            this.mExceptOk = exceptOk;
            this.mForCancel = forCancel;
            this.mFolder = folder;
            this.mItemType = itemType;
        }

        public ParseMimeMessage.InviteParserResult parseInviteElement(ZimbraSoapContext zc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            Element content = inviteElem.getOptionalElement("content");
            if (content != null) {
                ParseMimeMessage.InviteParserResult toRet = CalendarUtils.parseInviteRaw(account, inviteElem);
                return toRet;
            }
            if (this.mForCancel) {
                return CalendarUtils.parseInviteForCancel(account, this.mFolder, this.mItemType, inviteElem, null, this.mExceptOk, true);
            }
            return CalendarUtils.parseInviteForCreate(account, this.mItemType, inviteElem, null, null, this.mExceptOk, true);
        }
    }
}

