/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.sun.mail.smtp.SMTPMessage;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfo;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.mail.FolderAction;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendShareNotification
extends MailDocumentHandler {
    private static final Log sLog = LogFactory.getLog(SendShareNotification.class);

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SendShareNotification.getZimbraSoapContext(context);
        OperationContext octxt = SendShareNotification.getOperationContext(zsc, context);
        Account authAccount = SendShareNotification.getAuthenticatedAccount(zsc);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(authAccount, false);
        ShareInfoData sid = this.validateRequest(zsc, context, octxt, authAccount, mbox, request);
        Element eNotes = request.getOptionalElement("notes");
        String notes = eNotes == null ? null : eNotes.getText();
        this.sendShareNotif(octxt, authAccount, mbox, sid, notes);
        Element response = zsc.createElement(MailConstants.SEND_SHARE_NOTIFICATION_RESPONSE);
        return response;
    }

    private ShareInfoData validateRequest(ZimbraSoapContext zsc, Map<String, Object> context, OperationContext octxt, Account authAccount, Mailbox mbox, Element req) throws ServiceException {
        MatchingGrant matchingGrant;
        String granteeDisplayName;
        String granteeEmail;
        String matchingId;
        Provisioning prov = Provisioning.getInstance();
        Element eShare = req.getElement("share");
        byte granteeType = ACL.stringToType(eShare.getAttribute("gt"));
        String granteeId = eShare.getAttribute("zid", null);
        String granteeName = eShare.getAttribute("d", null);
        if (granteeType == 7) {
            if (granteeName == null) {
                throw ServiceException.INVALID_REQUEST("must specify grantee name for guest grantee type", null);
            }
            matchingId = granteeName;
            granteeDisplayName = granteeEmail = granteeName;
        } else {
            Pair<NamedEntry, String> grantee = this.getGrantee(zsc, granteeType, granteeId, granteeName);
            NamedEntry granteeEntry = grantee.getFirst();
            matchingId = granteeEntry.getId();
            granteeEmail = granteeEntry.getName();
            granteeDisplayName = grantee.getSecond();
        }
        Folder folder = this.getFolder(octxt, authAccount, mbox, eShare);
        Account ownerAcct = authAccount;
        int ownerFolderId = folder.getId();
        if (folder instanceof Mountpoint) {
            Mountpoint mp = (Mountpoint)folder;
            ownerAcct = prov.get(Provisioning.AccountBy.id, mp.getOwnerId());
            ownerFolderId = mp.getRemoteId();
        }
        if ((matchingGrant = Provisioning.onLocalServer(ownerAcct) ? this.getMatchingGrant(octxt, prov, folder, granteeType, matchingId, ownerAcct) : this.getMatchingGrantRemote(zsc, context, granteeType, matchingId, ownerAcct, ownerFolderId)) == null) {
            throw ServiceException.INVALID_REQUEST("no matching grant", null);
        }
        ShareInfoData sid = new ShareInfoData();
        sid.setOwnerAcctId(ownerAcct.getId());
        sid.setOwnerAcctEmail(ownerAcct.getName());
        sid.setOwnerAcctDisplayName(ownerAcct.getDisplayName());
        sid.setFolderId(ownerFolderId);
        sid.setFolderPath(folder.getPath());
        sid.setFolderDefaultView(folder.getDefaultView());
        sid.setRights(matchingGrant.getGrantedRights());
        sid.setGranteeType(granteeType);
        sid.setGranteeId(matchingId);
        sid.setGranteeName(granteeEmail);
        sid.setGranteeDisplayName(granteeDisplayName);
        if (granteeType == 7) {
            String url = UserServlet.getRestUrl(ownerAcct) + folder.getPath();
            sid.setUrl(url);
            sid.setGuestPassword(matchingGrant.getPassword());
        }
        return sid;
    }

    private MatchingGrant getMatchingGrant(OperationContext octxt, Provisioning prov, Folder folder, byte granteeType, String granteeId, Account ownerAcct) throws ServiceException {
        ACL acl;
        Folder ownerFolder = folder;
        if (folder instanceof Mountpoint) {
            Mountpoint mp = (Mountpoint)folder;
            Mailbox ownerMbox = MailboxManager.getInstance().getMailboxByAccountId(mp.getOwnerId(), false);
            ownerFolder = ownerMbox.getFolderById(octxt, mp.getRemoteId());
        }
        if ((acl = ownerFolder.getEffectiveACL()) == null) {
            throw ServiceException.INVALID_REQUEST("no grant on folder", null);
        }
        for (ACL.Grant grant : acl.getGrants()) {
            if (grant.getGranteeType() != granteeType || !grant.getGranteeId().equals(granteeId)) continue;
            return new MatchingGrant(grant);
        }
        return null;
    }

    private MatchingGrant getMatchingGrantRemote(ZimbraSoapContext zsc, Map<String, Object> context, byte granteeType, String granteeId, Account ownerAcct, int remoteFolderId) throws ServiceException {
        Element remote = this.fetchRemoteFolder(zsc, context, ownerAcct.getId(), remoteFolderId);
        Element eAcl = remote.getElement("acl");
        if (eAcl != null) {
            for (Element eGrant : eAcl.listElements("grant")) {
                try {
                    String gid;
                    byte gt = ACL.stringToType(eGrant.getAttribute("gt"));
                    if (gt != granteeType) continue;
                    short rights = ACL.stringToRights(eGrant.getAttribute("perm"));
                    MatchingGrant grant = null;
                    if (gt == 7) {
                        gid = eGrant.getAttribute("d");
                        if (gid.equals(granteeId)) {
                            grant = new MatchingGrant(gid, gt, rights);
                            grant.setPassword(eGrant.getAttribute("pw", null));
                        }
                    } else if ((gt == 1 || gt == 2) && (gid = eGrant.getAttribute("zid")).equals(granteeId)) {
                        grant = new MatchingGrant(gid, gt, rights);
                        grant.setGranteeName(eGrant.getAttribute("d", null));
                    }
                    if (grant == null) continue;
                    return grant;
                }
                catch (ServiceException e) {
                    sLog.warn((Object)"cannot parse soap response for remote grant", e);
                }
            }
        }
        return null;
    }

    private Element fetchRemoteFolder(ZimbraSoapContext zsc, Map<String, Object> context, String ownerId, int remoteId) throws ServiceException {
        Element request = zsc.createRequestElement(MailConstants.GET_FOLDER_REQUEST);
        request.addElement("folder").addAttribute("l", remoteId);
        Element response = this.proxyRequest(request, context, ownerId);
        Element remote = response.getOptionalElement("folder");
        if (remote == null) {
            throw ServiceException.INVALID_REQUEST("cannot mount a search or mountpoint", null);
        }
        return remote;
    }

    private Pair<NamedEntry, String> getGrantee(ZimbraSoapContext zsc, byte granteeType, String granteeId, String granteeName) throws ServiceException {
        String displayName;
        NamedEntry grantee;
        NamedEntry entryById = null;
        NamedEntry entryByName = null;
        if (granteeId != null && (entryById = FolderAction.lookupGranteeByZimbraId(granteeId, granteeType)) == null) {
            throw ServiceException.INVALID_REQUEST("no such grantee " + granteeId, null);
        }
        if (granteeName != null && (entryByName = FolderAction.lookupGranteeByName(granteeName, granteeType, zsc)) == null) {
            throw ServiceException.INVALID_REQUEST("no such grantee " + granteeName, null);
        }
        if (entryById == null && entryByName == null) {
            throw ServiceException.INVALID_REQUEST("no such grantee", null);
        }
        if (entryById != null && entryByName != null && !entryById.getId().equals(entryByName.getId())) {
            throw ServiceException.INVALID_REQUEST("grantee name does not match grantee id", null);
        }
        NamedEntry namedEntry = grantee = entryById != null ? entryById : entryByName;
        if (grantee instanceof Account) {
            displayName = ((Account)grantee).getDisplayName();
        } else if (grantee instanceof DistributionList) {
            displayName = ((DistributionList)grantee).getDisplayName();
        } else {
            throw ServiceException.INVALID_REQUEST("unsupported grantee type for sending share notification email", null);
        }
        return new Pair<NamedEntry, String>(grantee, displayName);
    }

    private Folder getFolder(OperationContext octxt, Account authAccount, Mailbox mbox, Element eShare) throws ServiceException {
        Folder folder;
        block6: {
            String folderId = eShare.getAttribute("l", null);
            String folderPath = eShare.getAttribute("path", null);
            if (folderId != null && folderPath != null) {
                throw ServiceException.INVALID_REQUEST("only one of l or path can be specified", null);
            }
            if (folderId != null) {
                try {
                    int fid = Integer.parseInt(folderId);
                    folder = mbox.getFolderById(octxt, fid);
                    if (folder == null) {
                        throw MailServiceException.NO_SUCH_FOLDER(folderId);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    throw ServiceException.INVALID_REQUEST("malformed item ID: " + folderId, nfe);
                }
            }
            folder = mbox.getFolderByPath(octxt, folderPath);
            if (folder == null) {
                throw MailServiceException.NO_SUCH_FOLDER(folderPath);
            }
        }
        return folder;
    }

    void sendShareNotif(OperationContext octxt, Account authAccount, Mailbox mbox, ShareInfoData sid, String notes) throws ServiceException {
        Locale locale = authAccount.getLocale();
        String charset = authAccount.getAttr("zimbraPrefMailDefaultCharset", "utf-8");
        Mime.FixedMimeMessage mm = null;
        try {
            mm = new Mime.FixedMimeMessage(JMSession.getSession());
            String subject = L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifSubject, locale, new Object[0]);
            mm.setSubject(subject, StringUtil.checkCharset(subject, charset));
            mm.setSentDate(new Date());
            mm.setFrom((Address)AccountUtil.getFriendlyEmailAddress(authAccount));
            String recipient = sid.getGranteeName();
            mm.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            MimeMultipart mmp = ShareInfo.NotificationSender.genNotifBody(sid, L10nUtil.MsgKey.shareNotifBodyIntro, notes, locale);
            mm.setContent((Multipart)mmp);
            mm.saveChanges();
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Messaging Exception while building share notification message", e);
        }
        if (mm == null) {
            throw ServiceException.FAILURE("Failed to build share notification message", null);
        }
        if (sLog.isDebugEnabled()) {
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                mm.writeTo(buf);
                String mmDump = new String(buf.toByteArray());
                sLog.debug("********\n" + mmDump);
            }
            catch (MessagingException e) {
                sLog.debug((Object)"failed log debug share notification message", e);
            }
            catch (IOException e) {
                sLog.debug((Object)"failed log debug share notification message", e);
            }
        }
        mbox.getMailSender().sendMimeMessage(octxt, mbox, true, mm, null, null, null, null, null, false, false);
    }

    void sendShareNotif(Account authAccount, ShareInfoData sid, String notes) throws ServiceException {
        Locale locale = authAccount.getLocale();
        String charset = authAccount.getAttr("zimbraPrefMailDefaultCharset", "utf-8");
        try {
            SMTPMessage notif = new SMTPMessage(JMSession.getSession());
            String subject = L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifSubject, locale, new Object[0]);
            notif.setSubject(subject, StringUtil.checkCharset(subject, charset));
            notif.setSentDate(new Date());
            notif.setFrom((Address)AccountUtil.getFriendlyEmailAddress(authAccount));
            String recipient = sid.getGranteeName();
            notif.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            if (Provisioning.getInstance().getConfig().getBooleanAttr("zimbraAutoSubmittedNullReturnPath", true)) {
                notif.setEnvelopeFrom("<>");
            } else {
                notif.setEnvelopeFrom(authAccount.getName());
            }
            MimeMultipart mmp = ShareInfo.NotificationSender.genNotifBody(sid, L10nUtil.MsgKey.shareNotifBodyIntro, notes, locale);
            notif.setContent((Multipart)mmp);
            notif.saveChanges();
            Transport.send((Message)notif);
        }
        catch (MessagingException me) {
            throw ServiceException.FAILURE("error while sending share notification", me);
        }
    }

    private static class MatchingGrant {
        ACL.Grant mGrant;
        String mGrantee;
        String mName;
        byte mType;
        short mRights;
        String mSecret;

        MatchingGrant(ACL.Grant grant) {
            this.mGrant = grant;
        }

        MatchingGrant(String zimbraId, byte type, short rights) {
            this.mGrantee = zimbraId;
            this.mType = type;
            this.mRights = rights;
        }

        void setGranteeName(String name) {
            this.mName = name;
        }

        void setPassword(String password) {
            this.mSecret = password;
        }

        short getGrantedRights() {
            return this.mGrant == null ? this.mRights : this.mGrant.getGrantedRights();
        }

        String getPassword() {
            return this.mGrant == null ? this.mSecret : this.mGrant.getPassword();
        }
    }
}

