/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarDataSource;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.util.JMSession;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMsg
extends MailDocumentHandler {
    static Log sLog = LogFactory.getLog(SendMsg.class);
    private static final long MAX_IN_FLIGHT_DELAY_MSECS = 4000L;
    private static final long RETRY_CHECK_PERIOD_MSECS = 500L;
    private static final ItemId NO_MESSAGE_SAVED_TO_SENT = new ItemId((String)null, -1);
    private static final Map<Long, List<Pair<String, ItemId>>> sSentTokens = new HashMap<Long, List<Pair<String, ItemId>>>(100);
    private static final int MAX_SEND_UID_CACHE = 5;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SendMsg.getZimbraSoapContext(context);
        Mailbox mbox = SendMsg.getRequestedMailbox(zsc);
        OperationContext octxt = SendMsg.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element msgElem = request.getElement("m");
        String attachId = msgElem.getAttribute("aid", null);
        boolean needCalendarSentByFixup = request.getAttributeBool("needCalendarSentByFixup", false);
        boolean noSaveToSent = request.getAttributeBool("noSave", false);
        String origId = msgElem.getAttribute("origid", null);
        ItemId iidOrigId = origId == null ? null : new ItemId(origId, zsc);
        String replyType = msgElem.getAttribute("rt", MailSender.MSGTYPE_REPLY);
        String identityId = msgElem.getAttribute("idnt", null);
        SendState state = SendState.NEW;
        ItemId savedMsgId = null;
        Pair<String, ItemId> sendRecord = null;
        String sendUid = request.getAttribute("suid", null);
        if (sendUid != null) {
            long delay = 4000L;
            do {
                if (state == SendState.PENDING) {
                    try {
                        delay -= 500L;
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                Pair<SendState, Pair<String, ItemId>> result = SendMsg.findPendingSend(mbox.getId(), sendUid);
                state = result.getFirst();
                sendRecord = result.getSecond();
            } while (state == SendState.PENDING && delay >= 0L);
        }
        if (state == SendState.SENT) {
            savedMsgId = (ItemId)sendRecord.getSecond();
        } else {
            if (state == SendState.PENDING) {
                throw MailServiceException.TRY_AGAIN("message send already in progress: " + sendUid);
            }
            if (state == SendState.NEW) {
                try {
                    ParseMimeMessage.MimeMessageData mimeData = new ParseMimeMessage.MimeMessageData();
                    MimeMessage mm = attachId != null ? SendMsg.parseUploadedMessage(zsc, attachId, mimeData, needCalendarSentByFixup) : ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, null, mimeData);
                    savedMsgId = SendMsg.doSendMessage(octxt, mbox, mm, mimeData.newContacts, mimeData.uploads, iidOrigId, replyType, identityId, noSaveToSent, false, needCalendarSentByFixup);
                    if (savedMsgId == null) {
                        savedMsgId = NO_MESSAGE_SAVED_TO_SENT;
                    }
                    if (sendRecord != null) {
                        sendRecord.setSecond(savedMsgId);
                    }
                }
                catch (ServiceException e) {
                    SendMsg.clearPendingSend(mbox.getId(), sendRecord);
                    throw e;
                }
                catch (RuntimeException re) {
                    SendMsg.clearPendingSend(mbox.getId(), sendRecord);
                    throw re;
                }
            }
        }
        Element response = zsc.createElement(MailConstants.SEND_MSG_RESPONSE);
        Element respElement = response.addElement("m");
        if (savedMsgId != null && savedMsgId != NO_MESSAGE_SAVED_TO_SENT && savedMsgId.getId() > 0) {
            respElement.addAttribute("id", ifmt.formatItemId(savedMsgId));
        }
        return response;
    }

    public static ItemId doSendMessage(OperationContext oc, Mailbox mbox, MimeMessage mm, List<InternetAddress> newContacts, List<FileUploadServlet.Upload> uploads, ItemId origMsgId, String replyType, String identityId, boolean noSaveToSent, boolean ignoreFailedAddresses, boolean needCalendarSentByFixup) throws ServiceException {
        if (needCalendarSentByFixup) {
            SendMsg.fixupICalendarFromOutlook(mbox, mm);
        }
        if (noSaveToSent) {
            return mbox.getMailSender().sendMimeMessage(oc, mbox, false, mm, newContacts, uploads, origMsgId, replyType, null, ignoreFailedAddresses, false);
        }
        return mbox.getMailSender().sendMimeMessage(oc, mbox, mm, newContacts, uploads, origMsgId, replyType, identityId, ignoreFailedAddresses, false);
    }

    static MimeMessage parseUploadedMessage(ZimbraSoapContext zsc, String attachId, ParseMimeMessage.MimeMessageData mimeData) throws ServiceException {
        return SendMsg.parseUploadedMessage(zsc, attachId, mimeData, false);
    }

    static MimeMessage parseUploadedMessage(ZimbraSoapContext zsc, String attachId, ParseMimeMessage.MimeMessageData mimeData, boolean needCalendarSentByFixup) throws ServiceException {
        boolean anySystemMutators = MimeVisitor.anyMutatorsRegistered();
        FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(zsc.getAuthtokenAccountId(), attachId, zsc.getAuthToken());
        if (up == null) {
            throw MailServiceException.NO_SUCH_UPLOAD(attachId);
        }
        mimeData.uploads = new ArrayList<FileUploadServlet.Upload>(1);
        mimeData.uploads.add(up);
        try {
            if (anySystemMutators || needCalendarSentByFixup) {
                MimeMessage mm = new MimeMessage(JMSession.getSession(), up.getInputStream());
                if (anySystemMutators) {
                    return mm;
                }
                OutlookICalendarFixupMimeVisitor.ICalendarModificationCallback callback = new OutlookICalendarFixupMimeVisitor.ICalendarModificationCallback();
                MimeVisitor mv = new OutlookICalendarFixupMimeVisitor(SendMsg.getRequestedAccount(zsc), SendMsg.getRequestedMailbox(zsc)).setCallback(callback);
                try {
                    mv.accept(mm);
                }
                catch (MessagingException e) {
                    // empty catch block
                }
                if (callback.wouldCauseModification()) {
                    return mm;
                }
            }
            return new MimeMessage(JMSession.getSession(), up.getInputStream()){

                protected void updateHeaders() throws MessagingException {
                    this.setHeader("MIME-Version", "1.0");
                    if (this.getMessageID() == null) {
                        this.updateMessageID();
                    }
                }
            };
        }
        catch (MessagingException e) {
            throw MailServiceException.MESSAGE_PARSE_ERROR(e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException when parsing upload", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<SendState, Pair<String, ItemId>> findPendingSend(Long mailboxId, String sendUid) {
        SendState state = SendState.NEW;
        Pair<String, Object> sendRecord = null;
        Map<Long, List<Pair<String, ItemId>>> map = sSentTokens;
        synchronized (map) {
            List<Pair<String, ItemId>> sendData = sSentTokens.get(mailboxId);
            if (sendData == null) {
                sendData = new ArrayList<Pair<String, ItemId>>(5);
                sSentTokens.put(mailboxId, sendData);
            }
            for (Pair<String, ItemId> record : sendData) {
                if (!record.getFirst().equals(sendUid)) continue;
                state = record.getSecond() == null ? SendState.PENDING : SendState.SENT;
                sendRecord = record;
                break;
            }
            if (state == SendState.NEW) {
                if (sendData.size() >= 5) {
                    sendData.remove(0);
                }
                sendRecord = new Pair<String, Object>(sendUid, null);
                sendData.add(sendRecord);
            }
        }
        return new Pair<SendState, Object>(state, sendRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearPendingSend(Long mailboxId, Pair<String, ItemId> sendRecord) {
        if (sendRecord != null) {
            Map<Long, List<Pair<String, ItemId>>> map = sSentTokens;
            synchronized (map) {
                sSentTokens.get(mailboxId).remove(sendRecord);
            }
        }
    }

    private static void fixupICalendarFromOutlook(Mailbox ownerMbox, MimeMessage mm) throws ServiceException {
        OutlookICalendarFixupMimeVisitor mv = new OutlookICalendarFixupMimeVisitor(ownerMbox.getAccount(), ownerMbox);
        try {
            mv.accept(mm);
        }
        catch (MessagingException e) {
            throw ServiceException.PARSE_ERROR("Error while fixing up SendMsg for SENT-BY", e);
        }
    }

    private static class OutlookICalendarFixupMimeVisitor
    extends MimeVisitor {
        private Account mAccount;
        private Mailbox mMailbox;
        private int mMsgDepth;
        private String[] mFromEmails;
        private String mSentBy;
        private String mDefaultCharset;

        OutlookICalendarFixupMimeVisitor(Account acct, Mailbox mbox) {
            this.mAccount = acct;
            this.mMailbox = mbox;
            this.mMsgDepth = 0;
            this.mDefaultCharset = acct == null ? null : acct.getAttr("zimbraPrefMailDefaultCharset", null);
        }

        protected boolean visitMessage(MimeMessage mm, MimeVisitor.VisitPhase visitKind) throws MessagingException {
            boolean modified = false;
            if (MimeVisitor.VisitPhase.VISIT_BEGIN.equals((Object)visitKind)) {
                ++this.mMsgDepth;
                if (this.mMsgDepth == 1) {
                    Address[] fromAddrs = mm.getFrom();
                    Address senderAddr = mm.getSender();
                    if (senderAddr != null && fromAddrs != null) {
                        for (Address from : fromAddrs) {
                            if (!from.equals((Object)senderAddr)) continue;
                            return false;
                        }
                        if (!(senderAddr instanceof InternetAddress)) {
                            return false;
                        }
                        String sender = ((InternetAddress)senderAddr).getAddress();
                        if (sender == null) {
                            return false;
                        }
                        String[] froms = new String[fromAddrs.length];
                        for (int i = 0; i < fromAddrs.length; ++i) {
                            Address fromAddr = fromAddrs[i];
                            if (fromAddr == null) {
                                return false;
                            }
                            if (!(fromAddr instanceof InternetAddress)) {
                                return false;
                            }
                            String from = ((InternetAddress)fromAddr).getAddress();
                            if (from == null) {
                                return false;
                            }
                            froms[i] = "MAILTO:" + from;
                        }
                        this.mFromEmails = froms;
                        this.mSentBy = "MAILTO:" + sender;
                        mm.setReplyTo(new Address[]{senderAddr});
                        modified = true;
                    }
                }
            } else if (MimeVisitor.VisitPhase.VISIT_END.equals((Object)visitKind)) {
                --this.mMsgDepth;
            }
            return modified;
        }

        protected boolean visitMultipart(MimeMultipart mp, MimeVisitor.VisitPhase visitKind) {
            return false;
        }

        protected boolean visitBodyPart(MimeBodyPart bp) throws MessagingException {
            ZCalendar.ZVCalendar ical;
            if (this.mMsgDepth != 1) {
                return false;
            }
            boolean modified = false;
            String ct = Mime.getContentType((MimePart)bp);
            if ("text/calendar".compareToIgnoreCase(ct) != 0) {
                return false;
            }
            InputStream is = null;
            try {
                try {
                    DataSource source = bp.getDataHandler().getDataSource();
                    is = source.getInputStream();
                    String charset = this.mDefaultCharset;
                    String cs = Mime.getCharset(source.getContentType());
                    if (cs != null) {
                        charset = cs;
                    }
                    ical = ZCalendar.ZCalendarBuilder.build(is, charset);
                }
                catch (Exception e) {
                    throw new MessagingException("Unable to parse iCalendar part: " + e.getMessage(), e);
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            String method = ical.getPropVal(ZCalendar.ICalTok.METHOD, ZCalendar.ICalTok.REQUEST.toString());
            boolean isReply = method.equalsIgnoreCase(ZCalendar.ICalTok.REPLY.toString());
            if (!isReply) {
                modified = this.fixupRequest(ical);
            } else {
                try {
                    modified = this.fixupReply(ical);
                }
                catch (ServiceException e) {
                    sLog.warn((Object)("Unable perform fixup of calendar reply from Outlook for mailbox " + this.mMailbox.getId() + "; ignoring error"), e);
                }
            }
            if (modified) {
                if (this.mCallback != null && !this.mCallback.onModification()) {
                    return false;
                }
                String filename = bp.getFileName();
                if (filename == null) {
                    filename = "meeting.ics";
                }
                bp.setDataHandler(new DataHandler(new CalendarDataSource(ical, "fixup", filename)));
            }
            return modified;
        }

        private boolean fixupRequest(ZCalendar.ZVCalendar ical) {
            boolean modified = false;
            Iterator<ZCalendar.ZComponent> compIter = ical.getComponentIterator();
            while (compIter.hasNext()) {
                ZCalendar.ZComponent comp = compIter.next();
                ZCalendar.ICalTok compType = comp.getTok();
                if (!ZCalendar.ICalTok.VEVENT.equals((Object)compType) && !ZCalendar.ICalTok.VTODO.equals((Object)compType)) continue;
                boolean isSeries = false;
                Iterator<ZCalendar.ZProperty> propIter = comp.getPropertyIterator();
                block5: while (propIter.hasNext()) {
                    ZCalendar.ZProperty prop = propIter.next();
                    ZCalendar.ICalTok token = prop.getToken();
                    if (token == null) continue;
                    switch (token) {
                        case ORGANIZER: 
                        case ATTENDEE: {
                            ZCalendar.ZParameter sentBy;
                            if (this.mFromEmails == null || this.mSentBy == null) break;
                            String addr = prop.getValue();
                            if (!this.addressMatchesFrom(addr) || (sentBy = prop.getParameter(ZCalendar.ICalTok.SENT_BY)) != null) continue block5;
                            prop.addParameter(new ZCalendar.ZParameter(ZCalendar.ICalTok.SENT_BY, this.mSentBy));
                            modified = true;
                            ZimbraLog.calendar.info("Fixed up " + (Object)((Object)token) + " (" + addr + ") by adding SENT-BY=" + this.mSentBy);
                            break;
                        }
                        case RRULE: {
                            isSeries = true;
                        }
                    }
                }
                if (!isSeries) continue;
                comp.addProperty(new ZCalendar.ZProperty(ZCalendar.ICalTok.X_ZIMBRA_DISCARD_EXCEPTIONS, true));
                modified = true;
            }
            return modified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fixupReply(ZCalendar.ZVCalendar ical) throws ServiceException {
            String uid;
            HashMap<String, ZCalendar.ZProperty> uidToOrganizer = new HashMap<String, ZCalendar.ZProperty>();
            List<Invite> replyInvs = Invite.createFromCalendar(this.mAccount, null, ical, false);
            for (Invite replyInv : replyInvs) {
                ZOrganizer replyOrg = replyInv.getOrganizer();
                if (replyOrg != null && replyOrg.hasSentBy()) continue;
                uid = replyInv.getUid();
                Mailbox mailbox = this.mMailbox;
                synchronized (mailbox) {
                    CalendarItem calItem = this.mMailbox.getCalendarItemByUid(uid);
                    if (calItem != null) {
                        ZOrganizer org;
                        RecurId rid = replyInv.getRecurId();
                        Invite inv = calItem.getInvite(rid);
                        if (inv == null && rid != null) {
                            inv = calItem.getInvite(null);
                        }
                        if (inv != null && (org = inv.getOrganizer()) != null) {
                            ZCalendar.ZProperty orgProp = org.toProperty();
                            if (replyOrg == null) {
                                uidToOrganizer.put(uid, orgProp);
                            } else {
                                String replyOrgAddr = replyOrg.getAddress();
                                String orgAddr = org.getAddress();
                                if (org.hasSentBy() || orgAddr != null && !orgAddr.equalsIgnoreCase(replyOrgAddr)) {
                                    uidToOrganizer.put(uid, orgProp);
                                }
                            }
                        }
                    }
                }
            }
            if (uidToOrganizer.isEmpty()) {
                return false;
            }
            Iterator<ZCalendar.ZComponent> compIter = ical.getComponentIterator();
            while (compIter.hasNext()) {
                ZCalendar.ZProperty fixedOrganizer;
                ZCalendar.ZComponent comp = compIter.next();
                ZCalendar.ICalTok compType = comp.getTok();
                if (!ZCalendar.ICalTok.VEVENT.equals((Object)compType) && !ZCalendar.ICalTok.VTODO.equals((Object)compType) || (fixedOrganizer = (ZCalendar.ZProperty)uidToOrganizer.get(uid = comp.getPropVal(ZCalendar.ICalTok.UID, null))) == null) continue;
                Iterator<ZCalendar.ZProperty> propIter = comp.getPropertyIterator();
                while (propIter.hasNext()) {
                    ZCalendar.ZProperty prop = propIter.next();
                    ZCalendar.ICalTok token = prop.getToken();
                    if (!ZCalendar.ICalTok.ORGANIZER.equals((Object)token)) continue;
                    propIter.remove();
                    break;
                }
                comp.addProperty(fixedOrganizer);
                ZimbraLog.calendar.info("Fixed up ORGANIZER in a REPLY from ZCO");
            }
            return true;
        }

        private boolean addressMatchesFrom(String addr) {
            if (addr == null) {
                return false;
            }
            for (String from : this.mFromEmails) {
                if (from.compareToIgnoreCase(addr) != 0) continue;
                return true;
            }
            return false;
        }

        static class ICalendarModificationCallback
        implements MimeVisitor.ModificationCallback {
            private boolean mWouldModify;

            ICalendarModificationCallback() {
            }

            public boolean wouldCauseModification() {
                return this.mWouldModify;
            }

            public boolean onModification() {
                this.mWouldModify = true;
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SendState {
        NEW,
        SENT,
        PENDING;

    }
}

