/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendInviteReply
extends CalendarRequest {
    private static Log sLog = LogFactory.getLog(SendInviteReply.class);
    private static final String[] TARGET_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        CalendarItem calItem;
        int inviteMsgId;
        int calItemId;
        ZimbraSoapContext zsc = SendInviteReply.getZimbraSoapContext(context);
        Mailbox mbox = SendInviteReply.getRequestedMailbox(zsc);
        Account acct = SendInviteReply.getRequestedAccount(zsc);
        Account authAcct = SendInviteReply.getAuthenticatedAccount(zsc);
        boolean isAdmin = zsc.isUsingAdminPrivileges();
        OperationContext octxt = SendInviteReply.getOperationContext(zsc, context);
        boolean onBehalfOf = zsc.isDelegatedRequest();
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        int compNum = (int)request.getAttributeLong("compNum");
        String verbStr = request.getAttribute("verb");
        CalendarMailSender.Verb verb = CalendarMailSender.parseVerb(verbStr);
        boolean updateOrg = request.getAttributeBool("updateOrganizer", true);
        if (sLog.isInfoEnabled()) {
            sLog.info("<SendInviteReply id=" + new ItemIdFormatter(zsc).formatItemId(iid) + " verb=" + verb + " updateOrg=" + updateOrg + "> " + zsc.toString());
        }
        Element response = this.getResponseElement(zsc);
        boolean intendedForMe = true;
        Invite oldInv = null;
        if (iid.hasSubpart()) {
            calItemId = iid.getId();
            inviteMsgId = iid.getSubpartId();
            calItem = mbox.getCalendarItemById(octxt, calItemId);
            if (calItem == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
            }
            oldInv = calItem.getInvite(inviteMsgId, compNum);
        } else {
            inviteMsgId = iid.getId();
            Message msg = mbox.getMessageById(octxt, inviteMsgId);
            Message.CalendarItemInfo info = msg.getCalendarItemInfo(compNum);
            if (info == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
            }
            String intendedFor = msg.getCalendarIntendedFor();
            Account intendedAcct = null;
            if (intendedFor != null) {
                try {
                    InternetAddress intendedForAddr = new InternetAddress(intendedFor);
                    intendedAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, intendedForAddr.getAddress());
                }
                catch (AddressException e) {
                    throw ServiceException.INVALID_REQUEST("The intended account " + intendedFor + " is invalid", e);
                }
                if (intendedAcct == null) {
                    throw ServiceException.INVALID_REQUEST("The intended account " + intendedFor + " was not found", null);
                }
                if (intendedAcct.equals(mbox.getAccount())) {
                    intendedAcct = null;
                } else {
                    intendedForMe = false;
                }
            }
            if (intendedAcct != null) {
                calItem = null;
                calItemId = 0;
                ZMailbox zmbx = SendInviteReply.getRemoteZMailbox(octxt, authAcct, intendedAcct);
                AddInviteResult addInviteResult = SendInviteReply.sendAddInvite(zmbx, msg);
                if (addInviteResult == null) {
                    throw MailServiceException.INVITE_OUT_OF_DATE(iid.toString());
                }
                SendInviteReply.remoteSendInviteReply(zmbx, request, addInviteResult);
            } else {
                calItemId = info.getCalendarItemId();
                if (info.calItemCreated()) {
                    calItem = mbox.getCalendarItemById(octxt, calItemId);
                    if (calItem == null) {
                        throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
                    }
                    oldInv = calItem.getInvite(inviteMsgId, compNum);
                } else if (info.getInvite() != null) {
                    Invite curr;
                    Invite inv = info.getInvite().newCopy();
                    Invite.setDefaultAlarm(inv, acct);
                    inv.setMailItemId(inviteMsgId);
                    calItem = mbox.getCalendarItemByUid(octxt, inv.getUid());
                    int n = calItemId = calItem != null ? calItem.getId() : 0;
                    if (calItem != null && (curr = calItem.getInvite(inv.getRecurId())) != null && !inv.isSameOrNewerVersion(curr)) {
                        throw MailServiceException.INVITE_OUT_OF_DATE(iid.toString());
                    }
                    if (calItem != null || !CalendarMailSender.VERB_DECLINE.equals(verb)) {
                        ParsedMessage pm;
                        int folder = calItem != null && calItem.getFolderId() != 3 ? calItem.getFolderId() : (inv.isTodo() ? 15 : 10);
                        int[] ids = mbox.addInvite(octxt, inv, folder, pm = new ParsedMessage(msg.getMimeMessage(false), false));
                        if (ids != null && ids.length > 0) {
                            calItemId = ids[0];
                        }
                        if ((calItem = mbox.getCalendarItemById(octxt, calItemId)) == null) {
                            throw ServiceException.FAILURE("Could not create/update calendar item", null);
                        }
                    }
                    oldInv = inv;
                } else {
                    throw ServiceException.FAILURE("Missing invite data", null);
                }
            }
        }
        if (intendedForMe) {
            if (oldInv == null) {
                throw MailServiceException.INVITE_OUT_OF_DATE(iid.toString());
            }
            if (calItem != null && (mbox.getEffectivePermissions(octxt, calItemId, (byte)-1) & 0x10) == 0) {
                throw ServiceException.PERM_DENIED("You do not have ACTION rights for CalendarItem " + calItemId);
            }
            boolean allowPrivateAccess = calItem != null ? calItem.allowPrivateAccess(authAcct, isAdmin) : true;
            boolean isCalendarResource = acct instanceof CalendarResource;
            if (!(allowPrivateAccess || oldInv.isPublic() || isCalendarResource)) {
                throw ServiceException.PERM_DENIED("Cannot reply to a private appointment/task on behalf of another user");
            }
            Element exc = request.getOptionalElement("exceptId");
            ParsedDateTime exceptDt = null;
            if (exc != null) {
                TimeZoneMap tzmap = oldInv.getTimeZoneMap();
                Element tzElem = request.getOptionalElement("tz");
                ICalTimeZone tz = null;
                if (tzElem != null) {
                    tz = CalendarUtils.parseTzElement(tzElem);
                    tzmap.add(tz);
                }
                exceptDt = CalendarUtils.parseDateTime(exc, tzmap);
            } else if (oldInv.hasRecurId()) {
                exceptDt = oldInv.getRecurId().getDt();
            }
            if (calItem != null && oldInv.isRecurrence() && exceptDt != null) {
                MimeMessage mmInv;
                Invite localException = oldInv.newCopy();
                localException.setLocalOnly(true);
                localException.setRecurrence(null);
                RecurId rid = new RecurId(exceptDt, RecurId.RANGE_NONE);
                localException.setRecurId(rid);
                long now = octxt != null ? octxt.getTimestamp() : System.currentTimeMillis();
                localException.setDtStamp(now);
                ParsedDateTime dtEnd = exceptDt.add(localException.getEffectiveDuration());
                localException.setDtStart(exceptDt);
                localException.setDtEnd(dtEnd);
                String partStat = verb.getXmlPartStat();
                localException.setPartStat(partStat);
                ZAttendee at = localException.getMatchingAttendee(acct);
                if (at != null) {
                    at.setPartStat(partStat);
                }
                ParsedMessage pm = (mmInv = calItem.getSubpartMessage(oldInv.getMailItemId())) != null ? new ParsedMessage(mmInv, false) : null;
                mbox.addInvite(octxt, localException, calItem.getFolderId(), pm, true, false, true);
                calItem = mbox.getCalendarItemById(octxt, calItemId);
                oldInv = calItem.getInvite(rid);
            }
            if (updateOrg && oldInv.hasOrganizer()) {
                Account organizer = oldInv.getOrganizerAccount();
                Locale locale = organizer != null ? organizer.getLocale() : (!onBehalfOf ? acct.getLocale() : authAcct.getLocale());
                String subject = !allowPrivateAccess && !oldInv.isPublic() ? L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectWithheld, locale, new Object[0]) : oldInv.getName();
                String replySubject = CalendarMailSender.getReplySubject(verb, subject, locale);
                CalendarRequest.CalSendData csd = new CalendarRequest.CalSendData();
                csd.mOrigId = new ItemId(mbox, oldInv.getMailItemId());
                csd.mReplyType = MailSender.MSGTYPE_REPLY;
                csd.mInvite = CalendarMailSender.replyToInvite(acct, authAcct, onBehalfOf, allowPrivateAccess, oldInv, verb, replySubject, exceptDt);
                ZCalendar.ZVCalendar iCal = csd.mInvite.newToICalendar(true);
                ParseMimeMessage.MimeMessageData parsedMessageData = new ParseMimeMessage.MimeMessageData();
                Element msgElem = request.getOptionalElement("m");
                if (msgElem != null) {
                    String text = ParseMimeMessage.getTextPlainContent(msgElem);
                    String html = ParseMimeMessage.getTextHtmlContent(msgElem);
                    iCal.addDescription(text, html);
                    MimeBodyPart[] mbps = new MimeBodyPart[]{CalendarMailSender.makeICalIntoMimePart(oldInv.getUid(), iCal)};
                    csd.mMm = ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, mbps, ParseMimeMessage.NO_INV_ALLOWED_PARSER, parsedMessageData);
                } else if (!(acct instanceof CalendarResource)) {
                    csd.mMm = CalendarMailSender.createDefaultReply(acct, authAcct, isAdmin, onBehalfOf, calItem, oldInv, null, replySubject, verb, null, iCal);
                } else {
                    RecurId rid = oldInv.getRecurId();
                    ParsedDateTime ridDt = rid != null ? rid.getDt() : null;
                    Invite replyInv = CalendarMailSender.replyToInvite(acct, authAcct, onBehalfOf, allowPrivateAccess, oldInv, verb, replySubject, ridDt);
                    MimeMessage mmInv = calItem.getSubpartMessage(oldInv.getMailItemId());
                    csd.mMm = CalendarMailSender.createResourceAutoReply(octxt, mbox, verb, false, null, calItem, oldInv, new Invite[]{replyInv}, mmInv);
                }
                int apptFolderId = calItem != null ? calItem.getFolderId() : (oldInv.isTodo() ? 15 : 10);
                SendInviteReply.sendCalendarMessage(zsc, octxt, apptFolderId, acct, mbox, csd, response, false);
            }
            RecurId recurId = null;
            if (exceptDt != null) {
                recurId = new RecurId(exceptDt, RecurId.RANGE_NONE);
            }
            ZAttendee me = oldInv.getMatchingAttendee(acct);
            String cnStr = null;
            String addressStr = acct.getName();
            String role = "OPT";
            int seqNo = oldInv.getSeqNo();
            long dtStamp = oldInv.getDTStamp();
            if (me != null) {
                if (me.hasCn()) {
                    cnStr = me.getCn();
                }
                addressStr = me.getAddress();
                if (me.hasRole()) {
                    role = me.getRole();
                }
            }
            if (calItem != null) {
                mbox.modifyPartStat(octxt, calItemId, recurId, cnStr, addressStr, null, role, verb.getXmlPartStat(), Boolean.FALSE, seqNo, dtStamp);
            }
        }
        if (acct.getBooleanAttr("zimbraPrefDeleteInviteOnReply", true)) {
            try {
                if (onBehalfOf) {
                    octxt = new OperationContext(mbox);
                }
                mbox.move(octxt, inviteMsgId, (byte)5, 3);
            }
            catch (MailServiceException.NoSuchItemException nsie) {
                sLog.debug("can't move nonexistent invite to Trash: " + inviteMsgId);
            }
        }
        return response;
    }

    private static ZMailbox getRemoteZMailbox(OperationContext octxt, Account authAcct, Account targetAcct) throws ServiceException {
        String pxyAuthToken;
        AuthToken authToken = null;
        if (octxt != null) {
            authToken = octxt.getAuthToken();
        }
        if (authToken == null) {
            authToken = AuthProvider.getAuthToken(authAcct);
        }
        ZAuthToken zat = (pxyAuthToken = authToken.getProxyAuthToken()) == null ? authToken.toZAuthToken() : new ZAuthToken(pxyAuthToken);
        ZMailbox.Options zoptions = new ZMailbox.Options(zat, AccountUtil.getSoapUri(targetAcct));
        zoptions.setNoSession(true);
        zoptions.setResponseProtocol(SoapProtocol.SoapJS);
        zoptions.setTargetAccount(targetAcct.getId());
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        return ZMailbox.getMailbox(zoptions);
    }

    private static AddInviteResult sendAddInvite(ZMailbox zmbx, Message msg) throws ServiceException {
        ItemIdFormatter ifmt = new ItemIdFormatter();
        Element addInvite = Element.create(SoapProtocol.SoapJS, MailConstants.ADD_APPOINTMENT_INVITE_REQUEST);
        ToXML.encodeMessageAsMIME(addInvite, ifmt, msg, null, true, false);
        Element response = zmbx.invoke(addInvite);
        int calItemId = (int)response.getAttributeLong("calItemId", 0L);
        int invId = (int)response.getAttributeLong("invId", 0L);
        int compNum = (int)response.getAttributeLong("compNum", 0L);
        if (calItemId != 0) {
            return new AddInviteResult(calItemId, invId, compNum);
        }
        return null;
    }

    private static void remoteSendInviteReply(ZMailbox zmbx, Element origRequest, AddInviteResult ids) throws ServiceException {
        ItemIdFormatter ifmt = new ItemIdFormatter();
        Element req = origRequest.clone();
        req.detach();
        String idStr = ifmt.formatItemId(ids.getCalItemId(), ids.getInvId());
        req.addAttribute("id", idStr);
        req.addAttribute("compNum", ids.getCompNum());
        zmbx.invoke(req);
    }

    private static class AddInviteResult {
        private int mCalItemId;
        private int mInvId;
        private int mCompNum;

        public AddInviteResult(int calItemId, int invId, int compNum) {
            this.mCalItemId = calItemId;
            this.mInvId = invId;
            this.mCompNum = compNum;
        }

        public int getCalItemId() {
            return this.mCalItemId;
        }

        public int getInvId() {
            return this.mInvId;
        }

        public int getCompNum() {
            return this.mCompNum;
        }
    }
}

