/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.sun.mail.smtp.SMTPMessage;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.soap.ZimbraSoapContext;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendDeliveryReport
extends MailDocumentHandler {
    private static final String[] TARGET_ITEM_PATH = new String[]{"mid"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = SendDeliveryReport.getZimbraSoapContext(context);
        Mailbox mbox = SendDeliveryReport.getRequestedMailbox(zsc);
        OperationContext octxt = SendDeliveryReport.getOperationContext(zsc, context);
        int msgid = new ItemId(request.getAttribute("mid"), zsc).getId();
        com.zimbra.cs.mailbox.Message msg = mbox.getMessageById(octxt, msgid);
        if ((mbox.getEffectivePermissions(octxt, msgid, (byte)5) & 2) == 0) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions on the message");
        }
        this.sendReport(SendDeliveryReport.getAuthenticatedAccount(zsc), msg, false, zsc.getRequestIP(), zsc.getUserAgent());
        mbox.alterTag(octxt, msgid, (byte)5, -9, true);
        Element response = zsc.createElement(MailConstants.SEND_REPORT_RESPONSE);
        return response;
    }

    void sendReport(Account authAccount, com.zimbra.cs.mailbox.Message msg, boolean automatic, String requestHost, String userAgent) throws ServiceException {
        MimeMessage mm = msg.getMimeMessage();
        Account owner = msg.getMailbox().getAccount();
        String charset = authAccount.getAttr("zimbraPrefMailDefaultCharset", "utf-8");
        try {
            InternetAddress[] recipients = Mime.parseAddressHeader(mm, "Disposition-Notification-To");
            if (recipients == null || recipients.length == 0) {
                return;
            }
            SMTPMessage report = new SMTPMessage(JMSession.getSession());
            String subject = "Read-Receipt: " + msg.getSubject();
            report.setSubject(subject, StringUtil.checkCharset(subject, charset));
            report.setSentDate(new Date());
            report.setFrom((Address)AccountUtil.getFriendlyEmailAddress(authAccount));
            report.addRecipients(Message.RecipientType.TO, (Address[])recipients);
            report.setHeader("Auto-Submitted", "auto-replied (zimbra; read-receipt)");
            report.setHeader("Precedence", "bulk");
            if (Provisioning.getInstance().getConfig().getBooleanAttr("zimbraAutoSubmittedNullReturnPath", true)) {
                report.setEnvelopeFrom("<>");
            } else {
                report.setEnvelopeFrom(authAccount.getName());
            }
            MimeMultipart multi = new MimeMultipart("report");
            String text = this.generateTextPart(owner, mm, authAccount.getLocale());
            MimeBodyPart mpText = new MimeBodyPart();
            mpText.setText(text, StringUtil.checkCharset(text, charset));
            multi.addBodyPart((BodyPart)mpText);
            String mdn = this.generateReport(owner, mm, automatic, requestHost, userAgent);
            MimeBodyPart mpMDN = new MimeBodyPart();
            mpMDN.setText(mdn, "utf-8");
            mpMDN.setHeader("Content-Type", "message/disposition-notification; charset=utf-8");
            multi.addBodyPart((BodyPart)mpMDN);
            report.setContent((Multipart)multi);
            report.setHeader("Content-Type", multi.getContentType() + "; report-type=disposition-notification");
            report.saveChanges();
            Transport.send((Message)report);
        }
        catch (MessagingException me) {
            throw ServiceException.FAILURE("error while sending read receipt", me);
        }
    }

    private String generateTextPart(Account owner, MimeMessage mm, Locale lc) throws MessagingException {
        String subject = Mime.getSubject(mm);
        Date date = mm.getSentDate();
        String dateStr = date == null ? "???" : DateFormat.getDateTimeInstance(3, 3, lc).format(date);
        return L10nUtil.getMessage(L10nUtil.MsgKey.readReceiptNotification, lc, dateStr, owner.getName(), subject);
    }

    private String generateReport(Account owner, MimeMessage mm, boolean automatic, String requestHost, String userAgent) throws MessagingException {
        StringBuilder mdn = new StringBuilder();
        if (userAgent != null || requestHost != null) {
            mdn.append("Reporting-UA: ");
            if (requestHost != null && !requestHost.trim().equals("")) {
                mdn.append(requestHost).append(userAgent == null ? "" : "; ");
            }
            if (userAgent != null && !userAgent.trim().equals("")) {
                mdn.append(userAgent);
            }
            mdn.append("\r\n");
        }
        mdn.append("Original-Recipient: rfc822;").append(owner.getName()).append("\r\n");
        mdn.append("Final-Recipient: rfc822;").append(owner.getName()).append("\r\n");
        String messageID = mm.getMessageID();
        if (messageID != null && !messageID.trim().equals("")) {
            mdn.append("Original-Message-ID: ").append(messageID.trim()).append("\r\n");
        }
        mdn.append("Disposition: manual-action/MDN-sent-");
        mdn.append(automatic ? "automatically" : "manually");
        mdn.append("; displayed\r\n");
        return mdn.toString();
    }
}

