/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.mail.Search;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchConv
extends Search {
    private static Log sLog = LogFactory.getLog(Search.class);
    private static final int CONVERSATION_FIELD_MASK = 22;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("**Start SearchConv");
        }
        ZimbraSoapContext zsc = SearchConv.getZimbraSoapContext(context);
        Mailbox mbox = SearchConv.getRequestedMailbox(zsc);
        OperationContext octxt = SearchConv.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        boolean nest = request.getAttributeBool("nest", false);
        Account acct = SearchConv.getRequestedAccount(zsc);
        SearchParams params = SearchParams.parse(request, zsc, acct.getAttr("zimbraPrefMailInitialSearch"));
        ItemId cid = new ItemId(request.getAttribute("cid"), zsc);
        StringBuilder queryBuffer = new StringBuilder("conv:\"");
        queryBuffer.append(cid.toString(ifmt));
        queryBuffer.append("\" (");
        queryBuffer.append(params.getQueryStr());
        queryBuffer.append(")");
        params.setQueryStr(queryBuffer.toString());
        params.setTypesStr("message");
        if (cid.belongsTo(mbox)) {
            Element element;
            ZimbraQueryResults results = this.doSearch(zsc, octxt, mbox, params);
            try {
                Element response = zsc.createElement(MailConstants.SEARCH_CONV_RESPONSE);
                response.addAttribute("offset", Integer.toString(params.getOffset()));
                SortBy sort = results.getSortBy();
                response.addAttribute("sortBy", sort.toString());
                List<Message> msgs = mbox.getMessagesByConversation(octxt, cid.getId(), sort);
                if (msgs.isEmpty() && zsc.isDelegatedRequest()) {
                    throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
                }
                Conversation conv = mbox.getConversationById(octxt, cid.getId());
                if (conv.isTagged(-8)) {
                    List<Message> raw = msgs;
                    msgs = new ArrayList<Message>();
                    for (Message msg : raw) {
                        if (msg.isTagged(-8)) continue;
                        msgs.add(msg);
                    }
                }
                Element container = nest ? ToXML.encodeConversationSummary(response, ifmt, octxt, conv, 22) : response;
                boolean more = this.putHits(octxt, ifmt, container, msgs, results, params);
                response.addAttribute("more", more);
                SearchConv.putInfo(response, params, results);
                element = response;
                Object var21_33 = null;
            }
            catch (Throwable throwable) {
                Object var21_34 = null;
                results.doneWithSearchResults();
                throw throwable;
            }
            results.doneWithSearchResults();
            return element;
        }
        try {
            Element proxyRequest = zsc.createElement(MailConstants.SEARCH_CONV_REQUEST);
            params.encodeParams(proxyRequest);
            proxyRequest.addAttribute("nest", nest);
            proxyRequest.addAttribute("cid", cid.toString());
            try {
                String rewrittenQueryString = mbox.getRewrittenQueryString(octxt, params);
                proxyRequest.addAttribute("query", rewrittenQueryString, Element.Disposition.CONTENT);
                Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, cid.getAccountId(), zsc.getAuthToken());
                SoapHttpTransport soapTransp = new SoapHttpTransport(AccountUtil.getSoapUri(target));
                String pxyAuthToken = Provisioning.onLocalServer(target) ? null : zsc.getAuthToken().getProxyAuthToken();
                soapTransp.setAuthToken(pxyAuthToken == null ? AuthProvider.getAuthToken(acct).getEncoded() : pxyAuthToken);
                soapTransp.setTargetAcctId(target.getId());
                soapTransp.setRequestProtocol(zsc.getResponseProtocol());
                Element response = soapTransp.invokeWithoutSession(proxyRequest);
                return response.detach();
            }
            catch (ParseException e) {
                MailServiceException me = null;
                String message = e.getMessage();
                if (e.code != null) {
                    message = e.code;
                }
                if (e.expectedTokenSequences != null) {
                    message = "PARSER_ERROR";
                }
                me = e.currentToken != null ? MailServiceException.QUERY_PARSE_ERROR(params.getQueryStr(), e, e.currentToken.image, e.currentToken.beginColumn, message) : MailServiceException.QUERY_PARSE_ERROR(params.getQueryStr(), e, "", -1, message);
                throw me;
            }
            catch (IOException ex) {
                throw ServiceException.FAILURE("IOException: ", ex);
            }
            catch (SoapFaultException ex) {
                throw ServiceException.FAILURE("SoapFaultException: ", ex);
            }
        }
        catch (AuthTokenException e) {
            throw ServiceException.FAILURE("AuthTokenException: ", e);
        }
    }

    private boolean putHits(OperationContext octxt, ItemIdFormatter ifmt, Element response, List<Message> msgs, ZimbraQueryResults results, SearchParams params) throws ServiceException {
        int offset = params.getOffset();
        int limit = params.getLimit();
        if (sLog.isDebugEnabled()) {
            sLog.debug("SearchConv beginning with offset " + offset);
        }
        int iterLen = limit;
        if (msgs.size() <= iterLen + offset) {
            iterLen = msgs.size() - offset;
        }
        if (iterLen > 0) {
            int i;
            ZimbraHit[] matched = new ZimbraHit[iterLen];
            ZimbraHit curHit = results.getFirstHit();
            while (curHit != null) {
                for (i = offset; i < offset + iterLen; ++i) {
                    if (curHit.getItemId() != msgs.get(i).getId()) continue;
                    matched[i - offset] = curHit;
                    break;
                }
                curHit = results.getNext();
            }
            SearchParams.ExpandResults expand = params.getInlineRule();
            for (i = offset; i < offset + iterLen; ++i) {
                boolean inline;
                if (matched[i - offset] != null) {
                    MessageHit mhit = (MessageHit)matched[i - offset];
                    inline = expand == SearchParams.ExpandResults.FIRST || expand == SearchParams.ExpandResults.ALL || expand == SearchParams.ExpandResults.HITS || expand.matches(mhit.getParsedItemID());
                    this.addMessageHit(mhit, response, octxt, ifmt, inline, params);
                    if (expand != SearchParams.ExpandResults.FIRST) continue;
                    expand = SearchParams.ExpandResults.NONE;
                    continue;
                }
                Message msg = msgs.get(i);
                inline = expand == SearchParams.ExpandResults.ALL || expand.matches(msg);
                this.addMessageMiss(msg, response, octxt, ifmt, inline, params);
            }
        }
        return offset + iterLen < msgs.size();
    }
}

