/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.im.provider.ZimbraRoutingTableImpl;
import com.zimbra.cs.index.CalendarItemHit;
import com.zimbra.cs.index.ContactHit;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.DocumentHit;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.NoteHit;
import com.zimbra.cs.index.ProxiedHit;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.ResultsPager;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mailbox.calendar.cache.CacheToXML;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarCacheManager;
import com.zimbra.cs.mailbox.calendar.cache.CalendarData;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import com.zimbra.cs.service.mail.GetCalendarItemSummaries;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.wildfire.XMPPServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Search
extends MailDocumentHandler {
    protected static Log mLog = LogFactory.getLog(Search.class);
    public static final String DEFAULT_SEARCH_TYPES = "conversation";
    protected final boolean INCLUDE_MAILBOX_INFO = true;
    protected final boolean DONT_INCLUDE_MAILBOX_INFO = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element element;
        List<String> apptFolderIds;
        ZimbraSoapContext zsc = Search.getZimbraSoapContext(context);
        Mailbox mbox = Search.getRequestedMailbox(zsc);
        Account acct = Search.getRequestedAccount(zsc);
        OperationContext octxt = Search.getOperationContext(zsc, context);
        String query = request.getAttribute("query", "");
        if (query.startsWith("$dump_routes")) {
            ZimbraLog.im.info("Routing Table: " + ((ZimbraRoutingTableImpl)XMPPServer.getInstance().getRoutingTable()).dumpRoutingTable());
            Element response = zsc.createElement(MailConstants.SEARCH_RESPONSE);
            return response;
        }
        SearchParams params = SearchParams.parse(request, zsc, acct.getAttr("zimbraPrefMailInitialSearch"));
        String query2 = params.getQueryStr();
        params.setQueryStr(query2);
        if (LC.calendar_cache_enabled.booleanValue() && (apptFolderIds = Search.getFolderIdListIfSimpleAppointmentsQuery(params)) != null) {
            Account authAcct = Search.getAuthenticatedAccount(zsc);
            Element response = zsc.createElement(MailConstants.SEARCH_RESPONSE);
            Search.runSimpleAppointmentQuery(response, params, octxt, zsc, authAcct, mbox, apptFolderIds);
            return response;
        }
        ZimbraQueryResults results = this.doSearch(zsc, octxt, mbox, params);
        try {
            Element response = zsc.createElement(MailConstants.SEARCH_RESPONSE);
            SortBy sb = results.getSortBy();
            response.addAttribute("sortBy", sb.toString());
            ResultsPager pager = ResultsPager.create(results, params);
            response.addAttribute("offset", params.getOffset());
            this.putHits(zsc, octxt, response, pager, false, params);
            Search.putInfo(response, params, results);
            element = response;
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            results.doneWithSearchResults();
            throw throwable;
        }
        results.doneWithSearchResults();
        return element;
    }

    protected ZimbraQueryResults doSearch(ZimbraSoapContext zsc, OperationContext octxt, Mailbox mbox, SearchParams params) throws ServiceException {
        ZimbraQueryResults results;
        try {
            results = mbox.search(zsc.getResponseProtocol(), octxt, params);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IO error", e);
        }
        catch (ParseException e) {
            MailServiceException me = null;
            String message = e.getMessage();
            if (e.code != null) {
                message = e.code;
            }
            if (e.expectedTokenSequences != null) {
                message = "PARSER_ERROR";
            }
            me = e.currentToken != null ? MailServiceException.QUERY_PARSE_ERROR(params.getQueryStr(), e, e.currentToken.image, e.currentToken.beginColumn, message) : MailServiceException.QUERY_PARSE_ERROR(params.getQueryStr(), e, "", -1, message);
            throw me;
        }
        return results;
    }

    protected static void putInfo(Element response, SearchParams params, ZimbraQueryResults results) {
        List<QueryInfo> qinfo = results.getResultInfo();
        if (qinfo.size() > 0 || params.getEstimateSize()) {
            Element qinfoElt = response.addElement("info");
            Element sizeEst = qinfoElt.addElement("sizeEstimate");
            try {
                sizeEst.addAttribute("value", results.estimateResultSize());
            }
            catch (ServiceException ex) {
                // empty catch block
            }
            for (QueryInfo inf : qinfo) {
                inf.toXml(qinfoElt);
            }
        }
    }

    protected Element putHits(ZimbraSoapContext zsc, OperationContext octxt, Element response, ResultsPager pager, boolean includeMailbox, SearchParams params) throws ServiceException {
        int offset = params.getOffset();
        int limit = params.getLimit();
        if (mLog.isDebugEnabled()) {
            mLog.debug("Search results beginning with offset " + offset);
        }
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        int totalNumHits = 0;
        SearchParams.ExpandResults expand = params.getInlineRule();
        if (expand == SearchParams.ExpandResults.HITS) {
            expand = SearchParams.ExpandResults.NONE;
        }
        while (pager.hasNext()) {
            ZimbraHit ch;
            ZimbraHit hit = pager.getNextHit();
            if (totalNumHits >= limit) {
                if (!mLog.isDebugEnabled()) break;
                mLog.debug("Search results limited to " + limit + " hits.");
                break;
            }
            boolean inline = totalNumHits == 0 && expand == SearchParams.ExpandResults.FIRST || expand == SearchParams.ExpandResults.ALL || expand.matches(hit.getParsedItemID());
            boolean addSortField = true;
            Element e = null;
            if (params.getMode() == Mailbox.SearchResultMode.IDS) {
                if (hit instanceof ConversationHit) {
                    e = response.addElement("hit");
                    e.addAttribute("id", ifmt.formatItemId(hit.getItemId()));
                } else {
                    e = response.addElement("hit");
                    e.addAttribute("id", ifmt.formatItemId(hit.getItemId()));
                }
            } else if (hit instanceof ConversationHit) {
                ch = (ConversationHit)hit;
                e = this.addConversationHit((ConversationHit)ch, response, octxt, ifmt, params);
            } else if (hit instanceof MessageHit) {
                MessageHit mh = (MessageHit)hit;
                e = this.addMessageHit(mh, response, octxt, ifmt, inline, params);
            } else if (hit instanceof MessagePartHit) {
                MessagePartHit mph = (MessagePartHit)hit;
                e = this.addMessagePartHit(mph, response);
            } else if (hit instanceof ContactHit) {
                ch = (ContactHit)hit;
                e = ToXML.encodeContact(response, ifmt, ((ContactHit)ch).getContact(), true, null);
            } else if (hit instanceof NoteHit) {
                NoteHit nh = (NoteHit)hit;
                e = ToXML.encodeNote(response, ifmt, nh.getNote());
            } else if (hit instanceof ProxiedHit) {
                ProxiedHit ph = (ProxiedHit)hit;
                response.addElement(ph.getElement().detach());
                addSortField = false;
                ++totalNumHits;
            } else if (hit instanceof CalendarItemHit) {
                CalendarItemHit ah = (CalendarItemHit)hit;
                e = this.addCalendarItemHit(ah, response, zsc, octxt, ifmt, inline, params);
            } else if (hit instanceof DocumentHit) {
                DocumentHit dh = (DocumentHit)hit;
                e = this.addDocumentHit(dh, response, octxt, ifmt);
            } else {
                mLog.error("Got an unknown hit type putting search hits: " + hit);
                continue;
            }
            if (e != null && addSortField) {
                e.addAttribute("sf", hit.getSortField(pager.getSortOrder()).toString());
            }
            if (e != null && includeMailbox) {
                ItemId iid = new ItemId(hit.getAcctIdStr(), hit.getItemId());
                e.addAttribute("id", iid.toString());
            }
            if (e != null) {
                ++totalNumHits;
            }
            if (totalNumHits < limit) continue;
            if (!mLog.isDebugEnabled()) break;
            mLog.debug("Search results limited to " + limit + " hits.");
            break;
        }
        response.addAttribute("more", pager.hasNext());
        return response;
    }

    protected Element addConversationHit(ConversationHit ch, Element response, OperationContext octxt, ItemIdFormatter ifmt, SearchParams params) throws ServiceException {
        if (params.getMode() == Mailbox.SearchResultMode.IDS) {
            Element c = response.addElement("c");
            for (MessageHit mh : ch.getMessageHits()) {
                c.addElement("m").addAttribute("id", ifmt.formatItemId(mh.getItemId()));
            }
            return c;
        }
        Conversation conv = ch.getConversation();
        MessageHit mh1 = ch.getFirstMessageHit();
        Element c = ToXML.encodeConversationSummary(response, ifmt, octxt, conv, mh1 == null ? null : mh1.getMessage(), params.getWantRecipients());
        if (ch.getScore() != 0.0f) {
            c.addAttribute("score", ch.getScore());
        }
        for (MessageHit mh : ch.getMessageHits()) {
            c.addElement("m").addAttribute("id", ifmt.formatItemId(mh.getMessage()));
        }
        return c;
    }

    protected Element addCalendarItemHit(CalendarItemHit ah, Element response, ZimbraSoapContext zsc, OperationContext octxt, ItemIdFormatter ifmt, boolean inline, SearchParams params) throws ServiceException {
        CalendarItem calItem = ah.getCalendarItem();
        Element calElement = null;
        int fields = -1;
        Account acct = Search.getRequestedAccount(zsc);
        GetCalendarItemSummaries.EncodeCalendarItemResult encoded = GetCalendarItemSummaries.encodeCalendarItemInstances(zsc, octxt, calItem, acct, params.getCalItemExpandStart(), params.getCalItemExpandEnd(), true);
        calElement = encoded.element;
        if (calElement != null) {
            response.addElement(encoded.element);
            ToXML.setCalendarItemFields(encoded.element, ifmt, octxt, calItem, fields, false, params.getNeuterImages());
            calElement.addAttribute("cm", true);
            if (ah.getScore() != 0.0f) {
                calElement.addAttribute("score", ah.getScore());
            }
        }
        return calElement;
    }

    protected Element addMessageHit(MessageHit mh, Element response, OperationContext octxt, ItemIdFormatter ifmt, boolean inline, SearchParams params) throws ServiceException {
        Message msg = mh.getMessage();
        if (inline && msg.isUnread() && params.getMarkRead()) {
            try {
                msg.getMailbox().alterTag(octxt, msg.getId(), msg.getType(), -10, false);
            }
            catch (ServiceException e) {
                if (e.getCode().equals("service.PERM_DENIED")) {
                    mLog.info("no permissions to mark message as read (ignored): " + msg.getId());
                }
                mLog.warn((Object)("problem marking message as read (ignored): " + msg.getId()), e);
            }
        }
        Element m = inline ? ToXML.encodeMessageAsMP(response, ifmt, octxt, msg, null, params.getMaxInlinedLength(), params.getWantHtml(), params.getNeuterImages(), params.getInlinedHeaders(), true) : ToXML.encodeMessageSummary(response, ifmt, octxt, msg, params.getWantRecipients());
        if (mh.getScore() != 0.0f) {
            m.addAttribute("score", mh.getScore());
        }
        m.addAttribute("cm", true);
        List<MessagePartHit> parts = mh.getMatchedMimePartNames();
        if (parts != null) {
            for (MessagePartHit mph : parts) {
                String partNameStr = mph.getPartName();
                if (partNameStr.length() <= 0) continue;
                m.addElement("hp").addAttribute("part", partNameStr);
            }
        }
        return m;
    }

    protected Element addMessageMiss(Message msg, Element response, OperationContext octxt, ItemIdFormatter ifmt, boolean inline, SearchParams params) throws ServiceException {
        Element m;
        if (inline && msg.isUnread() && params.getMarkRead()) {
            try {
                msg.getMailbox().alterTag(octxt, msg.getId(), msg.getType(), -10, false);
            }
            catch (ServiceException e) {
                mLog.warn((Object)("problem marking message as read (ignored): " + msg.getId()), e);
            }
        }
        if (inline) {
            m = ToXML.encodeMessageAsMP(response, ifmt, octxt, msg, null, params.getMaxInlinedLength(), params.getWantHtml(), params.getNeuterImages(), null, true);
            if (!msg.getFragment().equals("")) {
                m.addAttribute("fr", msg.getFragment(), Element.Disposition.CONTENT);
            }
        } else {
            m = ToXML.encodeMessageSummary(response, ifmt, octxt, msg, params.getWantRecipients());
        }
        return m;
    }

    protected Element addMessagePartHit(MessagePartHit mph, Element response) throws ServiceException {
        MessageHit mh = mph.getMessageResult();
        Message msg = mh.getMessage();
        Element mp = response.addElement("mp");
        mp.addAttribute("s", msg.getSize());
        mp.addAttribute("d", msg.getDate());
        mp.addAttribute("cid", msg.getConversationId());
        mp.addAttribute("mid", msg.getId());
        mp.addAttribute("ct", mph.getType());
        mp.addAttribute("name", mph.getFilename());
        mp.addAttribute("part", mph.getPartName());
        if (mph.getScore() != 0.0f) {
            mp.addAttribute("score", mph.getScore());
        }
        ToXML.encodeEmail(mp, msg.getSender(), ToXML.EmailType.FROM);
        String subject = msg.getSubject();
        if (subject != null) {
            mp.addAttribute("su", subject, Element.Disposition.CONTENT);
        }
        return mp;
    }

    Element addContactHit(ItemIdFormatter ifmt, Element response, ContactHit ch) throws ServiceException {
        return ToXML.encodeContact(response, ifmt, ch.getContact(), true, null);
    }

    Element addDocumentHit(DocumentHit dh, Element response, OperationContext octxt, ItemIdFormatter ifmt) throws ServiceException {
        if (dh.getItemType() == 8) {
            return ToXML.encodeDocument(response, ifmt, octxt, dh.getDocument());
        }
        if (dh.getItemType() == 14) {
            return ToXML.encodeWiki(response, ifmt, octxt, (WikiItem)dh.getDocument());
        }
        throw ServiceException.UNKNOWN_DOCUMENT("invalid document type " + dh.getItemType(), null);
    }

    Element addNoteHit(ItemIdFormatter ifmt, Element response, NoteHit nh) throws ServiceException {
        return ToXML.encodeNote(response, ifmt, nh.getNote());
    }

    private static List<String> getFolderIdListIfSimpleAppointmentsQuery(SearchParams params) {
        byte[] types = params.getTypes();
        if (types == null || types.length != 1 || types[0] != 11 && types[0] != 15) {
            return null;
        }
        if (params.getCalItemExpandStart() == -1L || params.getCalItemExpandEnd() == -1L) {
            return null;
        }
        if (params.getOffset() != 0) {
            return null;
        }
        SortBy sortBy = params.getSortBy();
        if (sortBy != null && !sortBy.equals(SortBy.NONE)) {
            return null;
        }
        String queryStr = params.getQueryStr();
        if (queryStr == null) {
            queryStr = "";
        }
        queryStr = queryStr.toLowerCase();
        if ((queryStr = Search.removeOuterParens(queryStr)).contains("and")) {
            return null;
        }
        String[] terms = queryStr.split("\\s+or\\s+");
        ArrayList<String> folderIdStrs = new ArrayList<String>();
        for (String term : terms) {
            term = term.trim();
            if (!(term = Search.removeOuterParens(term)).startsWith("inid:")) {
                return null;
            }
            String folderId = term.substring(5);
            if ((folderId = Search.unquote(folderId)).length() <= 0) continue;
            folderIdStrs.add(folderId);
        }
        return folderIdStrs;
    }

    private static String removeOuterParens(String str) {
        int len = str.length();
        if (len > 2 && str.charAt(0) == '(' && str.charAt(len - 1) == ')') {
            str = str.substring(1, len - 1);
        }
        return str;
    }

    private static String unquote(String str) {
        int len = str.length();
        if (len > 2 && str.charAt(0) == '\'' && str.charAt(len - 1) == '\'') {
            str = str.substring(1, len - 1);
        }
        if ((len = str.length()) > 2 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
            str = str.substring(1, len - 1);
        }
        return str;
    }

    private static void runSimpleAppointmentQuery(Element parent, SearchParams params, OperationContext octxt, ZimbraSoapContext zsc, Account authAcct, Mailbox mbox, List<String> folderIdStrs) throws ServiceException {
        byte itemType = 11;
        byte[] types = params.getTypes();
        if (types != null && types.length == 1) {
            itemType = types[0];
        }
        parent.addAttribute("sortBy", params.getSortByStr());
        parent.addAttribute("offset", params.getOffset());
        parent.addAttribute("more", false);
        ArrayList<ItemId> folderIids = new ArrayList<ItemId>(folderIdStrs.size());
        for (String folderIdStr : folderIdStrs) {
            folderIids.add(new ItemId(folderIdStr, zsc));
        }
        Provisioning prov = Provisioning.getInstance();
        MailboxManager mboxMgr = MailboxManager.getInstance();
        Server localServer = prov.getLocalServer();
        Map<Server, Map<String, List<Integer>>> groupedByServer = Search.groupByServer(ItemId.groupFoldersByAccount(octxt, mbox, folderIids));
        if (LC.calendar_cache_enabled.booleanValue()) {
            CalSummaryCache calCache = CalendarCacheManager.getInstance().getSummaryCache();
            long rangeStart = params.getCalItemExpandStart();
            long rangeEnd = params.getCalItemExpandEnd();
            Iterator<Map.Entry<Server, Map<String, List<Integer>>>> serverIter = groupedByServer.entrySet().iterator();
            while (serverIter.hasNext()) {
                Map.Entry<Server, Map<String, List<Integer>>> serverMapEntry = serverIter.next();
                Map<String, List<Integer>> accountFolders = serverMapEntry.getValue();
                Iterator<Map.Entry<String, List<Integer>>> acctIter = accountFolders.entrySet().iterator();
                while (acctIter.hasNext()) {
                    Map.Entry<String, List<Integer>> acctEntry = acctIter.next();
                    String acctId = acctEntry.getKey();
                    List<Integer> folderIds = acctEntry.getValue();
                    ItemIdFormatter ifmt = new ItemIdFormatter(authAcct.getId(), acctId, false);
                    Iterator<Integer> iterFolderId = folderIds.iterator();
                    while (iterFolderId.hasNext()) {
                        int folderId = iterFolderId.next();
                        try {
                            CalSummaryCache.CalendarDataResult result = calCache.getCalendarSummary(octxt, acctId, folderId, itemType, rangeStart, rangeEnd, true);
                            if (result == null) continue;
                            iterFolderId.remove();
                            Search.addCalendarDataToResponse(parent, octxt, zsc, authAcct, ifmt, result.data, result.allowPrivateAccess);
                        }
                        catch (ServiceException e) {
                            String ecode = e.getCode();
                            if (ecode.equals("service.PERM_DENIED")) {
                                ZimbraLog.calendar.warn((Object)("Ignoring permission error during calendar search of folder " + ifmt.formatItemId(folderId)), e);
                            } else if (ecode.equals("mail.NO_SUCH_FOLDER")) {
                                ZimbraLog.calendar.warn("Ignoring deleted calendar folder " + ifmt.formatItemId(folderId));
                            } else {
                                throw e;
                            }
                            iterFolderId.remove();
                        }
                    }
                    if (!folderIds.isEmpty()) continue;
                    acctIter.remove();
                }
                if (!accountFolders.isEmpty()) continue;
                serverIter.remove();
            }
        }
        for (Map.Entry<Server, Map<String, List<Integer>>> serverMapEntry : groupedByServer.entrySet()) {
            Server server = serverMapEntry.getKey();
            Map<String, List<Integer>> accountFolders = serverMapEntry.getValue();
            if (server.equals(localServer)) {
                for (Map.Entry<String, List<Integer>> entry : accountFolders.entrySet()) {
                    String acctId = entry.getKey();
                    List<Integer> folderIds = entry.getValue();
                    if (folderIds.isEmpty()) continue;
                    Account targetAcct = prov.get(Provisioning.AccountBy.id, acctId);
                    if (targetAcct == null) {
                        ZimbraLog.calendar.warn("Skipping unknown account " + acctId + " during calendar search");
                        continue;
                    }
                    Mailbox targetMbox = mboxMgr.getMailboxByAccount(targetAcct);
                    Search.searchLocalAccountCalendars(parent, params, octxt, zsc, authAcct, targetMbox, folderIds, itemType);
                }
                continue;
            }
            Search.searchRemoteAccountCalendars(parent, params, zsc, authAcct, accountFolders);
        }
    }

    private static void addCalendarDataToResponse(Element parent, OperationContext octxt, ZimbraSoapContext zsc, Account authAcct, ItemIdFormatter ifmt, CalendarData calData, boolean allowPrivateAccess) throws ServiceException {
        Iterator<CalendarItemData> itemIter = calData.calendarItemIterator();
        while (itemIter.hasNext()) {
            CalendarItemData calItemData = itemIter.next();
            int numInstances = calItemData.getNumInstances();
            if (numInstances <= 0) continue;
            Element calItemElem = CacheToXML.encodeCalendarItemData(zsc, ifmt, calItemData, allowPrivateAccess, false);
            parent.addElement(calItemElem);
        }
    }

    private static void searchLocalAccountCalendars(Element parent, SearchParams params, OperationContext octxt, ZimbraSoapContext zsc, Account authAcct, Mailbox targetMbox, List<Integer> folderIds, byte itemType) throws ServiceException {
        ItemIdFormatter ifmt = new ItemIdFormatter(authAcct.getId(), targetMbox.getAccountId(), false);
        long rangeStart = params.getCalItemExpandStart();
        long rangeEnd = params.getCalItemExpandEnd();
        for (int folderId : folderIds) {
            try {
                CalSummaryCache.CalendarDataResult result = targetMbox.getCalendarSummaryForRange(octxt, folderId, itemType, rangeStart, rangeEnd);
                if (result == null) continue;
                Search.addCalendarDataToResponse(parent, octxt, zsc, authAcct, ifmt, result.data, result.allowPrivateAccess);
            }
            catch (ServiceException e) {
                String ecode = e.getCode();
                if (ecode.equals("service.PERM_DENIED")) {
                    ZimbraLog.calendar.warn((Object)("Ignoring permission error during calendar search of folder " + ifmt.formatItemId(folderId)), e);
                    continue;
                }
                if (ecode.equals("mail.NO_SUCH_FOLDER")) {
                    ZimbraLog.calendar.warn("Ignoring deleted calendar folder " + ifmt.formatItemId(folderId));
                    continue;
                }
                throw e;
            }
        }
    }

    private static void searchRemoteAccountCalendars(Element parent, SearchParams params, ZimbraSoapContext zsc, Account authAcct, Map<String, List<Integer>> accountFolders) throws ServiceException {
        String nominalTargetAcctId = null;
        StringBuilder queryStr = new StringBuilder();
        for (Map.Entry<String, List<Integer>> entry : accountFolders.entrySet()) {
            String acctId = entry.getKey();
            if (nominalTargetAcctId == null) {
                nominalTargetAcctId = acctId;
            }
            ItemIdFormatter ifmt = new ItemIdFormatter(authAcct.getId(), acctId, false);
            List<Integer> folderIds = entry.getValue();
            Iterator<Object> i$ = folderIds.iterator();
            while (i$.hasNext()) {
                int folderId = i$.next();
                if (queryStr.length() > 0) {
                    queryStr.append(" OR ");
                }
                queryStr.append("inid:\"").append(ifmt.formatItemId(folderId)).append("\"");
            }
        }
        Element.JSONElement req = new Element.JSONElement(MailConstants.SEARCH_REQUEST);
        req.addAttribute("types", params.getTypesStr());
        req.addAttribute("sortBy", params.getSortByStr());
        req.addAttribute("offset", params.getOffset());
        if (params.getLimit() != 0) {
            req.addAttribute("limit", params.getLimit());
        }
        req.addAttribute("calExpandInstStart", params.getCalItemExpandStart());
        req.addAttribute("calExpandInstEnd", params.getCalItemExpandEnd());
        ((Element)req).addAttribute("query", queryStr.toString(), Element.Disposition.CONTENT);
        Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, nominalTargetAcctId);
        ZMailbox.Options zoptions = new ZMailbox.Options(zsc.getRawAuthToken(), AccountUtil.getSoapUri(target));
        zoptions.setTargetAccount(nominalTargetAcctId);
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        zoptions.setNoSession(true);
        zoptions.setRequestProtocol(SoapProtocol.SoapJS);
        zoptions.setResponseProtocol(SoapProtocol.SoapJS);
        ZMailbox zmbx = ZMailbox.getMailbox(zoptions);
        Element resp = zmbx.invoke(req);
        for (Element hit : resp.listElements()) {
            hit.detach();
            parent.addElement(hit);
        }
    }

    static Map<Server, Map<String, List<Integer>>> groupByServer(Map<String, List<Integer>> acctFolders) throws ServiceException {
        HashMap<Server, Map<String, List<Integer>>> groupedByServer = new HashMap<Server, Map<String, List<Integer>>>();
        Provisioning prov = Provisioning.getInstance();
        for (Map.Entry<String, List<Integer>> entry : acctFolders.entrySet()) {
            String acctId = entry.getKey();
            List<Integer> folderIds = entry.getValue();
            Account acct = prov.get(Provisioning.AccountBy.id, acctId);
            if (acct == null) {
                ZimbraLog.calendar.warn("Skipping unknown account " + acctId + " during calendar search");
                continue;
            }
            Server server = prov.getServer(acct);
            if (server == null) {
                ZimbraLog.calendar.warn("Skipping account " + acctId + " during calendar search because its home server is unknown");
                continue;
            }
            HashMap<String, List<Integer>> map = (HashMap<String, List<Integer>>)groupedByServer.get(server);
            if (map == null) {
                map = new HashMap<String, List<Integer>>();
                groupedByServer.put(server, map);
            }
            map.put(acctId, folderIds);
        }
        return groupedByServer;
    }
}

