/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.cs.service.mail.ItemActionHelper;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.mail.SendMsg;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveDraft
extends MailDocumentHandler {
    private static final String[] TARGET_DRAFT_PATH = new String[]{"m", "id"};
    private static final String[] TARGET_FOLDER_PATH = new String[]{"m", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return SaveDraft.getXPath(request, TARGET_DRAFT_PATH) != null ? TARGET_DRAFT_PATH : TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return SaveDraft.getXPath(request, TARGET_DRAFT_PATH) == null;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Message msg;
        ZimbraSoapContext zsc = SaveDraft.getZimbraSoapContext(context);
        Mailbox mbox = SaveDraft.getRequestedMailbox(zsc);
        OperationContext octxt = SaveDraft.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element msgElem = request.getElement("m");
        int id = (int)msgElem.getAttributeLong("id", -1L);
        String originalId = msgElem.getAttribute("origid", null);
        ItemId iidOrigid = originalId == null ? null : new ItemId(originalId, zsc);
        String replyType = msgElem.getAttribute("rt", null);
        String identity = msgElem.getAttribute("idnt", null);
        String account = msgElem.getAttribute("forAcct", null);
        String folderId = msgElem.getAttribute("l", null);
        ItemId iidFolder = new ItemId(folderId == null ? "-1" : folderId, zsc);
        if (!iidFolder.belongsTo(mbox)) {
            throw ServiceException.INVALID_REQUEST("cannot move item between mailboxes", null);
        }
        if (folderId != null && iidFolder.getId() <= 0) {
            throw MailServiceException.NO_SUCH_FOLDER(iidFolder.getId());
        }
        String flags = msgElem.getAttribute("f", null);
        String tags = msgElem.getAttribute("t", null);
        MailItem.Color color = ItemAction.getColor(msgElem);
        String attachment = msgElem.getAttribute("aid", null);
        ParseMimeMessage.MimeMessageData mimeData = new ParseMimeMessage.MimeMessageData();
        MimeMessage mm = attachment != null ? SendMsg.parseUploadedMessage(zsc, attachment, mimeData) : ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, null, mimeData);
        long date = System.currentTimeMillis();
        try {
            Date d = new Date();
            mm.setSentDate(d);
            date = d.getTime();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            mm.saveChanges();
        }
        catch (MessagingException me) {
            throw ServiceException.FAILURE("completing MIME message object", me);
        }
        ParsedMessage pm = new ParsedMessage(mm, date, mbox.attachmentsIndexingEnabled());
        try {
            String origid = iidOrigid == null ? null : iidOrigid.toString(account == null ? mbox.getAccountId() : account);
            msg = mbox.saveDraft(octxt, pm, id, origid, replyType, identity, account);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException while saving draft", e);
        }
        if (mimeData.uploads != null) {
            FileUploadServlet.deleteUploads(mimeData.uploads);
        }
        if (folderId != null || flags != null || tags != null || color != null) {
            try {
                ItemActionHelper.UPDATE(octxt, mbox, zsc.getResponseProtocol(), Arrays.asList(msg.getId()), (byte)5, null, null, iidFolder, flags, tags, color);
                msg = mbox.getMessageById(octxt, msg.getId());
            }
            catch (ServiceException e) {
                ZimbraLog.soap.warn((Object)("error setting metadata for draft " + msg.getId() + "; skipping that operation"), e);
            }
        }
        Element response = zsc.createElement(MailConstants.SAVE_DRAFT_RESPONSE);
        ToXML.encodeMessageAsMP(response, ifmt, octxt, msg, null, -1, true, true, null, true);
        return response;
    }
}

