/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.service.mail.GrantPermission;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevokePermission
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = RevokePermission.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = RevokePermission.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        for (Element eACE : request.listElements("ace")) {
            ZimbraACE ace = GrantPermission.handleACE(eACE, zsc, false);
            aces.add(ace);
        }
        List<ZimbraACE> revoked = ACLUtil.revokeRight(Provisioning.getInstance(), account, aces);
        Element response = zsc.createElement(MailConstants.REVOKE_PERMISSION_RESPONSE);
        if (aces != null) {
            for (ZimbraACE ace : revoked) {
                ToXML.encodeACE(response, ace);
            }
        }
        return response;
    }
}

