/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.mailbox.DeliveryOptions;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.util.JMSession;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAttachments
extends MailDocumentHandler {
    private static final String[] TARGET_MSG_PATH = new String[]{"m", "id"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_MSG_PATH;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RemoveAttachments.getZimbraSoapContext(context);
        Mailbox mbox = RemoveAttachments.getRequestedMailbox(zsc);
        OperationContext octxt = RemoveAttachments.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element msgElem = request.getElement("m");
        ItemId iid = new ItemId(msgElem.getAttribute("id"), zsc);
        Collection<String> parts = RemoveAttachments.sortPartIds(msgElem.getAttribute("part"));
        Message msg = mbox.getMessageById(octxt, iid.getId());
        BlobInputStream is = null;
        try {
            block8: {
                try {
                    Blob blob = msg.getBlob().getLocalBlob();
                    is = new BlobInputStream(blob);
                    Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession(), is);
                    for (String part : parts) {
                        RemoveAttachments.stripPart(mm, part);
                    }
                    mm.saveChanges();
                    ParsedMessage pm = new ParsedMessage(mm, msg.getDate(), mbox.attachmentsIndexingEnabled());
                    if (msg.isDraft()) {
                        msg = mbox.saveDraft(octxt, pm, msg.getId());
                        break block8;
                    }
                    DeliveryOptions dopt = new DeliveryOptions();
                    dopt.setFolderId(msg.getFolderId()).setNoICal(true);
                    dopt.setFlags(msg.getFlagBitmask()).setTagString(msg.getTagString());
                    if (msg.getConversationId() > 0) {
                        dopt.setConversationId(msg.getConversationId());
                    }
                    msg = mbox.addMessage(octxt, pm, dopt);
                    mbox.delete(octxt, iid.getId(), (byte)5);
                }
                catch (IOException ioe) {
                    throw ServiceException.FAILURE("error reading existing message blob", ioe);
                }
                catch (MessagingException me) {
                    throw ServiceException.FAILURE("error reading existing message blob", me);
                }
            }
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        Element response = zsc.createElement(MailConstants.REMOVE_ATTACHMENTS_RESPONSE);
        ToXML.encodeMessageAsMP(response, ifmt, octxt, msg, null, -1, true, true, null, true);
        return response;
    }

    private static Collection<String> sortPartIds(String partnames) throws ServiceException {
        String[] parts = partnames.split(",");
        if (parts.length == 1 && !parts[0].trim().equals("")) {
            return Arrays.asList(parts);
        }
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        TreeSet<String> sorted = new TreeSet<String>(new PartIdComparator());
        for (String part : parts) {
            try {
                if (part.trim().equals("")) continue;
                sorted.add(part);
            }
            catch (NumberFormatException nfe) {
                throw ServiceException.INVALID_REQUEST("invalid part id: " + part, null);
            }
        }
        return sorted;
    }

    private static void stripPart(MimeMessage mm, String part) throws IOException, MessagingException, ServiceException {
        block10: {
            String subpart;
            MimeMessage mp = mm;
            int dot = (part = part.trim()).lastIndexOf(46);
            if (dot > 0) {
                mp = Mime.getMimePart((MimePart)mm, part.substring(0, dot));
            }
            if (mp == null) {
                throw MailServiceException.NO_SUCH_PART(part);
            }
            String string = subpart = dot > 0 ? part.substring(dot + 1) : part;
            if (subpart.equalsIgnoreCase("TEXT")) {
                if (!(mp instanceof MimeMessage)) {
                    throw MailServiceException.NO_SUCH_PART(part);
                }
                mp.setText("");
            } else {
                try {
                    int partid = Integer.parseInt(subpart);
                    if (Mime.getContentType((MimePart)mp, "text/plain").startsWith("multipart/")) {
                        MimeMultipart mmp = Mime.getMultipartContent((MimePart)mp, mp.getContentType());
                        if (partid <= 0 || partid > mmp.getCount()) {
                            throw MailServiceException.NO_SUCH_PART(part);
                        }
                        mmp.removeBodyPart(partid - 1);
                        break block10;
                    }
                    if (mp instanceof MimeMessage && partid == 1) {
                        mp.setText("");
                        break block10;
                    }
                    throw MailServiceException.NO_SUCH_PART(part);
                }
                catch (NumberFormatException nfe) {
                    throw ServiceException.INVALID_REQUEST("invalid part id: " + part, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws ServiceException {
        System.out.println(RemoveAttachments.sortPartIds("1"));
        System.out.println(RemoveAttachments.sortPartIds("1,2,3"));
        System.out.println(RemoveAttachments.sortPartIds("1,1,2,1"));
        System.out.println(RemoveAttachments.sortPartIds("1.1,TEXT,1.TEXT,10,2.1"));
        FileInputStream is = null;
        try {
            try {
                File file = new File(args[0]);
                is = new FileInputStream(file);
                Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession(), is);
                RemoveAttachments.stripPart(mm, "1.2");
                mm.saveChanges();
                mm.writeTo(System.out);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var5_6 = null;
                ByteUtil.closeStream(is);
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartIdComparator
    implements Comparator<String> {
        PartIdComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equalsIgnoreCase(o2)) {
                return 0;
            }
            if (o1.equals("")) {
                return 1;
            }
            if (o2.equals("")) {
                return -1;
            }
            String[] parts1 = o1.split("\\.");
            String[] parts2 = o2.split("\\.");
            for (int depth = 0; depth < parts1.length && depth < parts2.length; ++depth) {
                String subpart1 = parts1[depth];
                String subpart2 = parts2[depth];
                if (subpart1.equalsIgnoreCase("TEXT") && depth == parts1.length - 1) {
                    return 1;
                }
                if (subpart2.equalsIgnoreCase("TEXT") && depth == parts2.length - 1) {
                    return -1;
                }
                int delta = Integer.valueOf(subpart2) - Integer.valueOf(subpart1);
                if (delta == 0) continue;
                return delta;
            }
            return parts2.length - parts1.length;
        }
    }
}

