/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.DataSourceWrapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ExceptionToString;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.Fragment;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.BlobDataSource;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.UploadDataSource;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.formatter.VCard;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.mail.UploadScanner;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.JMSession;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseMimeMessage {
    static Log mLog = LogFactory.getLog(ParseMimeMessage.class);
    private static final long DEFAULT_MAX_SIZE = 0xA00000L;
    static InviteParser NO_INV_ALLOWED_PARSER = new InviteParser(){

        public InviteParserResult parseInviteElement(ZimbraSoapContext zsc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            throw ServiceException.INVALID_REQUEST("No <inv> element allowed for this request", null);
        }
    };
    private static final Map<String, String> FETCH_CONTACT_PARAMS = new HashMap<String, String>(3);

    public static MimeMessage importMsgSoap(Element msgElem) throws ServiceException {
        byte[] content;
        assert (msgElem.getName().equals("m"));
        Element contentElement = msgElem.getElement("content");
        try {
            content = contentElement.getText().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw ServiceException.FAILURE("encoding error", e);
        }
        long maxSize = Provisioning.getInstance().getConfig().getLongAttr("zimbraMtaMaxMessageSize", 0xA00000L);
        if ((long)content.length > maxSize) {
            throw ServiceException.INVALID_REQUEST("inline message too large", null);
        }
        ByteArrayInputStream messageStream = new ByteArrayInputStream(content);
        try {
            return new Mime.FixedMimeMessage(JMSession.getSession(), messageStream);
        }
        catch (MessagingException me) {
            mLog.warn(ExceptionToString.ToString((Exception)((Object)me)));
            throw ServiceException.FAILURE("MessagingExecption", me);
        }
    }

    public static MimeMessage parseMimeMsgSoap(ZimbraSoapContext zsc, OperationContext octxt, Mailbox mbox, Element msgElem, MimeBodyPart[] additionalParts, MimeMessageData out) throws ServiceException {
        return ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, additionalParts, NO_INV_ALLOWED_PARSER, out);
    }

    public static String getTextPlainContent(Element elem) {
        return ParseMimeMessage.getFirstContentByType(elem, "text/plain");
    }

    public static String getTextHtmlContent(Element elem) {
        return ParseMimeMessage.getFirstContentByType(elem, "text/html");
    }

    private static String getFirstContentByType(Element elem, String contentType) {
        if (elem == null) {
            return null;
        }
        if ("m".equals(elem.getName()) && (elem = elem.getOptionalElement("mp")) == null) {
            return null;
        }
        String type = elem.getAttribute("ct", contentType).trim().toLowerCase();
        if (type.equals(contentType)) {
            return elem.getAttribute("content", null);
        }
        if (type.startsWith("multipart/")) {
            for (Element childElem : elem.listElements("mp")) {
                String text = ParseMimeMessage.getFirstContentByType(childElem, contentType);
                if (text == null) continue;
                return text;
            }
        }
        return null;
    }

    public static MimeMessage parseMimeMsgSoap(ZimbraSoapContext zsc, OperationContext octxt, Mailbox mbox, Element msgElem, MimeBodyPart[] additionalParts, InviteParser inviteParser, MimeMessageData out) throws ServiceException {
        assert (msgElem.getName().equals("m"));
        Account target = DocumentHandler.getRequestedAccount(zsc);
        ParseMessageContext ctxt = new ParseMessageContext();
        ctxt.out = out;
        ctxt.zsc = zsc;
        ctxt.octxt = octxt;
        ctxt.mbox = mbox;
        ctxt.use2231 = target.getBooleanAttr("zimbraPrefUseRfc2231", false);
        ctxt.defaultCharset = target.getAttr("zimbraPrefMailDefaultCharset", "utf-8");
        if (ctxt.defaultCharset.equals("")) {
            ctxt.defaultCharset = "utf-8";
        }
        try {
            String flagStr;
            boolean isMultipart;
            Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession());
            MimeMultipart mmp = null;
            Element partElem = msgElem.getOptionalElement("mp");
            Element attachElem = msgElem.getOptionalElement("attach");
            Element inviteElem = msgElem.getOptionalElement("inv");
            boolean hasContent = partElem != null || inviteElem != null || additionalParts != null;
            boolean bl = isMultipart = attachElem != null;
            if (isMultipart) {
                mmp = new MimeMultipart("mixed");
                mm.setContent((Multipart)mmp);
            }
            MimeBodyPart[] alternatives = null;
            if (inviteElem != null) {
                int additionalLen = 0;
                if (additionalParts != null) {
                    additionalLen += additionalParts.length;
                }
                alternatives = new MimeBodyPart[additionalLen + 1];
                int curAltPart = 0;
                InviteParserResult result = inviteParser.parse(zsc, octxt, mbox.getAccount(), inviteElem);
                if (partElem != null && result.mCal != null) {
                    String desc = ParseMimeMessage.getTextPlainContent(partElem);
                    String html = ParseMimeMessage.getTextHtmlContent(partElem);
                    result.mCal.addDescription(desc, html);
                    if (result.mInvite != null && (desc != null && desc.length() > 0 || html != null && html.length() > 0)) {
                        result.mInvite.setDescription(desc, html);
                        if (desc != null && desc.length() > 0) {
                            result.mInvite.setFragment(Fragment.getFragment(desc, true));
                        }
                    }
                }
                MimeBodyPart mbp = CalendarMailSender.makeICalIntoMimePart(result.mUid, result.mCal);
                alternatives[curAltPart++] = mbp;
                if (additionalParts != null) {
                    for (int i = 0; i < additionalParts.length; ++i) {
                        alternatives[curAltPart++] = additionalParts[i];
                    }
                }
            } else {
                alternatives = additionalParts;
            }
            if (hasContent) {
                ParseMimeMessage.setContent(mm, mmp, partElem != null ? partElem : inviteElem, alternatives, ctxt);
            }
            if (isMultipart && attachElem != null) {
                ParseMimeMessage.handleAttachments(attachElem, mmp, ctxt, null);
            }
            MessageAddresses maddrs = new MessageAddresses(out.newContacts);
            for (Element elem : msgElem.listElements()) {
                String eName = elem.getName();
                if (eName.equals("attach") || eName.equals("mp")) continue;
                if (eName.equals("e")) {
                    maddrs.add(elem, ctxt.defaultCharset);
                    continue;
                }
                if (eName.equals("irt") || eName.equals("su")) continue;
                if (eName.equals("fr")) {
                    mLog.debug("Ignoring message fragment data");
                    continue;
                }
                if (eName.equals("inv") || eName.equals("tz")) continue;
                mLog.warn("unsupported child element '" + elem.getName() + "' under parent " + msgElem.getName());
            }
            String subject = msgElem.getAttribute("su", "");
            mm.setSubject(subject, StringUtil.checkCharset(subject, ctxt.defaultCharset));
            String irt = msgElem.getAttribute("irt", null);
            if (irt != null) {
                mm.setHeader("In-Reply-To", irt);
            }
            if (!maddrs.isEmpty()) {
                ParseMimeMessage.addAddressHeaders(mm, maddrs, ctxt.defaultCharset);
            }
            if (!hasContent && !isMultipart) {
                mm.setText("", "us-ascii");
            }
            if ((flagStr = msgElem.getAttribute("f", "")).indexOf(Flag.getAbbreviation(-11)) != -1) {
                mm.addHeader("X-Priority", "1");
                mm.addHeader("Importance", "high");
            } else if (flagStr.indexOf(Flag.getAbbreviation(-12)) != -1) {
                mm.addHeader("X-Priority", "5");
                mm.addHeader("Importance", "low");
            }
            mm.saveChanges();
            if (mLog.isDebugEnabled()) {
                ParseMimeMessage.dumpMessage(mm);
            }
            return mm;
        }
        catch (UnsupportedEncodingException encEx) {
            String excepStr = ExceptionToString.ToString(encEx);
            mLog.warn(excepStr);
            throw ServiceException.FAILURE("UnsupportedEncodingExecption", encEx);
        }
        catch (SendFailedException sfe) {
            MailSender.SafeSendFailedException ssfe = new MailSender.SafeSendFailedException(sfe);
            String excepStr = ExceptionToString.ToString((Exception)((Object)ssfe));
            mLog.warn(excepStr);
            throw ServiceException.FAILURE("SendFailure", (Throwable)((Object)ssfe));
        }
        catch (MessagingException me) {
            String excepStr = ExceptionToString.ToString((Exception)((Object)me));
            mLog.warn(excepStr);
            throw ServiceException.FAILURE("MessagingExecption", me);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw ServiceException.FAILURE("IOExecption", e);
        }
    }

    private static void handleAttachments(Element attachElem, MimeMultipart mmp, ParseMessageContext ctxt, String contentID) throws ServiceException, MessagingException, IOException {
        String attachIds;
        if (contentID != null) {
            contentID = '<' + contentID + '>';
        }
        if ((attachIds = attachElem.getAttribute("aid", null)) != null) {
            for (String uploadId : attachIds.split(",")) {
                FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(ctxt.zsc.getAuthtokenAccountId(), uploadId, ctxt.zsc.getAuthToken());
                if (up == null) {
                    throw MailServiceException.NO_SUCH_UPLOAD(uploadId);
                }
                ParseMimeMessage.attachUpload(mmp, up, contentID, ctxt, null);
                ctxt.out.addUpload(up);
            }
        }
        for (Element elem : attachElem.listElements()) {
            String attachType = elem.getName();
            boolean optional = elem.getAttributeBool("optional", false);
            try {
                ItemId iid;
                if (attachType.equals("mp")) {
                    iid = new ItemId(elem.getAttribute("mid"), ctxt.zsc);
                    String part = elem.getAttribute("part");
                    ParseMimeMessage.attachPart(mmp, iid, part, contentID, ctxt);
                    continue;
                }
                if (attachType.equals("m")) {
                    iid = new ItemId(elem.getAttribute("id"), ctxt.zsc);
                    ParseMimeMessage.attachMessage(mmp, iid, contentID, ctxt);
                    continue;
                }
                if (attachType.equals("cn")) {
                    iid = new ItemId(elem.getAttribute("id"), ctxt.zsc);
                    ParseMimeMessage.attachContact(mmp, iid, contentID, ctxt);
                    continue;
                }
                if (!attachType.equals("doc")) continue;
                String path = elem.getAttribute("path", null);
                if (path != null) {
                    ParseMimeMessage.attachDocument(mmp, path, contentID, ctxt);
                    continue;
                }
                ItemId iid2 = new ItemId(elem.getAttribute("id"), ctxt.zsc);
                ParseMimeMessage.attachDocument(mmp, iid2, contentID, ctxt);
            }
            catch (MailServiceException.NoSuchItemException nsie) {
                if (!optional) {
                    throw nsie;
                }
                ZimbraLog.soap.info("skipping missing optional attachment: " + elem);
            }
        }
    }

    private static void setContent(MimeMessage mm, MimeMultipart mmp, Element elem, MimeBodyPart[] alternatives, ParseMessageContext ctxt) throws MessagingException, ServiceException, IOException {
        String type = elem.getAttribute("ct", "text/plain").trim();
        ContentType ctype = new ContentType(type, ctxt.use2231);
        if (ctype.getPrimaryType().equals("multipart")) {
            ParseMimeMessage.setMultipartContent(ctype.getSubType(), mm, mmp, elem, alternatives, ctxt);
            return;
        }
        Element inline = elem.getOptionalElement("attach");
        if (inline != null) {
            ParseMimeMessage.handleAttachments(inline, mmp, ctxt, elem.getAttribute("ci", null));
            return;
        }
        if (alternatives != null) {
            MimeMultipart mmpNew = new MimeMultipart("alternative");
            if (mmp == null) {
                mm.setContent((Multipart)mmpNew);
            } else {
                MimeBodyPart mbpWrapper = new MimeBodyPart();
                mbpWrapper.setContent((Multipart)mmpNew);
                mmp.addBodyPart((BodyPart)mbpWrapper);
            }
            mmp = mmpNew;
        }
        String data = elem.getAttribute("content", "");
        ctxt.incrementSize("message body", data.getBytes().length);
        String charset = StringUtil.checkCharset(data, ctxt.defaultCharset);
        ctype.setCharset(charset).setParameter("charset", charset);
        if (mmp != null) {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setText(data, charset);
            mbp.setHeader("Content-Type", ctype.toString());
            mmp.addBodyPart((BodyPart)mbp);
        } else {
            mm.setText(data, charset);
            mm.setHeader("Content-Type", ctype.toString());
        }
        if (alternatives != null) {
            for (int i = 0; i < alternatives.length; ++i) {
                ctxt.incrementSize("alternative body", alternatives[i].getSize());
                mmp.addBodyPart((BodyPart)alternatives[i]);
            }
        }
    }

    private static void setMultipartContent(String subType, MimeMessage mm, MimeMultipart mmp, Element elem, MimeBodyPart[] alternatives, ParseMessageContext ctxt) throws MessagingException, ServiceException, IOException {
        block9: {
            block8: {
                if (alternatives != null && !subType.equals("alternative")) break block8;
                MimeMultipart mmpNew = new MimeMultipart(subType);
                if (mmp == null) {
                    mm.setContent((Multipart)mmpNew);
                } else {
                    MimeBodyPart mbpWrapper = new MimeBodyPart();
                    mbpWrapper.setContent((Multipart)mmpNew);
                    mmp.addBodyPart((BodyPart)mbpWrapper);
                }
                for (Element subpart : elem.listElements()) {
                    ParseMimeMessage.setContent(mm, mmpNew, subpart, null, ctxt);
                }
                if (alternatives == null) break block9;
                for (int i = 0; i < alternatives.length; ++i) {
                    ctxt.incrementSize("alternative", alternatives[i].getSize());
                    mmpNew.addBodyPart((BodyPart)alternatives[i]);
                }
                break block9;
            }
            MimeMultipart mmpNew = new MimeMultipart("alternative");
            if (mmp == null) {
                mm.setContent((Multipart)mmpNew);
            } else {
                MimeBodyPart mbpWrapper = new MimeBodyPart();
                mbpWrapper.setContent((Multipart)mmpNew);
                mmp.addBodyPart((BodyPart)mbpWrapper);
            }
            ParseMimeMessage.setContent(mm, mmpNew, elem, null, ctxt);
            if (alternatives != null) {
                for (int i = 0; i < alternatives.length; ++i) {
                    ctxt.incrementSize("alternative", alternatives[i].getSize());
                    mmpNew.addBodyPart((BodyPart)alternatives[i]);
                }
            }
        }
    }

    private static void attachUpload(MimeMultipart mmp, FileUploadServlet.Upload up, String contentID, ParseMessageContext ctxt, ContentType ctypeOverride) throws ServiceException, MessagingException {
        ctxt.incrementSize("upload " + up.getName(), (long)((double)up.getSize() * 1.33));
        StringBuffer info = new StringBuffer();
        UploadScanner.Result result = UploadScanner.accept(up, info);
        if (result == UploadScanner.REJECT) {
            throw MailServiceException.UPLOAD_REJECTED(up.getName(), info.toString());
        }
        if (result == UploadScanner.ERROR) {
            throw MailServiceException.SCAN_ERROR(up.getName());
        }
        String filename = up.getName();
        MimeBodyPart mbp = new MimeBodyPart();
        UploadDataSource uds = new UploadDataSource(up);
        if (ctypeOverride != null && !ctypeOverride.equals("")) {
            uds.setContentType(ctypeOverride);
        }
        mbp.setDataHandler(new DataHandler(uds));
        ContentType ctype = ctypeOverride;
        ContentDisposition cdisp = new ContentDisposition("attachment", ctxt.use2231);
        if (ctype == null) {
            ctype = new ContentType(up.getContentType() == null ? "application/octet-stream" : up.getContentType()).setParameter("name", filename);
            cdisp.setParameter("filename", filename);
        }
        mbp.setHeader("Content-Type", ctype.setCharset(ctxt.defaultCharset).toString());
        mbp.setHeader("Content-Disposition", cdisp.setCharset(ctxt.defaultCharset).toString());
        mbp.setContentID(contentID);
        mmp.addBodyPart((BodyPart)mbp);
    }

    private static void attachRemoteItem(MimeMultipart mmp, ItemId iid, String contentID, ParseMessageContext ctxt, Map<String, String> params, ContentType ctypeOverride) throws ServiceException, MessagingException {
        try {
            FileUploadServlet.Upload up = UserServlet.getRemoteResourceAsUpload(ctxt.zsc.getAuthToken(), iid, params);
            ParseMimeMessage.attachUpload(mmp, up, contentID, ctxt, ctypeOverride);
            ctxt.out.addFetch(up);
            return;
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("can't serialize remote item", ioe);
        }
    }

    private static void attachMessage(MimeMultipart mmp, ItemId iid, String contentID, ParseMessageContext ctxt) throws MessagingException, ServiceException {
        if (!iid.isLocal()) {
            ParseMimeMessage.attachRemoteItem(mmp, iid, contentID, ctxt, Collections.EMPTY_MAP, new ContentType("message/rfc822"));
            return;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(iid.getAccountId());
        Message msg = mbox.getMessageById(ctxt.octxt, iid.getId());
        ctxt.incrementSize("attached message", msg.getSize());
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler(new BlobDataSource(msg.getBlob())));
        mbp.setHeader("Content-Type", "message/rfc822");
        mbp.setHeader("Content-Disposition", "attachment");
        mbp.setContentID(contentID);
        mmp.addBodyPart((BodyPart)mbp);
    }

    private static void attachContact(MimeMultipart mmp, ItemId iid, String contentID, ParseMessageContext ctxt) throws MessagingException, ServiceException {
        if (!iid.isLocal()) {
            ParseMimeMessage.attachRemoteItem(mmp, iid, contentID, ctxt, FETCH_CONTACT_PARAMS, null);
            return;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(iid.getAccountId());
        VCard vcf = VCard.formatContact(mbox.getContactById(ctxt.octxt, iid.getId()));
        ctxt.incrementSize("contact", vcf.formatted.length());
        String filename = vcf.fn + ".vcf";
        String charset = StringUtil.checkCharset(vcf.formatted, ctxt.defaultCharset);
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setText(vcf.formatted, charset);
        mbp.setHeader("Content-Type", new ContentType("text/x-vcard", ctxt.use2231).setCharset(ctxt.defaultCharset).setParameter("name", filename).setParameter("charset", charset).toString());
        mbp.setHeader("Content-Disposition", new ContentDisposition("attachment", ctxt.use2231).setCharset(ctxt.defaultCharset).setParameter("filename", filename).toString());
        mbp.setContentID(contentID);
        mmp.addBodyPart((BodyPart)mbp);
    }

    private static void attachDocument(MimeMultipart mmp, ItemId iid, String contentID, ParseMessageContext ctxt) throws MessagingException, ServiceException {
        if (!iid.isLocal()) {
            ParseMimeMessage.attachRemoteItem(mmp, iid, contentID, ctxt, Collections.EMPTY_MAP, null);
            return;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(iid.getAccountId());
        Document doc = mbox.getDocumentById(ctxt.octxt, iid.getId());
        ParseMimeMessage.attachDocument(mmp, doc, contentID, ctxt);
    }

    private static void attachDocument(MimeMultipart mmp, String path, String contentID, ParseMessageContext ctxt) throws MessagingException, ServiceException {
        MailItem item = null;
        try {
            item = ctxt.mbox.getItemByPath(ctxt.octxt, path);
        }
        catch (MailServiceException.NoSuchItemException nsie) {
            // empty catch block
        }
        if (item == null) {
            Pair<Folder, String> match = ctxt.mbox.getFolderByPathLongestMatch(ctxt.octxt, 1, path);
            if (!(match.getFirst() instanceof Mountpoint)) {
                throw MailServiceException.NO_SUCH_DOC(path);
            }
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("name", match.getSecond());
            ParseMimeMessage.attachRemoteItem(mmp, ((Mountpoint)match.getFirst()).getTarget(), contentID, ctxt, params, null);
            return;
        }
        if (!(item instanceof Document)) {
            throw MailServiceException.NO_SUCH_DOC(path);
        }
        ParseMimeMessage.attachDocument(mmp, (Document)item, contentID, ctxt);
    }

    private static void attachDocument(MimeMultipart mmp, Document doc, String contentID, ParseMessageContext ctxt) throws MessagingException, ServiceException {
        ctxt.incrementSize("attached document", (long)((double)doc.getSize() * 1.33));
        String ct = doc.getContentType();
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler(new BlobDataSource(doc.getBlob(), ct)));
        mbp.setHeader("Content-Type", new ContentType(ct).setParameter("name", doc.getName()).setCharset(ctxt.defaultCharset).toString());
        mbp.setHeader("Content-Disposition", new ContentDisposition("attachment").setParameter("filename", doc.getName()).toString());
        mbp.setContentID(contentID);
        mmp.addBodyPart((BodyPart)mbp);
    }

    private static void attachPart(MimeMultipart mmp, ItemId iid, String part, String contentID, ParseMessageContext ctxt) throws IOException, MessagingException, ServiceException {
        if (!iid.isLocal()) {
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("part", part);
            ParseMimeMessage.attachRemoteItem(mmp, iid, contentID, ctxt, params, null);
            return;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(iid.getAccountId());
        MimeMessage mm = iid.hasSubpart() ? mbox.getCalendarItemById(ctxt.octxt, iid.getId()).getSubpartMessage(iid.getSubpartId()) : mbox.getMessageById(ctxt.octxt, iid.getId()).getMimeMessage();
        MimePart mp = Mime.getMimePart((MimePart)mm, part);
        if (mp == null) {
            throw MailServiceException.NO_SUCH_PART(part);
        }
        String filename = Mime.getFilename(mp);
        ctxt.incrementSize("part " + filename, mp.getSize());
        MimeBodyPart mbp = new MimeBodyPart();
        String ctype = mp.getContentType();
        if (ctype != null) {
            String contentType = new ContentType(ctype, ctxt.use2231).setCharset(ctxt.defaultCharset).setParameter("name", filename).toString();
            DataHandler originalHandler = mp.getDataHandler();
            DataSourceWrapper wrapper = new DataSourceWrapper(originalHandler.getDataSource());
            wrapper.setContentType(contentType);
            mbp.setDataHandler(new DataHandler(wrapper));
            mbp.setHeader("Content-Type", contentType);
        } else {
            mbp.setDataHandler(mp.getDataHandler());
        }
        mbp.setHeader("Content-Disposition", new ContentDisposition("attachment", ctxt.use2231).setCharset(ctxt.defaultCharset).setParameter("filename", filename).toString());
        String desc = mp.getDescription();
        if (desc != null) {
            mbp.setHeader("Content-Description", desc);
        }
        mbp.setContentID(contentID);
        mmp.addBodyPart((BodyPart)mbp);
    }

    private static void addAddressHeaders(MimeMessage mm, MessageAddresses maddrs, String defaultCharset) throws MessagingException {
        Object[] addrs = maddrs.get(ToXML.EmailType.TO.toString());
        if (addrs != null && addrs.length > 0) {
            mm.addRecipients(Message.RecipientType.TO, (Address[])addrs);
            mLog.debug("\t\tTO: " + Arrays.toString(addrs));
        }
        if ((addrs = maddrs.get(ToXML.EmailType.CC.toString())) != null && addrs.length > 0) {
            mm.addRecipients(Message.RecipientType.CC, (Address[])addrs);
            mLog.debug("\t\tCC: " + Arrays.toString(addrs));
        }
        if ((addrs = maddrs.get(ToXML.EmailType.BCC.toString())) != null && addrs.length > 0) {
            mm.addRecipients(Message.RecipientType.BCC, (Address[])addrs);
            mLog.debug("\t\tBCC: " + Arrays.toString(addrs));
        }
        if ((addrs = maddrs.get(ToXML.EmailType.FROM.toString())) != null && addrs.length == 1) {
            mm.setFrom((Address)addrs[0]);
            mLog.debug("\t\tFrom: " + addrs[0]);
        }
        if ((addrs = maddrs.get(ToXML.EmailType.SENDER.toString())) != null && addrs.length == 1) {
            mm.setSender((Address)addrs[0]);
            mLog.debug("\t\tSender: " + addrs[0]);
        }
        if ((addrs = maddrs.get(ToXML.EmailType.REPLY_TO.toString())) != null && addrs.length > 0) {
            mm.setReplyTo((Address[])addrs);
            mLog.debug("\t\tReply-To: " + addrs[0]);
        }
        if ((addrs = maddrs.get(ToXML.EmailType.READ_RECEIPT.toString())) != null && addrs.length > 0) {
            mm.addHeader("Disposition-Notification-To", InternetAddress.toString((Address[])addrs));
            mLog.debug("\t\tDisposition-Notification-To: " + Arrays.toString(addrs));
        }
    }

    private static void dumpMessage(MimeMessage mm) {
        mLog.debug("--------------------------------------");
        try {
            Enumeration hdrsEnum = mm.getAllHeaders();
            if (hdrsEnum != null) {
                while (hdrsEnum.hasMoreElements()) {
                    Header hdr = (Header)hdrsEnum.nextElement();
                    if (hdr.getName().equals("") || hdr.getValue().equals("\n")) continue;
                    mLog.debug(hdr.getName() + " = \"" + hdr.getValue() + "\"");
                }
            }
            mLog.debug("--------------------------------------");
            Address[] recips = mm.getAllRecipients();
            if (recips != null) {
                for (int i = 0; i < recips.length; ++i) {
                    mLog.debug("Recipient: " + recips[i].toString());
                }
            }
            mLog.debug("--------------------------------------\nMessage size is: " + mm.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mLog.debug("--------------------------------------\n");
    }

    public static void main(String[] args) throws ServiceException, IOException, MessagingException, AuthTokenException {
        Element.JSONElement m = new Element.JSONElement("m");
        m.addAttribute("su", "dinner appt");
        ((Element)m).addUniqueElement("mp").addAttribute("ct", "text/plain").addAttribute("content", "foo bar");
        ((Element)m).addElement("e").addAttribute("t", ToXML.EmailType.TO.toString()).addAttribute("a", "test@localhost");
        System.out.println(((Element)m).prettyPrint());
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, "user1");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("zimbra.authToken", AuthProvider.getAuthToken(acct).getEncoded());
        ZimbraSoapContext zsc = new ZimbraSoapContext(null, context, SoapProtocol.SoapJS);
        OperationContext octxt = new OperationContext(acct);
        MimeMessage mm = ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, null, m, null, new MimeMessageData());
        mm.writeTo((OutputStream)System.out);
    }

    static {
        FETCH_CONTACT_PARAMS.put("fmt", "vcf");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageAddresses {
        private final HashMap<String, Object> addrs = new HashMap();
        private final List<InternetAddress> newContacts;

        MessageAddresses(List<InternetAddress> contacts) {
            this.newContacts = contacts;
        }

        public void add(Element elem, String defaultCharset) throws ServiceException, UnsupportedEncodingException {
            Object content;
            String emailAddress = IDNUtil.toAscii(elem.getAttribute("a"));
            String personalName = elem.getAttribute("p", null);
            String addressType = elem.getAttribute("t");
            InternetAddress addr = new InternetAddress(emailAddress, personalName, StringUtil.checkCharset(personalName, defaultCharset));
            if (elem.getAttributeBool("add", false)) {
                this.newContacts.add(addr);
            }
            if ((content = this.addrs.get(addressType)) == null || addressType.equals(ToXML.EmailType.FROM.toString()) || addressType.equals(ToXML.EmailType.SENDER.toString())) {
                this.addrs.put(addressType, addr);
            } else if (content instanceof List) {
                ((List)content).add(addr);
            } else {
                ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
                list.add((InternetAddress)content);
                list.add(addr);
                this.addrs.put(addressType, list);
            }
        }

        public InternetAddress[] get(String addressType) {
            Object content = this.addrs.get(addressType);
            if (content == null) {
                return null;
            }
            if (content instanceof InternetAddress) {
                return new InternetAddress[]{(InternetAddress)content};
            }
            return ((List)content).toArray(new InternetAddress[0]);
        }

        public boolean isEmpty() {
            return this.addrs.isEmpty();
        }
    }

    private static class ParseMessageContext {
        MimeMessageData out;
        ZimbraSoapContext zsc;
        OperationContext octxt;
        Mailbox mbox;
        boolean use2231;
        String defaultCharset;
        long size;
        long maxSize;

        ParseMessageContext() {
            try {
                Config config = Provisioning.getInstance().getConfig();
                this.maxSize = config.getIntAttr("zimbraMtaMaxMessageSize", -1);
            }
            catch (ServiceException e) {
                ZimbraLog.mailbox.warn((Object)"Unable to determine max message size.  Disabling limit check.", e);
            }
            if (this.maxSize < 0L) {
                this.maxSize = Long.MAX_VALUE;
            }
        }

        void incrementSize(String name, long numBytes) throws MailServiceException {
            this.size += numBytes;
            mLog.debug("Adding %s, incrementing size by %d to %d.", name, numBytes, this.size);
            if (this.size > this.maxSize) {
                throw MailServiceException.MESSAGE_TOO_BIG(this.maxSize, this.size);
            }
        }
    }

    public static class MimeMessageData {
        public List<InternetAddress> newContacts = new ArrayList<InternetAddress>();
        public List<FileUploadServlet.Upload> fetches = null;
        public List<FileUploadServlet.Upload> uploads = null;
        public String iCalUUID = null;

        void addUpload(FileUploadServlet.Upload up) {
            if (this.uploads == null) {
                this.uploads = new ArrayList<FileUploadServlet.Upload>(4);
            }
            this.uploads.add(up);
        }

        void addFetch(FileUploadServlet.Upload up) {
            if (this.fetches == null) {
                this.fetches = new ArrayList<FileUploadServlet.Upload>(4);
            }
            this.fetches.add(up);
        }
    }

    static class InviteParserResult {
        public ZCalendar.ZVCalendar mCal;
        public String mUid;
        public String mSummary;
        public Invite mInvite;

        InviteParserResult() {
        }
    }

    static abstract class InviteParser {
        private InviteParserResult mResult;

        InviteParser() {
        }

        protected abstract InviteParserResult parseInviteElement(ZimbraSoapContext var1, OperationContext var2, Account var3, Element var4) throws ServiceException;

        public final InviteParserResult parse(ZimbraSoapContext zsc, OperationContext octxt, Account account, Element invElement) throws ServiceException {
            this.mResult = this.parseInviteElement(zsc, octxt, account, invElement);
            return this.mResult;
        }

        public InviteParserResult getResult() {
            return this.mResult;
        }
    }
}

