/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteAction
extends ItemAction {
    public static final String OP_EDIT = "edit";
    public static final String OP_REPOSITION = "pos";
    private static final Set<String> NOTE_OPS = new HashSet<String>(Arrays.asList("edit", "pos"));

    @Override
    protected String[] getProxiedIdPath(Element request) {
        String operation = NoteAction.getXPath(request, OPERATION_PATH);
        if (operation != null && NOTE_OPS.contains(operation.toLowerCase())) {
            return TARGET_ITEM_PATH;
        }
        return super.getProxiedIdPath(request);
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext lc = NoteAction.getZimbraSoapContext(context);
        Element action = request.getElement("action");
        String operation = action.getAttribute("op").toLowerCase();
        if (operation.endsWith("read") || operation.endsWith("spam")) {
            throw ServiceException.INVALID_REQUEST("invalid operation on note: " + operation, null);
        }
        String successes = NOTE_OPS.contains(operation) ? this.handleNote(context, request, operation) : this.handleCommon(context, request, operation, (byte)9);
        Element response = lc.createElement(MailConstants.NOTE_ACTION_RESPONSE);
        Element act = response.addUniqueElement("action");
        act.addAttribute("id", successes);
        act.addAttribute("op", operation);
        return response;
    }

    private String handleNote(Map<String, Object> context, Element request, String operation) throws ServiceException {
        Element action = request.getElement("action");
        ZimbraSoapContext zsc = NoteAction.getZimbraSoapContext(context);
        Mailbox mbox = NoteAction.getRequestedMailbox(zsc);
        OperationContext octxt = NoteAction.getOperationContext(zsc, context);
        ItemId iid = new ItemId(action.getAttribute("id"), zsc);
        if (operation.equals(OP_EDIT)) {
            String content = action.getAttribute("content");
            mbox.editNote(octxt, iid.getId(), content);
        } else if (operation.equals(OP_REPOSITION)) {
            String strBounds = action.getAttribute(OP_REPOSITION, null);
            mbox.repositionNote(octxt, iid.getId(), new Note.Rectangle(strBounds));
        } else {
            throw ServiceException.INVALID_REQUEST("unknown operation: " + operation, null);
        }
        return new ItemIdFormatter(zsc).formatItemId(iid);
    }
}

