/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.mortbay.util.ajax.WaitingContinuation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoOp
extends MailDocumentHandler {
    private static final long DEFAULT_TIMEOUT = LC.zimbra_noop_default_timeout.longValue() * 1000L;
    private static final long MIN_TIMEOUT = LC.zimbra_noop_min_timeout.longValue() * 1000L;
    private static final long MAX_TIMEOUT = LC.zimbra_noop_max_timeout.longValue() * 1000L;
    ConcurrentHashMap<String, ZimbraSoapContext> sBlockedNops = new ConcurrentHashMap(5000, 0.75f, 50);

    private static long parseTimeout(Element request) throws ServiceException {
        long timeout = request.getAttributeLong("timeout", DEFAULT_TIMEOUT);
        if (timeout < MIN_TIMEOUT) {
            timeout = MIN_TIMEOUT;
        }
        if (timeout > MAX_TIMEOUT) {
            timeout = MAX_TIMEOUT;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = NoOp.getZimbraSoapContext(context);
        boolean wait = request.getAttributeBool("wait", false);
        boolean includeDelegates = request.getAttributeBool("delegate", true);
        HttpServletRequest servletRequest = (HttpServletRequest)context.get("servlet.request");
        boolean enforceLimit = request.getAttributeBool("limitToOneBlocked", false);
        boolean blockingUnsupported = false;
        if (zsc.hasCreatedSession()) {
            wait = false;
        }
        if (wait) {
            if (!zsc.hasSession()) {
                throw ServiceException.INVALID_REQUEST("Cannot execute a NoOpRequest with wait=\"1\" without a session.  Set the <session> flag in the <context> of your request", null);
            }
            if (!context.containsKey("zimbra.resumedRequest")) {
                Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)servletRequest, (Object)zsc);
                servletRequest.setAttribute("nop_origcontext", (Object)zsc);
                if (zsc.beginWaitForNotifications(continuation, includeDelegates)) {
                    ZimbraSoapContext otherContext;
                    if (enforceLimit && (otherContext = this.sBlockedNops.put(zsc.getAuthtokenAccountId(), zsc)) != null) {
                        otherContext.signalNotification(true);
                    }
                    ZimbraSoapContext zimbraSoapContext = zsc;
                    synchronized (zimbraSoapContext) {
                        if (zsc.waitingForNotifications()) {
                            assert (!(continuation instanceof WaitingContinuation) || ((WaitingContinuation)continuation).getMutex() == zsc);
                            continuation.suspend(NoOp.parseTimeout(request));
                        }
                        assert (continuation instanceof WaitingContinuation);
                        if (zsc.isCanceledWaitForNotifications()) {
                            blockingUnsupported = true;
                        }
                    }
                }
            } else {
                ZimbraSoapContext origContext = (ZimbraSoapContext)servletRequest.getAttribute("nop_origcontext");
                if (origContext.isCanceledWaitForNotifications()) {
                    blockingUnsupported = true;
                }
            }
            if (enforceLimit) {
                this.sBlockedNops.remove(zsc.getAuthtokenAccountId(), zsc);
            }
        }
        Element toRet = zsc.createElement(MailConstants.NO_OP_RESPONSE);
        if (blockingUnsupported) {
            toRet.addAttribute("waitDisallowed", true);
        }
        return toRet;
    }
}

