/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.db.DbPop3Message;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.mail.CreateDataSource;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDataSource
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        String importClass;
        ZimbraSoapContext zsc = ModifyDataSource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = ModifyDataSource.getRequestedAccount(zsc);
        if (!this.canModifyOptions(zsc, account)) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Element eDataSource = CreateDataSource.getDataSourceElement(request);
        DataSource.Type type = DataSource.Type.fromString(eDataSource.getName());
        String id = eDataSource.getAttribute("id");
        DataSource ds = prov.get(account, Provisioning.DataSourceBy.id, id);
        if (ds == null) {
            throw ServiceException.INVALID_REQUEST("Unable to find data source with id=" + id, null);
        }
        HashMap<String, Object> dsAttrs = new HashMap<String, Object>();
        String value = eDataSource.getAttribute("name", null);
        if (value != null) {
            dsAttrs.put("zimbraDataSourceName", value);
        }
        if ((value = eDataSource.getAttribute("isEnabled", null)) != null) {
            dsAttrs.put("zimbraDataSourceEnabled", LdapUtil.getBooleanString(eDataSource.getAttributeBool("isEnabled")));
        }
        if ((value = eDataSource.getAttribute("l", null)) != null) {
            Mailbox mbox = ModifyDataSource.getRequestedMailbox(zsc);
            CreateDataSource.validateFolderId(account, mbox, eDataSource);
            dsAttrs.put("zimbraDataSourceFolderId", value);
        }
        if ((value = eDataSource.getAttribute("host", null)) != null && !value.equals(ds.getHost())) {
            dsAttrs.put("zimbraDataSourceHost", value);
        }
        if ((value = eDataSource.getAttribute("port", null)) != null) {
            dsAttrs.put("zimbraDataSourcePort", value);
        }
        if ((value = eDataSource.getAttribute("connectionType", null)) != null) {
            dsAttrs.put("zimbraDataSourceConnectionType", value);
        }
        if ((value = eDataSource.getAttribute("username", null)) != null && !value.equals(ds.getUsername())) {
            dsAttrs.put("zimbraDataSourceUsername", value);
        }
        if ((value = eDataSource.getAttribute("password", null)) != null) {
            dsAttrs.put("zimbraDataSourcePassword", value);
        }
        if ((value = eDataSource.getAttribute("leaveOnServer", null)) != null) {
            if (type != DataSource.Type.pop3) {
                String msg = String.format("%s only allowed for %s data sources", "leaveOnServer", "pop3");
                throw ServiceException.INVALID_REQUEST(msg, null);
            }
            boolean newValue = eDataSource.getAttributeBool("leaveOnServer");
            if (newValue != ds.leaveOnServer()) {
                dsAttrs.put("zimbraDataSourceLeaveOnServer", LdapUtil.getBooleanString(newValue));
                Mailbox mbox = ModifyDataSource.getRequestedMailbox(zsc);
                DbPop3Message.deleteUids(mbox, ds.getId());
                DbDataSource.deleteAllMappings(ds);
            }
        }
        if ((value = eDataSource.getAttribute("pollingInterval", null)) != null) {
            dsAttrs.put("zimbraDataSourcePollingInterval", value);
        }
        if ((importClass = eDataSource.getAttribute("importClass", DataSourceManager.getDefaultImportClass(type))) != null) {
            dsAttrs.put("zimbraDataSourceImportClassName", importClass);
        }
        ModifyDataSource.processCommonOptionalAttrs(dsAttrs, eDataSource);
        prov.modifyDataSource(account, id, dsAttrs);
        Element response = zsc.createElement(MailConstants.MODIFY_DATA_SOURCE_RESPONSE);
        return response;
    }

    public static void processCommonOptionalAttrs(Map<String, Object> dsAttrs, Element eDataSource) throws ServiceException {
        Iterator<Element> attrs;
        String value = eDataSource.getAttribute("emailAddress", null);
        if (value != null) {
            dsAttrs.put("zimbraDataSourceEmailAddress", value);
        }
        if ((value = eDataSource.getAttribute("useAddressForForwardReply", null)) != null) {
            dsAttrs.put("zimbraDataSourceUseAddressForForwardReply", LdapUtil.getBooleanString(eDataSource.getAttributeBool("useAddressForForwardReply", false)));
        }
        if ((value = eDataSource.getAttribute("defaultSignature", null)) != null) {
            dsAttrs.put("zimbraPrefDefaultSignatureId", value);
        }
        if ((value = eDataSource.getAttribute("fromDisplay", null)) != null) {
            dsAttrs.put("zimbraPrefFromDisplay", value);
        }
        if ((value = eDataSource.getAttribute("fromAddress", null)) != null) {
            dsAttrs.put("zimbraPrefFromAddress", value);
        }
        if ((value = eDataSource.getAttribute("replyToAddress", null)) != null) {
            dsAttrs.put("zimbraPrefReplyToAddress", value);
        }
        if ((value = eDataSource.getAttribute("replyToDisplay", null)) != null) {
            dsAttrs.put("zimbraPrefReplyToDisplay", value);
        }
        if ((value = eDataSource.getAttribute("pollingInterval", null)) != null) {
            dsAttrs.put("zimbraDataSourcePollingInterval", value);
        }
        if ((attrs = eDataSource.elementIterator("a")) != null && attrs.hasNext()) {
            ArrayList<String> attrList = new ArrayList<String>();
            while (attrs.hasNext()) {
                attrList.add(attrs.next().getText());
            }
            dsAttrs.put("zimbraDataSourceAttribute", attrList.toArray(new String[0]));
        }
    }
}

