/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.service.mail.CreateContact;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyContact
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"cn", "id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ModifyContact.getZimbraSoapContext(context);
        Mailbox mbox = ModifyContact.getRequestedMailbox(zsc);
        OperationContext octxt = ModifyContact.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        boolean replace = request.getAttributeBool("replace", false);
        boolean verbose = request.getAttributeBool("verbose", true);
        Element cn = request.getElement("cn");
        ItemId iid = new ItemId(cn.getAttribute("id"), zsc);
        Contact contact = mbox.getContactById(octxt, iid.getId());
        Pair<Map<String, String>, List<Contact.Attachment>> cdata = CreateContact.parseContact(cn, zsc, octxt, contact);
        ParsedContact pc = replace ? new ParsedContact(cdata.getFirst(), cdata.getSecond()) : new ParsedContact(contact).modify(cdata.getFirst(), cdata.getSecond());
        mbox.modifyContact(octxt, iid.getId(), pc);
        Contact con = mbox.getContactById(octxt, iid.getId());
        Element response = zsc.createElement(MailConstants.MODIFY_CONTACT_RESPONSE);
        if (con != null) {
            if (verbose) {
                ToXML.encodeContact(response, ifmt, con, true, null);
            } else {
                response.addElement("cn").addAttribute("id", con.getId());
            }
        }
        return response;
    }

    static Map<String, String> parseFields(List<Element> elist) throws ServiceException {
        if (elist == null || elist.isEmpty()) {
            return null;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Element e : elist) {
            String name = e.getAttribute("n");
            attrs.put(name, e.getText());
        }
        return attrs;
    }
}

