/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ItemActionHelper;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyCalendarItem
extends CalendarRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ModifyCalendarItem.getZimbraSoapContext(context);
        Account acct = ModifyCalendarItem.getRequestedAccount(zsc);
        Mailbox mbox = ModifyCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = ModifyCalendarItem.getOperationContext(zsc, context);
        Element msgElem = request.getElement("m");
        String folderStr = msgElem.getAttribute("l", null);
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        if (!iid.belongsTo(acct)) {
            if (folderStr != null) {
                ItemId folderFQ = new ItemId(folderStr, zsc);
                msgElem.addAttribute("l", folderFQ.toString());
            }
            return this.proxyRequest(request, context, iid.getAccountId());
        }
        boolean isInterMboxMove = false;
        ItemId iidFolder = null;
        if (folderStr != null) {
            iidFolder = new ItemId(folderStr, zsc);
            isInterMboxMove = !iidFolder.belongsTo(mbox);
        }
        Element response = this.getResponseElement(zsc);
        int compNum = (int)request.getAttributeLong("comp", 0L);
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
            if (calItem == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
            }
            Invite inv = calItem.getInvite(iid.getSubpartId(), compNum);
            if (inv == null) {
                throw MailServiceException.INVITE_OUT_OF_DATE(iid.toString());
            }
            Invite seriesInv = calItem.getDefaultInviteOrNull();
            int folderId = calItem.getFolderId();
            if (!isInterMboxMove && iidFolder != null) {
                folderId = iidFolder.getId();
            }
            this.modifyCalendarItem(zsc, octxt, request, acct, mbox, folderId, calItem, inv, seriesInv, response, isInterMboxMove);
        }
        if (isInterMboxMove) {
            CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
            ArrayList<Integer> ids = new ArrayList<Integer>(1);
            ids.add(calItem.getId());
            ItemActionHelper.MOVE(octxt, mbox, zsc.getResponseProtocol(), ids, calItem.getType(), null, iidFolder);
        }
        return response;
    }

    private Element modifyCalendarItem(ZimbraSoapContext zsc, OperationContext octxt, Element request, Account acct, Mailbox mbox, int folderId, CalendarItem calItem, Invite inv, Invite seriesInv, Element response, boolean isInterMboxMove) throws ServiceException {
        List<ZAttendee> atsAdded;
        Element msgElem = request.getElement("m");
        ModifyCalendarItemParser parser = new ModifyCalendarItemParser(inv, seriesInv);
        CalendarRequest.CalSendData dat = ModifyCalendarItem.handleMsgElement(zsc, octxt, msgElem, acct, mbox, parser);
        dat.mDontNotifyAttendees = isInterMboxMove;
        if (!inv.isOrganizer()) {
            try {
                Address[] rcpts = dat.mMm.getAllRecipients();
                if (rcpts != null && rcpts.length > 0) {
                    throw MailServiceException.MUST_BE_ORGANIZER("ModifyCalendarItem");
                }
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("Checking recipients of outgoing msg ", e);
            }
        }
        if (!(atsAdded = parser.getAttendeesAdded()).isEmpty() && inv.isRecurrence() && inv.isOrganizer()) {
            try {
                Message.RecipientType[] rcptTypes;
                for (Message.RecipientType rcptType : rcptTypes = new Message.RecipientType[]{Message.RecipientType.TO, Message.RecipientType.CC, Message.RecipientType.BCC}) {
                    Address[] rcpts = dat.mMm.getRecipients(rcptType);
                    ArrayList<Address> filtered = new ArrayList<Address>();
                    boolean foundDuplicate = false;
                    if (rcpts != null && rcpts.length > 0) {
                        for (Address rcpt : rcpts) {
                            String email;
                            if (!(rcpt instanceof InternetAddress) || (email = ((InternetAddress)rcpt).getAddress()) == null) continue;
                            boolean keep = true;
                            for (ZAttendee at : atsAdded) {
                                if (!email.equalsIgnoreCase(at.getAddress())) continue;
                                keep = false;
                                foundDuplicate = true;
                                break;
                            }
                            if (!keep) continue;
                            filtered.add(rcpt);
                        }
                    }
                    if (!foundDuplicate) continue;
                    Address[] newRcpts = filtered.toArray(new Address[0]);
                    dat.mMm.setRecipients(rcptType, newRcpts);
                }
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("Checking recipients of outgoing msg ", e);
            }
        }
        ModifyCalendarItem.sendCalendarMessage(zsc, octxt, folderId, acct, mbox, dat, response, false, true);
        List<ZAttendee> atsCanceled = parser.getAttendeesCanceled();
        if (!atsCanceled.isEmpty() && inv.isOrganizer()) {
            ModifyCalendarItem.updateRemovedInvitees(zsc, octxt, acct, mbox, inv.getCalendarItem(), inv, atsCanceled);
        }
        if (!atsAdded.isEmpty() && inv.isRecurrence() && inv.isOrganizer()) {
            ModifyCalendarItem.updateAddedInvitees(zsc, octxt, acct, mbox, inv.getCalendarItem(), inv, atsAdded);
        }
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModifyCalendarItemParser
    extends ParseMimeMessage.InviteParser {
        private Invite mInv;
        private Invite mSeriesInv;
        private List<ZAttendee> mAttendeesAdded;
        private List<ZAttendee> mAttendeesCanceled;

        ModifyCalendarItemParser(Invite inv, Invite seriesInv) {
            this.mInv = inv;
            this.mSeriesInv = seriesInv;
            this.mAttendeesAdded = new ArrayList<ZAttendee>();
            this.mAttendeesCanceled = new ArrayList<ZAttendee>();
        }

        public List<ZAttendee> getAttendeesAdded() {
            return this.mAttendeesAdded;
        }

        public List<ZAttendee> getAttendeesCanceled() {
            return this.mAttendeesCanceled;
        }

        @Override
        public ParseMimeMessage.InviteParserResult parseInviteElement(ZimbraSoapContext lc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            ParseMimeMessage.InviteParserResult toRet = CalendarUtils.parseInviteForModify(account, ModifyCalendarItem.this.getItemType(), inviteElem, this.mInv, this.mSeriesInv, this.mAttendeesAdded, this.mAttendeesCanceled, !this.mInv.hasRecurId());
            return toRet;
        }
    }
}

