/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.operation.BlockingOperation;
import com.zimbra.cs.operation.Requester;
import com.zimbra.cs.operation.Scheduler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailDocumentHandler
extends DocumentHandler {
    @Override
    public Object preHandle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = MailDocumentHandler.getZimbraSoapContext(context);
        boolean isLocal = Provisioning.onLocalServer(MailDocumentHandler.getRequestedAccount(zsc));
        Session session = isLocal ? this.getSession(zsc, context) : null;
        Mailbox mbox = isLocal ? MailDocumentHandler.getRequestedMailbox(zsc) : null;
        OperationContext octxt = MailDocumentHandler.getOperationContext(zsc, session);
        return BlockingOperation.schedule(request.getName(), session, octxt, mbox, Requester.SOAP, this.getSchedulerPriority(), 1);
    }

    @Override
    public void postHandle(Object userObj) {
        ((BlockingOperation)userObj).finish();
    }

    protected Scheduler.Priority getSchedulerPriority() {
        return Scheduler.Priority.INTERACTIVE_HIGH;
    }

    protected String[] getProxiedIdPath(Element request) {
        return null;
    }

    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    protected String[] getResponseItemPath() {
        return null;
    }

    @Override
    protected Element proxyIfNecessary(Element request, Map<String, Object> context) throws ServiceException {
        ItemId iid;
        OperationContext octxt;
        ZimbraSoapContext zsc;
        ItemId iidTarget;
        String id;
        String[] xpath = this.getProxiedIdPath(request);
        String string = id = xpath != null ? MailDocumentHandler.getXPath(request, xpath) : null;
        if (id != null && (iidTarget = MailDocumentHandler.getProxyTarget(zsc = MailDocumentHandler.getZimbraSoapContext(context), octxt = MailDocumentHandler.getOperationContext(zsc, context), iid = new ItemId(id, zsc), this.checkMountpointProxy(request))) != null) {
            return this.proxyRequest(request, context, iid, iidTarget);
        }
        return super.proxyIfNecessary(request, context);
    }

    protected static ItemId getProxyTarget(ZimbraSoapContext zsc, OperationContext octxt, ItemId iid, boolean checkMountpoint) throws ServiceException {
        if (zsc == null || iid == null) {
            return null;
        }
        Account acct = MailDocumentHandler.getRequestedAccount(zsc);
        if (!iid.belongsTo(acct)) {
            return iid;
        }
        if (!checkMountpoint || !Provisioning.onLocalServer(acct)) {
            return null;
        }
        Mailbox mbox = MailDocumentHandler.getRequestedMailbox(zsc);
        MailItem item = mbox.getItemById(octxt, iid.getId(), (byte)-1);
        if (!(item instanceof Mountpoint)) {
            return null;
        }
        return ((Mountpoint)item).getTarget();
    }

    private void insertMountpointReferences(Element response, String[] xpath, ItemId iidMountpoint, ItemId iidLocal, ZimbraSoapContext lc) {
        int depth = 0;
        while (depth < xpath.length && response != null) {
            response = response.getOptionalElement(xpath[depth++]);
        }
        if (response == null) {
            return;
        }
        ItemIdFormatter ifmt = new ItemIdFormatter(lc);
        String local = iidLocal.toString(ifmt);
        for (Element elt : response.listElements()) {
            String folder = elt.getAttribute("l", null);
            if (!local.equalsIgnoreCase(folder)) continue;
            elt.addAttribute("l", iidMountpoint.toString(ifmt));
        }
    }

    protected Element proxyRequest(Element request, Map<String, Object> context, ItemId iidRequested, ItemId iidResolved) throws ServiceException {
        boolean mountpoint;
        boolean bl = mountpoint = iidRequested != iidResolved;
        if (mountpoint) {
            MailDocumentHandler.setXPath(request, this.getProxiedIdPath(request), iidResolved.toString());
        }
        Element response = this.proxyRequest(request, context, iidResolved.getAccountId(), mountpoint);
        ZimbraSoapContext zsc = MailDocumentHandler.getZimbraSoapContext(context);
        String[] xpathResponse = this.getResponseItemPath();
        if (mountpoint && xpathResponse != null) {
            this.insertMountpointReferences(response, xpathResponse, iidRequested, iidResolved, zsc);
        }
        return response;
    }

    private Element proxyRequest(Element request, Map<String, Object> context, String acctId, boolean mountpoint) throws ServiceException {
        ZimbraSoapContext zsc = MailDocumentHandler.getZimbraSoapContext(context);
        ZimbraSoapContext zscTarget = new ZimbraSoapContext(zsc, acctId);
        if (mountpoint) {
            zscTarget.recordMountpointTraversal();
        }
        return this.proxyRequest(request, context, MailDocumentHandler.getServer(acctId), zscTarget);
    }
}

