/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.service.util.SpamHandler;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMountpoint;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemActionHelper {
    protected String mResult;
    protected List<String> mCreatedIds;
    protected SoapProtocol mResponseProtocol;
    protected Op mOperation;
    protected int[] mIds;
    protected byte mItemType;
    protected boolean mFlagValue;
    protected MailItem.TargetConstraint mTargetConstraint;
    protected int mHopCount;
    protected int mTagId;
    protected MailItem.Color mColor;
    protected String mName;
    protected ItemId mIidFolder;
    protected ItemId mIidRequestedFolder;
    protected String mFlags;
    protected String mTags;
    protected ItemIdFormatter mIdFormatter;
    protected Account mAuthenticatedAccount;
    private OperationContext mOpCtxt;
    private Mailbox mMailbox;

    public static ItemActionHelper TAG(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, boolean flagValue, MailItem.TargetConstraint tcon, int tagId) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.TAG, type, flagValue, tcon);
        ia.setTagId(tagId);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper FLAG(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, boolean flagValue, MailItem.TargetConstraint tcon) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.FLAG, type, flagValue, tcon);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper READ(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, boolean flagValue, MailItem.TargetConstraint tcon) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.READ, type, flagValue, tcon);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper COLOR(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon, MailItem.Color color) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.COLOR, type, true, tcon);
        ia.setColor(color);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper HARD_DELETE(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.HARD_DELETE, type, true, tcon);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper MOVE(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon, ItemId iidFolder) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.MOVE, type, true, tcon);
        ia.setIidFolder(iidFolder);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper COPY(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon, ItemId iidFolder) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.COPY, type, true, tcon);
        ia.setIidFolder(iidFolder);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper SPAM(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, boolean flagValue, MailItem.TargetConstraint tcon, ItemId iidFolder) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.SPAM, type, flagValue, tcon);
        ia.setIidFolder(iidFolder);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper TRASH(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.TRASH, type, true, tcon);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper RENAME(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon, String name, ItemId iidFolder) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.RENAME, type, true, tcon);
        ia.setName(name);
        ia.setIidFolder(iidFolder);
        ia.schedule();
        return ia;
    }

    public static ItemActionHelper UPDATE(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, byte type, MailItem.TargetConstraint tcon, String name, ItemId iidFolder, String flags, String tags, MailItem.Color color) throws ServiceException {
        ItemActionHelper ia = new ItemActionHelper(octxt, mbox, responseProto, ids, Op.UPDATE, type, true, tcon);
        ia.setName(name);
        ia.setIidFolder(iidFolder);
        ia.setFlags(flags);
        ia.setTags(tags);
        ia.setColor(color);
        ia.schedule();
        return ia;
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder(super.toString());
        toRet.append(" Op=").append(this.mOperation.toString());
        toRet.append(" Type=").append(this.mItemType);
        toRet.append(" FlagValue=").append(this.mFlagValue);
        if (this.mTargetConstraint != null) {
            toRet.append(" TargetConst=").append(this.mTargetConstraint.toString());
        }
        if (this.mOperation == Op.TAG) {
            toRet.append(" TagId=").append(this.mTagId);
        }
        if (this.mOperation == Op.COLOR || this.mOperation == Op.UPDATE) {
            toRet.append(" Color=").append(this.mColor);
        }
        if (this.mOperation == Op.MOVE || this.mOperation == Op.SPAM || this.mOperation == Op.COPY || this.mOperation == Op.RENAME || this.mOperation == Op.UPDATE) {
            toRet.append(" iidFolder=").append(this.mIidFolder);
        }
        if (this.mOperation == Op.UPDATE) {
            if (this.mFlags != null) {
                toRet.append(" flags=").append(this.mFlags);
            }
            if (this.mTags != null) {
                toRet.append(" tags=").append(this.mTags);
            }
        }
        return toRet.toString();
    }

    public void setTagId(int tagId) {
        assert (this.mOperation == Op.TAG);
        this.mTagId = tagId;
    }

    public void setColor(MailItem.Color color) {
        assert (this.mOperation == Op.COLOR || this.mOperation == Op.UPDATE);
        this.mColor = color;
    }

    public void setName(String name) {
        assert (this.mOperation == Op.RENAME || this.mOperation == Op.UPDATE);
        this.mName = name;
    }

    public void setIidFolder(ItemId iidFolder) {
        assert (this.mOperation == Op.MOVE || this.mOperation == Op.SPAM || this.mOperation == Op.COPY || this.mOperation == Op.RENAME || this.mOperation == Op.UPDATE);
        this.mIidRequestedFolder = this.mIidFolder = iidFolder;
    }

    public void setFlags(String flags) {
        assert (this.mOperation == Op.UPDATE);
        this.mFlags = flags;
    }

    public void setTags(String tags) {
        assert (this.mOperation == Op.UPDATE);
        this.mTags = tags;
    }

    ItemActionHelper(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, Op op, byte type, boolean flagValue, MailItem.TargetConstraint tcon) throws ServiceException {
        this.mOpCtxt = octxt;
        this.mMailbox = mbox;
        Account account = this.mAuthenticatedAccount = octxt == null ? null : octxt.getAuthenticatedUser();
        if (this.mAuthenticatedAccount == null) {
            this.mAuthenticatedAccount = mbox.getAccount();
        }
        this.mIdFormatter = new ItemIdFormatter(this.mAuthenticatedAccount, mbox, false);
        this.mResponseProtocol = responseProto;
        int i = 0;
        this.mIds = new int[ids.size()];
        for (int id : ids) {
            this.mIds[i++] = id;
        }
        this.mOperation = op;
        if (this.mOperation == null) {
            throw ServiceException.INVALID_REQUEST("unknown operation: null", null);
        }
        this.mItemType = type;
        this.mFlagValue = flagValue;
        this.mTargetConstraint = tcon;
    }

    protected Mailbox getMailbox() {
        return this.mMailbox;
    }

    protected OperationContext getOpCtxt() {
        return this.mOpCtxt;
    }

    protected void schedule() throws ServiceException {
        Folder folder;
        boolean targeted;
        boolean bl = targeted = this.mOperation == Op.MOVE || this.mOperation == Op.SPAM || this.mOperation == Op.COPY || this.mOperation == Op.RENAME || this.mOperation == Op.UPDATE;
        if (targeted && this.mIidFolder.belongsTo(this.mMailbox) && this.mIidFolder.getId() > 0 && this.mIidFolder.getId() != 3 && this.mIidFolder.getId() != 4 && (folder = this.mMailbox.getFolderById(this.mOpCtxt, this.mIidFolder.getId())) instanceof Mountpoint && !((Mountpoint)folder).getOwnerId().equals(this.mIidFolder.getAccountId())) {
            this.mIidFolder = ((Mountpoint)folder).getTarget();
            ++this.mHopCount;
        }
        try {
            if (!targeted || this.mIidFolder.belongsTo(this.mMailbox)) {
                this.executeLocal();
            } else {
                this.executeRemote();
            }
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("exception reading item blob", ioe);
        }
        StringBuilder successes = new StringBuilder();
        for (int id : this.mIds) {
            successes.append(successes.length() > 0 ? "," : "").append(this.mIdFormatter.formatItemId(id));
        }
        this.mResult = successes.toString();
    }

    public String getResult() {
        return this.mResult;
    }

    public List<String> getCreatedIds() {
        return this.mCreatedIds;
    }

    private void executeLocal() throws ServiceException {
        switch (this.mOperation) {
            case FLAG: {
                this.getMailbox().alterTag(this.getOpCtxt(), this.mIds, this.mItemType, -6, this.mFlagValue, this.mTargetConstraint);
                break;
            }
            case READ: {
                this.getMailbox().alterTag(this.getOpCtxt(), this.mIds, this.mItemType, -10, !this.mFlagValue, this.mTargetConstraint);
                break;
            }
            case TAG: {
                this.getMailbox().alterTag(this.getOpCtxt(), this.mIds, this.mItemType, this.mTagId, this.mFlagValue, this.mTargetConstraint);
                break;
            }
            case COLOR: {
                this.getMailbox().setColor(this.getOpCtxt(), this.mIds, this.mItemType, this.mColor);
                break;
            }
            case HARD_DELETE: {
                this.getMailbox().delete(this.getOpCtxt(), this.mIds, this.mItemType, this.mTargetConstraint);
                break;
            }
            case SPAM: 
            case MOVE: {
                this.getMailbox().move(this.getOpCtxt(), this.mIds, this.mItemType, this.mIidFolder.getId(), this.mTargetConstraint);
                break;
            }
            case COPY: {
                List<MailItem> copies = this.getMailbox().copy(this.getOpCtxt(), this.mIds, this.mItemType, this.mIidFolder.getId());
                this.mCreatedIds = new ArrayList<String>(this.mIds.length);
                for (MailItem item : copies) {
                    this.mCreatedIds.add(this.mIdFormatter.formatItemId(item));
                }
                break;
            }
            case TRASH: {
                try {
                    this.getMailbox().move(this.getOpCtxt(), this.mIds, this.mItemType, 3, this.mTargetConstraint);
                }
                catch (ServiceException e) {
                    if (!e.getCode().equals("mail.ALREADY_EXISTS")) {
                        throw e;
                    }
                    this.moveWithRename(3);
                }
                break;
            }
            case RENAME: {
                for (int id : this.mIds) {
                    this.getMailbox().rename(this.getOpCtxt(), id, this.mItemType, this.mName, this.mIidFolder.getId());
                }
                break;
            }
            case UPDATE: {
                if (this.mName != null) {
                    for (int id : this.mIds) {
                        this.getMailbox().rename(this.getOpCtxt(), id, this.mItemType, this.mName, this.mIidFolder.getId());
                    }
                } else if (this.mIidFolder.getId() > 0) {
                    this.getMailbox().move(this.getOpCtxt(), this.mIds, this.mItemType, this.mIidFolder.getId(), this.mTargetConstraint);
                }
                if (this.mTags != null || this.mFlags != null) {
                    this.getMailbox().setTags(this.getOpCtxt(), this.mIds, this.mItemType, this.mFlags, this.mTags, this.mTargetConstraint);
                }
                if (this.mColor == null) break;
                this.getMailbox().setColor(this.getOpCtxt(), this.mIds, this.mItemType, this.mColor);
                break;
            }
            default: {
                throw ServiceException.INVALID_REQUEST("unknown operation: " + (Object)((Object)this.mOperation), null);
            }
        }
    }

    private void moveWithRename(int targetId) throws ServiceException {
        for (int id : this.mIds) {
            try {
                this.getMailbox().move(this.getOpCtxt(), id, this.mItemType, targetId, this.mTargetConstraint);
            }
            catch (ServiceException e) {
                if (!e.getCode().equals("mail.ALREADY_EXISTS")) {
                    throw e;
                }
                String name = this.getMailbox().getItemById(this.getOpCtxt(), id, this.mItemType).getName();
                String uuid = '{' + UUID.randomUUID().toString() + '}';
                String newName = name.length() + uuid.length() > 128 ? name.substring(0, 128 - uuid.length()) + uuid : name + uuid;
                this.getMailbox().rename(this.getOpCtxt(), id, this.mItemType, newName, targetId);
            }
        }
    }

    private AuthToken getAuthToken() throws ServiceException {
        AuthToken authToken = null;
        if (this.mOpCtxt != null) {
            authToken = this.mOpCtxt.getAuthToken();
        }
        if (authToken == null) {
            authToken = AuthProvider.getAuthToken(this.mAuthenticatedAccount);
        }
        return authToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRemote() throws ServiceException, IOException {
        ItemId iidTarget;
        Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mIidFolder.getAccountId());
        AuthToken at = this.getAuthToken();
        String pxyAuthToken = Provisioning.onLocalServer(target) ? null : at.getProxyAuthToken();
        ZAuthToken zat = pxyAuthToken == null ? at.toZAuthToken() : new ZAuthToken(pxyAuthToken);
        ZMailbox.Options zoptions = new ZMailbox.Options(zat, AccountUtil.getSoapUri(target));
        zoptions.setNoSession(true);
        zoptions.setResponseProtocol(this.mResponseProtocol);
        zoptions.setTargetAccount(target.getId());
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        ZMailbox zmbx = ZMailbox.getMailbox(zoptions);
        ZFolder zfolder = zmbx.getFolderById(this.mIidFolder.toString(this.mAuthenticatedAccount));
        if (zfolder instanceof ZMountpoint && !this.mIidFolder.equals(iidTarget = new ItemId(((ZMountpoint)zfolder).getCanonicalRemoteId(), this.mAuthenticatedAccount.getId()))) {
            this.mIidFolder = iidTarget;
            if (++this.mHopCount > 5) {
                throw MailServiceException.TOO_MANY_HOPS(this.mIidRequestedFolder);
            }
            this.schedule();
            return;
        }
        boolean deleteOriginal = this.mOperation != Op.COPY;
        String folderStr = this.mIidFolder.toString();
        this.mCreatedIds = new ArrayList<String>(this.mIds.length);
        boolean toSpam = this.mIidFolder.getId() == 4;
        boolean toMailbox = !toSpam && this.mIidFolder.getId() != 3;
        for (MailItem item : this.mMailbox.getItemById(this.mOpCtxt, this.mIds, this.mItemType)) {
            boolean fromSpam;
            if (item == null) continue;
            List<Message> msgs = null;
            if (item instanceof Conversation) {
                msgs = this.mMailbox.getMessagesByConversation(this.mOpCtxt, item.getId(), SortBy.DATE_ASCENDING);
            }
            if (deleteOriginal) {
                if (msgs != null) {
                    boolean permDenied = false;
                    Iterator it = msgs.iterator();
                    while (it.hasNext()) {
                        Message msg = (Message)it.next();
                        if (!MailItem.TargetConstraint.checkItem(this.mTargetConstraint, msg)) {
                            it.remove();
                            continue;
                        }
                        if (this.canDelete(msg)) continue;
                        it.remove();
                        permDenied = true;
                    }
                    if (msgs.isEmpty()) {
                        if (!permDenied) continue;
                        throw ServiceException.PERM_DENIED("cannot delete any messages in " + MailItem.getNameForType(item) + " " + item.getId());
                    }
                } else if (!this.canDelete(item)) {
                    throw ServiceException.PERM_DENIED("cannot delete existing copy of " + MailItem.getNameForType(item) + " " + item.getId());
                }
            }
            if ((fromSpam = item.inSpam()) && toMailbox || !fromSpam && toSpam) {
                try {
                    SpamHandler.getInstance().handle(this.mOpCtxt, this.mMailbox, item.getId(), item.getType(), toSpam);
                    ZimbraLog.mailop.info("sent to spam filter for training (marked as " + (toSpam ? "" : "not ") + "spam): " + new ItemId(item).toString());
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                }
                catch (Throwable t) {
                    ZimbraLog.mailop.info((Object)("could not train spam filter: " + new ItemId(item).toString()), t);
                }
            }
            String flags = this.mOperation == Op.UPDATE && this.mFlags != null ? this.mFlags : item.getFlagString();
            String name = (this.mOperation == Op.RENAME || this.mOperation == Op.UPDATE) && this.mName != null ? this.mName : item.getName();
            String createdId = null;
            InputStream in = null;
            switch (item.getType()) {
                case 6: {
                    ZContact contact = zmbx.createContact(folderStr, null, ((Contact)item).getFields());
                    createdId = contact.getId();
                    this.mCreatedIds.add(createdId);
                    break;
                }
                case 5: {
                    Object var24_29;
                    try {
                        in = StoreManager.getInstance().getContent(item.getBlob());
                        createdId = zmbx.addMessage(folderStr, flags, null, item.getDate(), in, item.getSize(), true);
                        var24_29 = null;
                    }
                    catch (Throwable throwable) {
                        var24_29 = null;
                        ByteUtil.closeStream(in);
                        throw throwable;
                    }
                    ByteUtil.closeStream(in);
                    this.mCreatedIds.add(createdId);
                    break;
                }
                case 4: 
                case 12: {
                    for (Message msg : msgs) {
                        Object var26_33;
                        flags = this.mOperation == Op.UPDATE && this.mFlags != null ? this.mFlags : msg.getFlagString();
                        try {
                            in = StoreManager.getInstance().getContent(msg.getBlob());
                            createdId = zmbx.addMessage(folderStr, flags, null, msg.getDate(), in, msg.getSize(), true);
                            var26_33 = null;
                        }
                        catch (Throwable throwable) {
                            var26_33 = null;
                            ByteUtil.closeStream(in);
                            throw throwable;
                        }
                        ByteUtil.closeStream(in);
                        this.mCreatedIds.add(createdId);
                    }
                    break;
                }
                case 8: {
                    Object var28_36;
                    Document doc = (Document)item;
                    try {
                        in = StoreManager.getInstance().getContent(doc.getBlob());
                        String uploadId = zmbx.uploadContentAsStream(name, in, doc.getContentType(), doc.getSize(), 4000);
                        createdId = zmbx.createDocument(folderStr, name, uploadId);
                        var28_36 = null;
                    }
                    catch (Throwable throwable) {
                        var28_36 = null;
                        ByteUtil.closeStream(in);
                        throw throwable;
                    }
                    ByteUtil.closeStream(in);
                    this.mCreatedIds.add(createdId);
                    break;
                }
                case 14: {
                    createdId = zmbx.createWiki(folderStr, name, new String(((WikiItem)item).getContent(), "utf-8"));
                    this.mCreatedIds.add(createdId);
                    break;
                }
                case 11: 
                case 15: {
                    CalendarItem cal = (CalendarItem)item;
                    if (!cal.isPublic()) {
                        boolean asAdmin;
                        boolean bl = asAdmin = this.mOpCtxt != null ? this.mOpCtxt.isUsingAdminPrivileges() : false;
                        if (!cal.allowPrivateAccess(this.mAuthenticatedAccount, asAdmin)) {
                            throw ServiceException.PERM_DENIED("you do not have permission to move/copy a private calendar item from the current folder/mailbox");
                        }
                    }
                    QName qname = item.getType() == 15 ? MailConstants.SET_TASK_REQUEST : MailConstants.SET_APPOINTMENT_REQUEST;
                    Element request = new Element.XMLElement(qname).addAttribute("l", folderStr).addAttribute("f", flags);
                    ToXML.encodeAlarmTimes(request, cal);
                    boolean isOrganizer = false;
                    Invite invDefault = cal.getDefaultInviteOrNull();
                    if (invDefault != null) {
                        if (invDefault.isOrganizer()) {
                            isOrganizer = true;
                        }
                        this.addCalendarPart(request.addUniqueElement("default"), cal, invDefault, zmbx, target);
                    }
                    for (Invite inv : cal.getInvites()) {
                        if (inv == null || inv == invDefault) continue;
                        if (inv.isOrganizer()) {
                            isOrganizer = true;
                        }
                        String elem = inv.isCancel() ? "cancel" : "except";
                        this.addCalendarPart(request.addElement(elem), cal, inv, zmbx, target);
                    }
                    ToXML.encodeCalendarReplies(request, cal);
                    createdId = zmbx.invoke(request).getAttribute("calItemId");
                    this.mCreatedIds.add(createdId);
                    if (!isOrganizer) break;
                    request = new Element.XMLElement(MailConstants.ANNOUNCE_ORGANIZER_CHANGE_REQUEST);
                    request.addAttribute("id", createdId);
                    zmbx.invoke(request);
                    break;
                }
                default: {
                    throw MailServiceException.CANNOT_COPY(item.getId());
                }
            }
            try {
                if (!deleteOriginal || this.mIdFormatter.formatItemId(item).equals(createdId)) continue;
                if (msgs == null) {
                    this.mMailbox.delete(this.mOpCtxt, item.getId(), item.getType());
                    continue;
                }
                for (Message msg : msgs) {
                    this.mMailbox.delete(this.mOpCtxt, msg.getId(), msg.getType());
                }
            }
            catch (ServiceException e) {
                if (e.getCode() != "service.PERM_DENIED") {
                    throw e;
                }
                ZimbraLog.misc.info("could not delete original item " + item.getId() + "; treating operation as a copy instead");
            }
        }
    }

    private void addCalendarPart(Element parent, CalendarItem cal, Invite inv, ZMailbox zmbx, Account target) throws ServiceException {
        parent.addAttribute("ptst", inv.getPartStat());
        Element m = parent.addUniqueElement("m");
        Pair<MimeMessage, Integer> spinfo = cal.getSubpartMessageData(inv.getMailItemId());
        if (spinfo != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(spinfo.getSecond());
                spinfo.getFirst().writeTo((OutputStream)baos);
                String uploadId = zmbx.uploadAttachment("message", baos.toByteArray(), "message/rfc822", 6000);
                m.addAttribute("aid", uploadId);
            }
            catch (IOException ioe) {
                ZimbraLog.misc.info((Object)("could not read subpart message for part " + inv.getComponentNum() + " of item " + cal.getId()), ioe);
            }
            catch (MessagingException me) {
                ZimbraLog.misc.info((Object)("could not read subpart message for part " + inv.getComponentNum() + " of item " + cal.getId()), me);
            }
        }
        if (inv.isOrganizer() && inv.hasOrganizer()) {
            Account authAcct;
            Invite invCopy = inv.newCopy();
            invCopy.setInviteId(inv.getMailItemId());
            invCopy.setSeqNo(inv.getSeqNo() + 1);
            invCopy.setDtStamp(System.currentTimeMillis());
            ZOrganizer org = invCopy.getOrganizer();
            org.setAddress(target.getName());
            org.setCn(target.getAttr("displayName"));
            Account account = authAcct = this.mOpCtxt != null ? this.mOpCtxt.getAuthenticatedUser() : target;
            if (authAcct == null || authAcct.equals(target)) {
                org.setSentBy(null);
            } else {
                org.setSentBy(authAcct.getName());
            }
            inv = invCopy;
        }
        ToXML.encodeInvite(m, this.mIdFormatter, this.getOpCtxt(), cal, inv, true);
    }

    private boolean canDelete(MailItem item) throws ServiceException {
        return (this.mMailbox.getEffectivePermissions(this.mOpCtxt, item.getId(), item.getType()) & 8) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        TAG("tag"),
        FLAG("flag"),
        READ("read"),
        COLOR("color"),
        HARD_DELETE("delete"),
        MOVE("move"),
        COPY("copy"),
        SPAM("spam"),
        TRASH("trash"),
        RENAME("rename"),
        UPDATE("update");

        private String mStr;

        private Op(String str) {
            this.mStr = str;
        }

        public String toString() {
            return this.mStr;
        }
    }
}

