/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.ItemActionHelper;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMountpoint;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemAction
extends MailDocumentHandler {
    protected static final String[] OPERATION_PATH = new String[]{"action", "op"};
    protected static final String[] TARGET_ITEM_PATH = new String[]{"action", "id"};
    public static final String OP_TAG = "tag";
    public static final String OP_FLAG = "flag";
    public static final String OP_READ = "read";
    public static final String OP_COLOR = "color";
    public static final String OP_HARD_DELETE = "delete";
    public static final String OP_MOVE = "move";
    public static final String OP_COPY = "copy";
    public static final String OP_SPAM = "spam";
    public static final String OP_TRASH = "trash";
    public static final String OP_RENAME = "rename";
    public static final String OP_UPDATE = "update";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = ItemAction.getZimbraSoapContext(context);
        Element action = request.getElement("action");
        String operation = action.getAttribute("op").toLowerCase();
        String successes = this.handleCommon(context, request, operation, (byte)-1);
        Element response = zsc.createElement(MailConstants.ITEM_ACTION_RESPONSE);
        Element act = response.addUniqueElement("action");
        act.addAttribute("id", successes);
        act.addAttribute("op", operation);
        return response;
    }

    protected String handleCommon(Map<String, Object> context, Element request, String opAttr, byte type) throws ServiceException {
        String opStr;
        Element action = request.getElement("action");
        ZimbraSoapContext zsc = ItemAction.getZimbraSoapContext(context);
        Mailbox mbox = ItemAction.getRequestedMailbox(zsc);
        OperationContext octxt = ItemAction.getOperationContext(zsc, context);
        SoapProtocol responseProto = zsc.getResponseProtocol();
        boolean flagValue = true;
        if (opAttr.length() > 1 && opAttr.startsWith("!")) {
            flagValue = false;
            opStr = opAttr.substring(1);
        } else {
            opStr = opAttr;
        }
        ArrayList<Integer> local = new ArrayList<Integer>();
        HashMap<String, StringBuffer> remote = new HashMap<String, StringBuffer>();
        ItemAction.partitionItems(zsc, action.getAttribute("id"), local, remote);
        if (remote.isEmpty() && local.isEmpty()) {
            return "";
        }
        Account remoteNotify = this.forceRemoteSession(zsc, context, octxt, opStr, action);
        StringBuffer successes = this.proxyRemoteItems(action, remote, request, context);
        if (!local.isEmpty()) {
            String localResults;
            String constraint = action.getAttribute("tcon", null);
            MailItem.TargetConstraint tcon = MailItem.TargetConstraint.parseConstraint(mbox, constraint);
            if (opStr.equals(OP_TAG)) {
                int tagId = (int)action.getAttributeLong(OP_TAG);
                localResults = ItemActionHelper.TAG(octxt, mbox, responseProto, local, type, flagValue, tcon, tagId).getResult();
            } else if (opStr.equals(OP_FLAG)) {
                localResults = ItemActionHelper.FLAG(octxt, mbox, responseProto, local, type, flagValue, tcon).getResult();
            } else if (opStr.equals(OP_READ)) {
                localResults = ItemActionHelper.READ(octxt, mbox, responseProto, local, type, flagValue, tcon).getResult();
            } else if (opStr.equals(OP_COLOR)) {
                MailItem.Color color = ItemAction.getColor(action);
                localResults = ItemActionHelper.COLOR(octxt, mbox, responseProto, local, type, tcon, color).getResult();
            } else if (opStr.equals(OP_HARD_DELETE)) {
                localResults = ItemActionHelper.HARD_DELETE(octxt, mbox, responseProto, local, type, tcon).getResult();
            } else if (opStr.equals(OP_MOVE)) {
                ItemId iidFolder = new ItemId(action.getAttribute("l"), zsc);
                localResults = ItemActionHelper.MOVE(octxt, mbox, responseProto, local, type, tcon, iidFolder).getResult();
            } else if (opStr.equals(OP_COPY)) {
                ItemId iidFolder = new ItemId(action.getAttribute("l"), zsc);
                localResults = ItemActionHelper.COPY(octxt, mbox, responseProto, local, type, tcon, iidFolder).getResult();
            } else if (opStr.equals(OP_SPAM)) {
                String defaultFolder = (flagValue ? 4 : 2) + "";
                ItemId iidFolder = new ItemId(action.getAttribute("l", defaultFolder), zsc);
                localResults = ItemActionHelper.SPAM(octxt, mbox, responseProto, local, type, flagValue, tcon, iidFolder).getResult();
            } else if (opStr.equals(OP_TRASH)) {
                localResults = ItemActionHelper.TRASH(octxt, mbox, responseProto, local, type, tcon).getResult();
            } else if (opStr.equals(OP_RENAME)) {
                String name = action.getAttribute("name");
                ItemId iidFolder = new ItemId(action.getAttribute("l", "-1"), zsc);
                localResults = ItemActionHelper.RENAME(octxt, mbox, responseProto, local, type, tcon, name, iidFolder).getResult();
            } else if (opStr.equals(OP_UPDATE)) {
                String folderId = action.getAttribute("l", null);
                ItemId iidFolder = new ItemId(folderId == null ? "-1" : folderId, zsc);
                if (!iidFolder.belongsTo(mbox)) {
                    throw ServiceException.INVALID_REQUEST("cannot move item between mailboxes", null);
                }
                if (folderId != null && iidFolder.getId() <= 0) {
                    throw MailServiceException.NO_SUCH_FOLDER(iidFolder.getId());
                }
                String name = action.getAttribute("name", null);
                String flags = action.getAttribute("f", null);
                String tags = action.getAttribute("t", null);
                MailItem.Color color = ItemAction.getColor(action);
                localResults = ItemActionHelper.UPDATE(octxt, mbox, responseProto, local, type, tcon, name, iidFolder, flags, tags, color).getResult();
            } else {
                throw ServiceException.INVALID_REQUEST("unknown operation: " + opStr, null);
            }
            successes.append(successes.length() > 0 ? "," : "").append(localResults);
        }
        if (remoteNotify != null) {
            this.proxyRequest(zsc.createElement(MailConstants.NO_OP_REQUEST), context, remoteNotify.getId());
        }
        return successes.toString();
    }

    public static MailItem.Color getColor(Element action) throws ServiceException {
        String rgb = action.getAttribute("rgb", null);
        byte c = (byte)action.getAttributeLong(OP_COLOR, -1L);
        if (rgb == null && c < 0) {
            return null;
        }
        if (rgb == null) {
            return new MailItem.Color(c);
        }
        return new MailItem.Color(rgb);
    }

    private Account forceRemoteSession(ZimbraSoapContext zsc, Map<String, Object> context, OperationContext octxt, String op, Element action) throws ServiceException {
        int hopCount;
        ItemId iidFolder;
        if (!zsc.isNotificationEnabled()) {
            return null;
        }
        Session session = (Session)context.get("zimbra.session");
        if (session instanceof SoapSession.DelegateSession) {
            session = ((SoapSession.DelegateSession)session).getParentSession();
        }
        if (!(session instanceof SoapSession) || session.getMailbox() == null) {
            return null;
        }
        SoapSession ss = (SoapSession)session;
        if (!(op.equals(OP_MOVE) || op.equals(OP_COPY) || op.equals(OP_SPAM) || op.equals(OP_RENAME) || op.equals(OP_UPDATE))) {
            return null;
        }
        String folderStr = action.getAttribute("l", null);
        if (folderStr == null) {
            return null;
        }
        ItemId iidRequested = iidFolder = new ItemId(folderStr, zsc);
        Account owner = null;
        ZAuthToken zat = null;
        for (hopCount = 0; hopCount < 5; ++hopCount) {
            owner = Provisioning.getInstance().getAccountById(iidFolder.getAccountId());
            if (Provisioning.onLocalServer(owner)) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(owner);
                Folder folder = mbox.getFolderById(octxt, iidFolder.getId());
                if (!(folder instanceof Mountpoint)) break;
                iidFolder = ((Mountpoint)folder).getTarget();
                continue;
            }
            if (zat == null) {
                AuthToken at = zsc.getAuthToken();
                String pxyAuthToken = at.getProxyAuthToken();
                zat = pxyAuthToken == null ? at.toZAuthToken() : new ZAuthToken(pxyAuthToken);
            }
            ZMailbox.Options zoptions = new ZMailbox.Options(zat, AccountUtil.getSoapUri(owner));
            zoptions.setNoSession(true);
            zoptions.setTargetAccount(owner.getId());
            zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
            ZMailbox zmbx = ZMailbox.getMailbox(zoptions);
            ZFolder zfolder = zmbx.getFolderById(iidFolder.toString(zsc.getAuthtokenAccountId()));
            if (!(zfolder instanceof ZMountpoint)) break;
            iidFolder = new ItemId(((ZMountpoint)zfolder).getCanonicalRemoteId(), zsc.getAuthtokenAccountId());
        }
        if (hopCount == 5) {
            throw MailServiceException.TOO_MANY_HOPS(iidRequested);
        }
        action.addAttribute("l", iidFolder.toString());
        if (iidFolder.belongsTo(session.getAuthenticatedAccountId())) {
            return null;
        }
        if (iidFolder.isLocal()) {
            ss.getDelegateSession(iidFolder.getAccountId());
            return null;
        }
        try {
            this.proxyRequest(zsc.createElement(MailConstants.NO_OP_REQUEST), context, owner.getId());
            return owner;
        }
        catch (ServiceException e) {
            return null;
        }
    }

    static void partitionItems(ZimbraSoapContext zsc, String ids, List<Integer> local, Map<String, StringBuffer> remote) throws ServiceException {
        Account acct = ItemAction.getRequestedAccount(zsc);
        String[] targets = ids.split(",");
        for (int i = 0; i < targets.length; ++i) {
            ItemId iid = new ItemId(targets[i], zsc);
            if (iid.belongsTo(acct)) {
                local.add(iid.getId());
                continue;
            }
            StringBuffer sb = remote.get(iid.getAccountId());
            if (sb == null) {
                remote.put(iid.getAccountId(), new StringBuffer(iid.toString()));
                continue;
            }
            sb.append(',').append(iid.toString());
        }
    }

    protected StringBuffer proxyRemoteItems(Element action, Map<String, StringBuffer> remote, Element request, Map<String, Object> context) throws ServiceException {
        String folderStr = action.getAttribute("l", null);
        if (folderStr != null) {
            ItemId iidFolder = new ItemId(folderStr, ItemAction.getZimbraSoapContext(context));
            action.addAttribute("l", iidFolder.toString());
        }
        StringBuffer successes = new StringBuffer();
        for (Map.Entry<String, StringBuffer> entry : remote.entrySet()) {
            String itemIds = entry.getValue().toString();
            action.addAttribute("id", itemIds);
            String accountId = entry.getKey();
            Element response = this.proxyRequest(request, context, accountId);
            try {
                String completed = response.getElement("action").getAttribute("id");
                successes.append(completed.length() > 0 && successes.length() > 0 ? "," : "").append(completed);
            }
            catch (ServiceException e) {
                ZimbraLog.misc.warn((Object)"could not extract ItemAction successes from proxied response", e);
            }
        }
        return successes;
    }
}

