/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportData
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ImportData.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = ImportData.getRequestedAccount(zsc);
        for (Element elem : request.listElements()) {
            DataSource ds;
            String id = elem.getAttribute("id", null);
            if (id != null) {
                ds = prov.get(account, Provisioning.DataSourceBy.id, id);
                if (ds == null) {
                    throw ServiceException.INVALID_REQUEST("Could not find Data Source with id " + id, null);
                }
            } else {
                String name = elem.getAttribute("name", null);
                if (name != null) {
                    ds = prov.get(account, Provisioning.DataSourceBy.name, name);
                    if (ds == null) {
                        throw ServiceException.INVALID_REQUEST("Could not find Data Source with name " + name, null);
                    }
                } else {
                    throw ServiceException.INVALID_REQUEST("must specify either 'id' or 'name'", null);
                }
            }
            ZimbraLog.addDataSourceNameToContext(ds.getName());
            DataSourceManager.importData(ds);
        }
        Element response = zsc.createElement(MailConstants.IMPORT_DATA_RESPONSE);
        return response;
    }
}

