/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.formatter.ContactCSV;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContacts
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"l"};
    String DEFAULT_FOLDER_ID = "7";

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    /*
     * Loose catch block
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        List<Map<String, String>> contacts;
        ItemId iidFolder;
        ItemIdFormatter ifmt;
        OperationContext octxt;
        Mailbox mbox;
        ZimbraSoapContext zsc;
        block17: {
            String attachment;
            BufferedReader reader;
            ArrayList<FileUploadServlet.Upload> uploads;
            block16: {
                zsc = ImportContacts.getZimbraSoapContext(context);
                mbox = ImportContacts.getRequestedMailbox(zsc);
                octxt = ImportContacts.getOperationContext(zsc, context);
                ifmt = new ItemIdFormatter(zsc);
                String folder = request.getAttribute("l", this.DEFAULT_FOLDER_ID);
                iidFolder = new ItemId(folder, zsc);
                String ct = request.getAttribute("ct");
                if (!ct.equals("csv")) {
                    throw ServiceException.INVALID_REQUEST("unsupported content type: " + ct, null);
                }
                String format = request.getAttribute("csvfmt", null);
                Element content = request.getElement("content");
                contacts = null;
                uploads = null;
                reader = null;
                attachment = content.getAttribute("aid", null);
                if (attachment == null) {
                    reader = new BufferedReader(new StringReader(content.getText()));
                } else {
                    uploads = new ArrayList<FileUploadServlet.Upload>();
                    reader = ImportContacts.parseUploadedContent(zsc, attachment, uploads);
                }
                contacts = ContactCSV.getContacts(reader, format);
                reader.close();
                Object var18_16 = null;
                if (reader == null) break block16;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (attachment != null) {
                FileUploadServlet.deleteUploads(uploads);
            }
            break block17;
            {
                catch (IOException e) {
                    throw MailServiceException.UNABLE_TO_IMPORT_CONTACTS(e.getMessage(), e);
                }
                catch (ContactCSV.ParseException e) {
                    throw MailServiceException.UNABLE_TO_IMPORT_CONTACTS(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (attachment != null) {
                    FileUploadServlet.deleteUploads(uploads);
                }
                throw throwable;
            }
        }
        List<ItemId> idsList = ImportContacts.ImportCsvContacts(octxt, mbox, iidFolder, contacts);
        StringBuilder ids = new StringBuilder();
        for (ItemId iid : idsList) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append(iid.toString(ifmt));
        }
        Element response = zsc.createElement(MailConstants.IMPORT_CONTACTS_RESPONSE);
        Element cn = response.addElement("cn");
        cn.addAttribute("ids", ids.toString());
        cn.addAttribute("n", contacts.size());
        return response;
    }

    private static BufferedReader parseUploadedContent(ZimbraSoapContext lc, String attachId, List<FileUploadServlet.Upload> uploads) throws ServiceException {
        FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(lc.getAuthtokenAccountId(), attachId, lc.getAuthToken());
        if (up == null) {
            throw MailServiceException.NO_SUCH_UPLOAD(attachId);
        }
        uploads.add(up);
        try {
            return new BufferedReader(new InputStreamReader(up.getInputStream(), "UTF-8"));
        }
        catch (IOException e) {
            throw ServiceException.FAILURE(e.getMessage(), e);
        }
    }

    public static List<ItemId> ImportCsvContacts(OperationContext oc, Mailbox mbox, ItemId iidFolder, List<Map<String, String>> csvContacts) throws ServiceException {
        LinkedList<ItemId> createdIds = new LinkedList<ItemId>();
        for (Map<String, String> contact : csvContacts) {
            String tags = ImportContacts.getTags(oc, mbox, contact);
            Contact c = mbox.createContact(oc, new ParsedContact(contact), iidFolder.getId(), tags);
            createdIds.add(new ItemId(c));
        }
        return createdIds;
    }

    public static String getTags(OperationContext octxt, Mailbox mbox, Map<String, String> contact) {
        String tags = ContactCSV.getTags(contact);
        if (tags == null) {
            return null;
        }
        StringBuilder tagIds = null;
        for (String t : tags.split(",")) {
            Tag tag = null;
            try {
                tag = mbox.getTagByName(t);
            }
            catch (ServiceException se) {
                try {
                    tag = mbox.createTag(octxt, t, (byte)0);
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            if (tag == null) continue;
            if (tagIds == null) {
                tagIds = new StringBuilder(Integer.toString(tag.getId()));
                continue;
            }
            tagIds.append(",").append(Integer.toString(tag.getId()));
        }
        return tagIds.toString();
    }
}

